/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.voidticket.VoidTicketItemDialog;

public class VoidTicketItemAction
extends PosAction {
    private TicketItem ticketItem;
    private boolean dataChanged = false;
    private Ticket ticket;
    private double voidQuantity;

    public VoidTicketItemAction(Ticket ticket, TicketItem ticketItem) {
        super(POSConstants.VOID);
        KitchenStatus kitchenStatusValue = ticketItem.getKitchenStatusValue();
        if (ticketItem.isPrintedToKitchen().booleanValue() && kitchenStatusValue == KitchenStatus.BUMP) {
            super.setRequiredPermission(UserPermission.VOID_COOKED_ITEM);
        } else if (ticketItem.isPrintedToKitchen().booleanValue()) {
            super.setRequiredPermission(UserPermission.VOID_KITCHEN_SENT_ITEM);
        }
        this.ticketItem = ticketItem;
        this.ticket = ticket;
    }

    @Override
    public void execute() {
        try {
            if (this.ticketItem == null) {
                return;
            }
            this.dataChanged = false;
            TicketDAO.getInstance().loadFullTicket(this.ticket);
            VoidTicketItemDialog dialog = new VoidTicketItemDialog(this.ticket, this.ticketItem);
            dialog.setSize(PosUIManager.getSize(400, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.dataChanged = true;
            this.voidQuantity = dialog.getVoidQuantity();
            ActionHistoryDAO.addItemVoidedActionHistory(this.ticket, this.ticketItem, this.voidQuantity);
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public static boolean checkDrawerAssignment(Terminal terminal, User user) {
        if (terminal.isCashDrawerAssigned()) {
            return true;
        }
        if (user.isStaffBank().booleanValue() && user.isStaffBankStarted().booleanValue()) {
            return true;
        }
        VoidTicketItemAction.showUnableToVoid();
        return false;
    }

    private static void showUnableToVoid() {
        POSMessageDialog.showError(Application.getPosWindow(), "Unable to perform void. Drawer has not been assigned.\nEither assign drawer or start staff bank.");
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public double getVoidQuantity() {
        return this.voidQuantity;
    }
}

