/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.EndOfDaySummaryReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class EndOfDaySummaryReporAction
extends AbstractAction {
    public EndOfDaySummaryReporAction() {
        super(POSConstants.END_OF_DAY_SUMMARY_REPORT);
    }

    public EndOfDaySummaryReporAction(String name) {
        super(name);
    }

    public EndOfDaySummaryReporAction(String name, Icon icon) {
        super(name, icon);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane tabbedPane = backOfficeWindow.getTabbedPane();
            EndOfDaySummaryReportView reportView = null;
            int index = tabbedPane.indexOfTab(POSConstants.END_OF_DAY_SUMMARY_REPORT);
            if (index == -1) {
                reportView = new EndOfDaySummaryReportView();
                tabbedPane.addTab(POSConstants.END_OF_DAY_SUMMARY_REPORT, reportView);
            } else {
                reportView = (EndOfDaySummaryReportView)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent(reportView);
        }
        catch (Exception e) {
            POSMessageDialog.showError(backOfficeWindow, e.getMessage(), e);
        }
    }
}

