/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.TaxExemptReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;

public class TaxExemptReportAction
extends AbstractAction {
    public TaxExemptReportAction() {
        super(POSConstants.TAX_EXEMPT_REPORT);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane tabbedPane = backOfficeWindow.getTabbedPane();
            TaxExemptReportView reportView = null;
            int index = tabbedPane.indexOfTab(POSConstants.TAX_EXEMPT_REPORT);
            if (index == -1) {
                reportView = new TaxExemptReportView();
                tabbedPane.addTab(POSConstants.TAX_EXEMPT_REPORT, reportView);
            } else {
                reportView = (TaxExemptReportView)tabbedPane.getComponentAt(index);
            }
            tabbedPane.setSelectedComponent(reportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

