/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import java.util.List;

public class TicketPrintAction
extends PosAction {
    private OrderInfoView view;
    private SettleTicketProcessor processor;
    private List<Ticket> tickets;

    public TicketPrintAction(OrderInfoView view, SettleTicketProcessor processor, List<Ticket> tickets) {
        this.view = view;
        this.processor = processor;
        this.tickets = tickets;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.event = e;
            if (this.tickets == null) {
                return;
            }
            Store store = DataProvider.get().getStore();
            boolean managerApprovalOn = POSUtil.getBoolean(store.getProperty("additional_print_requires.manager_approval"));
            boolean requiredManagerApproval = false;
            if (managerApprovalOn) {
                for (Ticket ticket : this.tickets) {
                    int printCountInt = POSUtil.getIntegerOrZero(ticket.getProperty("printCount"));
                    if (printCountInt <= 0) continue;
                    requiredManagerApproval = true;
                    break;
                }
            }
            if (requiredManagerApproval) {
                User user = this.getCurrentUser();
                if (user == null) {
                    return;
                }
                this.authorizedUser = user;
                if (!this.hasPermission(user, UserPermission.PERFORM_MANAGER_TASK)) {
                    return;
                }
                this.execute();
            } else {
                this.execute();
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    @Override
    public void execute() throws Exception {
        if (ReceiptPrintService.hasNoReceiptPrinters()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
            return;
        }
        if (this.view != null) {
            this.view.printCopy("Customer Copy");
        } else if (this.processor != null && this.tickets != null) {
            this.processor.printTicket(this.tickets.get(0));
        } else {
            for (Ticket ticket : this.tickets) {
                ReceiptPrintService.printTicket(ticket);
            }
        }
    }
}

