/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.AboutAction;
import com.floreantpos.actions.CacheDataUpdateAction;
import com.floreantpos.actions.DefaultPriceAction;
import com.floreantpos.actions.ImageGalleryAction;
import com.floreantpos.actions.VoidReasonAction;
import com.floreantpos.bo.actions.AttendanceHistoryAction;
import com.floreantpos.bo.actions.AttributeExplorerAction;
import com.floreantpos.bo.actions.BackofficeWindowCloseListener;
import com.floreantpos.bo.actions.CookingInstructionExplorerAction;
import com.floreantpos.bo.actions.CouponExplorerAction;
import com.floreantpos.bo.actions.CourseExplorerAction;
import com.floreantpos.bo.actions.CreditBookTypeExplorerAction;
import com.floreantpos.bo.actions.CreditCardReportAction;
import com.floreantpos.bo.actions.CronJobScheduleExplorerAction;
import com.floreantpos.bo.actions.CurrencyExplorerAction;
import com.floreantpos.bo.actions.CustomerPaymentReportAction;
import com.floreantpos.bo.actions.DataExportAction;
import com.floreantpos.bo.actions.DataImportAction;
import com.floreantpos.bo.actions.DepartmentAction;
import com.floreantpos.bo.actions.DevModeAction;
import com.floreantpos.bo.actions.DiscountReportAction;
import com.floreantpos.bo.actions.DrawerPullReportExplorerAction;
import com.floreantpos.bo.actions.EmployeeAttendanceAction;
import com.floreantpos.bo.actions.EndOfDaySummaryReporAction;
import com.floreantpos.bo.actions.GiftCardBrowserAction;
import com.floreantpos.bo.actions.GiftCardGenerateAction;
import com.floreantpos.bo.actions.GiftCardSummaryReportAction;
import com.floreantpos.bo.actions.GiftCardTransactionReportAction;
import com.floreantpos.bo.actions.HourlySalesReportAction;
import com.floreantpos.bo.actions.ItemExplorerAction;
import com.floreantpos.bo.actions.JournalReportAction;
import com.floreantpos.bo.actions.KeyStatisticsSalesReportAction;
import com.floreantpos.bo.actions.LanguageSelectionAction;
import com.floreantpos.bo.actions.MailTemplateConfigurationExplorerAction;
import com.floreantpos.bo.actions.MenuPageExplorerAction;
import com.floreantpos.bo.actions.MenuUsageReportAction;
import com.floreantpos.bo.actions.MultiplierExplorerAction;
import com.floreantpos.bo.actions.OpenTicketSummaryReportAction;
import com.floreantpos.bo.actions.OrdersTypeExplorerAction;
import com.floreantpos.bo.actions.PaymentReceivedReportAction;
import com.floreantpos.bo.actions.PayrollReportAction;
import com.floreantpos.bo.actions.PizzaItemExplorerAction;
import com.floreantpos.bo.actions.PriceExplorerAction;
import com.floreantpos.bo.actions.PromotionExplorerAction;
import com.floreantpos.bo.actions.ReceiptConfigurationExplorerAction;
import com.floreantpos.bo.actions.ReturnItemReportAction;
import com.floreantpos.bo.actions.SalesAreaExplorerAction;
import com.floreantpos.bo.actions.SalesBalanceReportAction;
import com.floreantpos.bo.actions.SalesDetailReportAction;
import com.floreantpos.bo.actions.SalesExceptionReportAction;
import com.floreantpos.bo.actions.SalesReportAction;
import com.floreantpos.bo.actions.ServerProductivityReportAction;
import com.floreantpos.bo.actions.SessionSummaryReportAction;
import com.floreantpos.bo.actions.ShiftExplorerAction;
import com.floreantpos.bo.actions.ShiftwiseSalesSummaryReportAction;
import com.floreantpos.bo.actions.StoreConfigurationAction;
import com.floreantpos.bo.actions.StoreSessionExplorerAction;
import com.floreantpos.bo.actions.TaxExplorerAction;
import com.floreantpos.bo.actions.TerminalConfigurationAction;
import com.floreantpos.bo.actions.TerminalExplorerAction;
import com.floreantpos.bo.actions.TicketExplorerAction;
import com.floreantpos.bo.actions.TracTipsReportAction;
import com.floreantpos.bo.actions.UpdateChangesAction;
import com.floreantpos.bo.actions.UserExplorerAction;
import com.floreantpos.bo.actions.UserTypeExplorerAction;
import com.floreantpos.bo.actions.VoidItemReportAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customPayment.CustomPaymentBrowserAction;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.teminaltype.TerminalTypeAction;
import com.floreantpos.ui.floorplan.ShowTableBrowserAction;
import com.floreantpos.versioning.VersionInfo;
import com.jidesoft.swing.JideTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.apache.commons.lang.StringUtils;

public class BackOfficeWindow
extends JFrame {
    private static final String POSY = "bwy";
    private static final String POSX = "bwx";
    private static final String WINDOW_HEIGHT = "bwheight";
    private static final String WINDOW_WIDTH = "bwwidth";
    private JMenu floorPlanMenu;
    private static BackOfficeWindow instance;
    private JMenuBar menuBar;
    private final User currentUser;
    private JComboBox cbReportPageSize;
    private boolean loginMode;
    private JPanel jPanel1;
    private JideTabbedPane tabbedPane;

    public BackOfficeWindow(User user) {
        this(user, false);
    }

    public BackOfficeWindow(User user, boolean loginMode) {
        this.currentUser = user;
        this.loginMode = loginMode;
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/icon.png")).getImage());
        this.initComponents();
        this.createMenus();
        this.createToolbar();
        this.positionWindow();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BackOfficeWindow.this.close();
            }
        });
        String appTitle = VersionInfo.getAppName() + " " + VersionInfo.getVersion();
        this.setTitle(appTitle + "- " + POSConstants.BACK_OFFICE);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        instance = this;
        this.initPlugins();
        JMenu helpMenu = new JMenu(Messages.getString("BackOfficeWindow.0"));
        helpMenu.add(new AboutAction());
        helpMenu.add(new UpdateChangesAction());
        this.menuBar.add(helpMenu);
    }

    private void createToolbar() {
        JToolBar toolBar = new JToolBar();
        JButton button = new JButton(new CacheDataUpdateAction(true, true));
        button.setHideActionText(false);
        button.setBorderPainted(false);
        JPanel rightPanel = new JPanel();
        JLabel lblPaperSize = new JLabel();
        lblPaperSize.setText(Messages.getString("PrintConfigurationView.10"));
        rightPanel.add(lblPaperSize);
        this.cbReportPageSize = new JComboBox<PaperSize>(PaperSize.values());
        rightPanel.add(this.cbReportPageSize);
        this.updateSelectedPaperSize();
        this.cbReportPageSize.addActionListener(e -> this.doSavePaperSize(this.cbReportPageSize.getSelectedItem()));
        rightPanel.setVisible(Application.getInstance().isDevelopmentMode());
        toolBar.add(button);
        toolBar.add(rightPanel);
        this.add((Component)toolBar, "North");
    }

    private void updateSelectedPaperSize() {
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        String property = currentTerminal.getProperty("report.paper_size");
        if (StringUtils.isNotEmpty((String)property)) {
            PaperSize paperSize = PaperSize.valueOf(property);
            this.cbReportPageSize.setSelectedItem((Object)paperSize);
        }
    }

    private void doSavePaperSize(Object object) {
        try {
            DataProvider.get().refreshCurrentTerminal();
            Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
            PaperSize selectedPaperSize = (PaperSize)((Object)object);
            currentTerminal.addProperty("report.paper_size", selectedPaperSize.name());
            TerminalDAO.getInstance().update(currentTerminal);
        }
        catch (Exception e) {
            PosLog.debug(this.getClass(), e.getMessage());
        }
    }

    private void positionWindow() {
        int width = AppConfig.getInt(WINDOW_WIDTH, 900);
        int height = AppConfig.getInt(WINDOW_HEIGHT, 650);
        this.setSize(width, height);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenSize.width - width >> 1;
        int y = screenSize.height - height >> 1;
        x = AppConfig.getInt(POSX, x);
        y = AppConfig.getInt(POSY, y);
        this.setLocation(x, y);
    }

    protected void createMenus() {
        UserType newUserType = this.currentUser.getType();
        this.menuBar = new JMenuBar();
        if (newUserType == null) {
            this.createAdminMenu(this.menuBar);
            this.createExplorerMenu(this.menuBar);
            this.createReportMenu(this.menuBar);
            this.createFloorMenu(this.menuBar);
        } else {
            if (this.currentUser.hasPermissionInAnyRole(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
                this.createAdminMenu(this.menuBar);
            }
            if (this.currentUser.hasPermissionInAnyRole(UserPermission.VIEW_EXPLORERS)) {
                this.createExplorerMenu(this.menuBar);
            }
            if (this.currentUser.hasPermissionInAnyRole(UserPermission.VIEW_REPORTS)) {
                this.createReportMenu(this.menuBar);
            }
        }
        this.createFloorMenu(this.menuBar);
        this.setJMenuBar(this.menuBar);
    }

    private void initPlugins() {
        for (FloreantPlugin plugin : ExtensionManager.getPlugins()) {
            plugin.initBackoffice(this);
        }
        for (FloreantPlugin plugin : ExtensionManager.getInactivePlugins()) {
            plugin.initAboutMenu(this);
        }
    }

    protected void createReportMenu(JMenuBar menuBar) {
        JMenu reportMenu = new JMenu(POSConstants.REPORTS);
        reportMenu.add(new SalesReportAction(true));
        reportMenu.add(new SalesReportAction(false));
        reportMenu.add(new SessionSummaryReportAction());
        reportMenu.add(new EndOfDaySummaryReporAction());
        reportMenu.add(new ShiftwiseSalesSummaryReportAction());
        reportMenu.add(new SalesBalanceReportAction());
        reportMenu.add(new KeyStatisticsSalesReportAction());
        reportMenu.add(new SalesExceptionReportAction());
        reportMenu.add(new SalesDetailReportAction());
        reportMenu.add(new MenuUsageReportAction());
        reportMenu.add(new VoidItemReportAction());
        reportMenu.add(new ReturnItemReportAction());
        reportMenu.add(new DiscountReportAction());
        reportMenu.add(new JournalReportAction());
        reportMenu.add(new JSeparator());
        reportMenu.add(new CreditCardReportAction());
        reportMenu.add(new OpenTicketSummaryReportAction());
        reportMenu.add(new JSeparator());
        reportMenu.add(new HourlySalesReportAction());
        reportMenu.add(new TracTipsReportAction());
        reportMenu.add(new PayrollReportAction());
        reportMenu.add(new ServerProductivityReportAction());
        reportMenu.add(new EmployeeAttendanceAction());
        reportMenu.add(new PaymentReceivedReportAction());
        reportMenu.add(new CustomerPaymentReportAction());
        reportMenu.add(new JSeparator());
        reportMenu.add(new GiftCardSummaryReportAction());
        reportMenu.add(new GiftCardTransactionReportAction());
        menuBar.add(reportMenu);
    }

    private void createExplorerMenu(JMenuBar menuBar) {
        JMenu explorerMenu = new JMenu(POSConstants.EXPLORERS);
        menuBar.add(explorerMenu);
        explorerMenu.add(new ItemExplorerAction());
        explorerMenu.add(new PizzaItemExplorerAction());
        explorerMenu.add(new MenuPageExplorerAction());
        explorerMenu.add(new JSeparator());
        explorerMenu.add(new ShiftExplorerAction());
        explorerMenu.add(new AttributeExplorerAction());
        explorerMenu.add(new MultiplierExplorerAction());
        explorerMenu.add(new VoidReasonAction());
        explorerMenu.add(new CookingInstructionExplorerAction());
        explorerMenu.add(new JSeparator());
        explorerMenu.add(new CourseExplorerAction());
        explorerMenu.add(new CouponExplorerAction());
        explorerMenu.add(new DefaultPriceAction());
        explorerMenu.add(new PriceExplorerAction());
        explorerMenu.add(new JSeparator());
        if (this.currentUser.hasPermissionInAnyRole(UserPermission.VIEW_GIFT_CARD)) {
            explorerMenu.add(new GiftCardBrowserAction());
        }
        explorerMenu.add(new StoreSessionExplorerAction());
        explorerMenu.add(new TicketExplorerAction());
        explorerMenu.add(new DrawerPullReportExplorerAction());
        explorerMenu.add(new JSeparator());
        explorerMenu.add(new ImageGalleryAction());
        explorerMenu.add(new JSeparator());
        explorerMenu.add(new AttendanceHistoryAction());
        explorerMenu.add(new CreditBookTypeExplorerAction());
        explorerMenu.add(new PromotionExplorerAction());
        OrderServiceExtension plugin = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (plugin == null) {
            return;
        }
        plugin.createCustomerMenu(explorerMenu);
    }

    protected void createAdminMenu(JMenuBar menuBar) {
        JMenu adminMenu = new JMenu(POSConstants.ADMIN);
        adminMenu.add(new StoreConfigurationAction());
        adminMenu.add(new TerminalConfigurationAction());
        if (this.currentUser.hasPermissionInAnyRole(UserPermission.PERFORM_ADMINISTRATIVE_TASK) || this.currentUser.hasPermissionInAnyRole(UserPermission.PERFORM_MANAGER_TASK)) {
            adminMenu.add(new ReceiptConfigurationExplorerAction());
            adminMenu.add(new MailTemplateConfigurationExplorerAction());
        }
        adminMenu.add(new JSeparator());
        adminMenu.add(new UserExplorerAction());
        adminMenu.add(new UserTypeExplorerAction());
        adminMenu.add(new JSeparator());
        adminMenu.add(new DepartmentAction());
        adminMenu.add(new SalesAreaExplorerAction());
        adminMenu.add(new TerminalExplorerAction());
        adminMenu.add(new TerminalTypeAction());
        if (TerminalConfig.isMultipleOrderSupported()) {
            adminMenu.add(new OrdersTypeExplorerAction());
        }
        adminMenu.add(new JSeparator());
        adminMenu.add((Action)new CronJobScheduleExplorerAction());
        adminMenu.add(new JSeparator());
        adminMenu.add(new CurrencyExplorerAction());
        adminMenu.add(new TaxExplorerAction());
        adminMenu.add(new CustomPaymentBrowserAction());
        adminMenu.add(new JSeparator());
        adminMenu.add(new LanguageSelectionAction());
        adminMenu.add(new JSeparator());
        adminMenu.add(new DevModeAction());
        adminMenu.add((Action)new DataExportAction());
        adminMenu.add((Action)new DataImportAction());
        adminMenu.addSeparator();
        JMenuItem closeItem = adminMenu.add(new AbstractAction(POSConstants.CLOSE){

            @Override
            public void actionPerformed(ActionEvent e) {
                BackOfficeWindow.this.close();
                if (BackOfficeWindow.this.loginMode) {
                    new BackofficeWindowCloseListener(BackOfficeWindow.this).windowClosing(null);
                }
            }
        });
        adminMenu.add(closeItem);
        menuBar.add(adminMenu);
    }

    protected void createFloorMenu(JMenuBar menuBar) {
        this.floorPlanMenu = new JMenu(Messages.getString("BackOfficeWindow.2"));
        this.floorPlanMenu.add(new ShowTableBrowserAction());
        menuBar.add(this.floorPlanMenu);
    }

    protected void createGiftCardMenu(JMenuBar menuBar) {
        JMenu giftCardMenu = new JMenu(Messages.getString("BackOfficeWindow.3"));
        giftCardMenu.add(new GiftCardGenerateAction());
        giftCardMenu.add(new GiftCardBrowserAction());
        menuBar.add(giftCardMenu);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.tabbedPane = new JideTabbedPane();
        this.tabbedPane.setFont(new Font("Sans", 0, PosUIManager.getDefaultFontSize()));
        this.tabbedPane.setTabShape(1);
        this.tabbedPane.setShowCloseButtonOnTab(true);
        this.tabbedPane.setTabInsets(new Insets(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout(5, 0));
        this.setDefaultCloseOperation(3);
        this.jPanel1.setLayout(new BorderLayout(5, 0));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel1.add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void saveSizeAndLocation() {
        AppConfig.putInt(WINDOW_WIDTH, this.getWidth());
        AppConfig.putInt(WINDOW_HEIGHT, this.getHeight());
        AppConfig.putInt(POSX, this.getX());
        AppConfig.putInt(POSY, this.getY());
    }

    public void close() {
        this.saveSizeAndLocation();
        this.dispose();
    }

    public static BackOfficeWindow getInstance() {
        return instance;
    }

    public JMenuBar getBackOfficeMenuBar() {
        return this.menuBar;
    }

    public JMenu getFloorPlanMenu() {
        return this.floorPlanMenu;
    }

    public void setFloorPlanMenu(JMenu floorPlanMenu) {
        this.floorPlanMenu = floorPlanMenu;
    }

    @Override
    public void dispose() {
        instance = null;
        super.dispose();
    }

    public User getCurrentUser() {
        return this.currentUser;
    }
}

