/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class DefaultPriceExplorer
extends TransparentPanel {
    private MenuItemDefaultPriceTable menuItemDefaultPriceTable;
    private BeanTableModel<MenuItem> tableModel;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JTextField tfName;
    private JComboBox cbGroup;
    private boolean dataModified;

    public DefaultPriceExplorer() {
        this.initcomponents();
        this.showMenuItems();
    }

    public void initcomponents() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fill", "", ""));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Default Prices");
        this.tableModel = new BeanTableModel(MenuItem.class, 50);
        this.tableModel.addColumn("NAME", "displayName");
        this.tableModel.addColumn("BARCODE", "barcode");
        this.tableModel.addColumn("COST (" + CurrencyUtil.getCurrencySymbol() + ")", "cost", 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn("MEMBER PRICE (" + CurrencyUtil.getCurrencySymbol() + ")", "price", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn("RETAIL PRICE (" + CurrencyUtil.getCurrencySymbol() + ")", "retailPrice", BeanTableModel.EditMode.EDITABLE, 11, BeanTableModel.DataType.MONEY);
        this.menuItemDefaultPriceTable = new MenuItemDefaultPriceTable(this.tableModel);
        this.menuItemDefaultPriceTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.menuItemDefaultPriceTable.setSelectionMode(0);
        this.menuItemDefaultPriceTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        DoubleTextField tfEditField = new DoubleTextField();
        tfEditField.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(tfEditField);
        editor.setClickCountToStart(1);
        this.menuItemDefaultPriceTable.setDefaultEditor(this.menuItemDefaultPriceTable.getColumnClass(3), editor);
        this.menuItemDefaultPriceTable.setDefaultEditor(this.menuItemDefaultPriceTable.getColumnClass(4), editor);
        this.menuItemDefaultPriceTable.setRowHeight(PosUIManager.getSize(30));
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.menuItemDefaultPriceTable));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        centerPanel.add((Component)scrollPane, "grow");
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][]", ""));
        this.btnBack = new JButton("<<< Previous");
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultPriceExplorer.this.dataModified && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to save?", "Confirm?") == 0) {
                    try {
                        MenuItemDAO.getInstance().saveAll(DefaultPriceExplorer.this.tableModel.getRows());
                    }
                    catch (Exception ex) {
                        POSMessageDialog.showError(DefaultPriceExplorer.this, POSConstants.ERROR_MESSAGE, ex);
                    }
                }
                DefaultPriceExplorer.this.dataModified = false;
                DefaultPriceExplorer.this.tableModel.setCurrentRowIndex(DefaultPriceExplorer.this.tableModel.getPreviousRowIndex());
                DefaultPriceExplorer.this.showMenuItems();
            }
        });
        this.btnForward = new JButton("Next >>>");
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultPriceExplorer.this.dataModified && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to save?", "Confirm?") == 0) {
                    try {
                        MenuItemDAO.getInstance().saveAll(DefaultPriceExplorer.this.tableModel.getRows());
                    }
                    catch (Exception ex) {
                        POSMessageDialog.showError(DefaultPriceExplorer.this, POSConstants.ERROR_MESSAGE, ex);
                    }
                }
                DefaultPriceExplorer.this.dataModified = false;
                DefaultPriceExplorer.this.tableModel.setCurrentRowIndex(DefaultPriceExplorer.this.tableModel.getNextRowIndex());
                DefaultPriceExplorer.this.showMenuItems();
            }
        });
        this.lblNumberOfItem = new JLabel();
        bottomPanel.add((Component)this.lblNumberOfItem, "split 3, right");
        bottomPanel.add(this.btnBack);
        bottomPanel.add(this.btnForward);
        topPanel.add((Component)titlePanel, "wrap,grow");
        topPanel.add((Component)this.searchPanel(), "grow");
        mainPanel.add((Component)topPanel, "North");
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)bottomPanel, "South");
        this.add((Component)mainPanel, "grow");
    }

    private JPanel searchPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("fill", "", ""));
        JLabel lblName = new JLabel(Messages.getString("MenuItemExplorer.0"));
        JLabel lblGroup = new JLabel(Messages.getString("MenuItemExplorer.1"));
        this.cbGroup = new JComboBox();
        this.cbGroup.addItem(Messages.getString("MenuItemExplorer.5"));
        List<MenuGroup> groups = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup group : groups) {
            this.cbGroup.addItem(group);
        }
        this.tfName = new JTextField(15);
        try {
            JButton searchBtn = new JButton(Messages.getString("MenuItemExplorer.3"));
            JButton resetBtn = new JButton("RESET");
            panel.add((Component)lblName, "split 6");
            panel.add(this.tfName);
            panel.add((Component)lblGroup, "");
            panel.add(this.cbGroup);
            panel.add(searchBtn);
            panel.add(resetBtn);
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("MenuItemExplorer.30"));
            title.setTitleJustification(1);
            panel.setBorder(title);
            searchBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultPriceExplorer.this.tableModel.setCurrentRowIndex(0);
                    DefaultPriceExplorer.this.showMenuItems();
                }
            });
            this.tfName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultPriceExplorer.this.tableModel.setCurrentRowIndex(0);
                    DefaultPriceExplorer.this.showMenuItems();
                }
            });
            resetBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultPriceExplorer.this.tfName.setText("");
                    DefaultPriceExplorer.this.cbGroup.setSelectedIndex(0);
                    DefaultPriceExplorer.this.tableModel.setCurrentRowIndex(0);
                    DefaultPriceExplorer.this.showMenuItems();
                }
            });
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void showMenuItems() {
        String txName = this.tfName.getText();
        MenuGroup group = null;
        Object selectedGroup = this.cbGroup.getSelectedItem();
        if (selectedGroup instanceof MenuGroup) {
            group = (MenuGroup)selectedGroup;
        }
        try {
            this.tableModel.setNumRows(MenuItemDAO.getInstance().rowCount(true, group, txName));
            MenuItemDAO.getInstance().loadMenuItems(this.tableModel, true, group, txName);
            int startNumber = this.tableModel.getCurrentRowIndex() + 1;
            int endNumber = this.tableModel.getNextRowIndex();
            int totalNumber = this.tableModel.getNumRows();
            if (endNumber > totalNumber) {
                endNumber = totalNumber;
            }
            this.lblNumberOfItem.setText(String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber));
            this.btnBack.setEnabled(this.tableModel.hasPrevious());
            this.btnForward.setEnabled(this.tableModel.hasNext());
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, ex);
        }
    }

    private class MenuItemDefaultPriceTable
    extends PosTable {
        public MenuItemDefaultPriceTable(BeanTableModel<MenuItem> dm) {
            super(dm);
            this.setSortable(false);
        }

        public void setValueAt(Object prices, int row, int column) {
            String receiveStr = (String)prices;
            if (receiveStr.isEmpty()) {
                return;
            }
            Double price = Double.parseDouble(receiveStr);
            MenuItem menuItem = (MenuItem)DefaultPriceExplorer.this.tableModel.getRow(row);
            super.setValueAt((Object)price, row, column);
            if (column == 3) {
                menuItem.setPrice(price);
                MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            }
            if (column == 4) {
                menuItem.setRetailPrice(price);
                MenuItemDAO.getInstance().saveOrUpdate(menuItem);
            }
        }
    }
}

