/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.FinancialAccount;
import com.floreantpos.model.dao.FinancialAccountDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.FinancialAccountEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class FinancialAccountExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<FinancialAccount> tableModel = new BeanTableModel(FinancialAccount.class);
    private JTextField tfNumber;
    private Date fromDate;
    private Date toDate;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JButton btnDelete;
    private JButton btnAdd;
    private JButton btnEdit;

    public FinancialAccountExplorer() {
        this.tableModel.addColumn("NAME", "name");
        List<FinancialAccount> findAll = FinancialAccountDAO.getInstance().findAll();
        this.tableModel.addRows(findAll);
        this.table = new JXTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(30);
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
        this.resizeColumnWidth((JTable)this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FinancialAccountExplorer.this.table.getSelectedRow() < 0) {
                    // empty if block
                }
            }
        });
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        return panel;
    }

    private void searchItem() {
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        this.btnAdd = explorerButton.getAddButton();
        this.btnEdit = explorerButton.getEditButton();
        this.btnDelete = explorerButton.getDeleteButton();
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FinancialAccountExplorer.this.editSelectedRow();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FinancialAccount item = new FinancialAccount();
                    FinancialAccountEntryForm editor = new FinancialAccountEntryForm(item);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    FinancialAccount faObj = (FinancialAccount)editor.getBean();
                    FinancialAccountExplorer.this.tableModel.addRow(faObj);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = FinancialAccountExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = FinancialAccountExplorer.this.table.convertRowIndexToModel(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    FinancialAccount item = (FinancialAccount)FinancialAccountExplorer.this.tableModel.getRow(index);
                    FinancialAccountDAO financialAccountDAO = new FinancialAccountDAO();
                    financialAccountDAO.delete(item);
                    FinancialAccountExplorer.this.tableModel.removeRow(index);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(this.btnAdd);
        panel.add(this.btnEdit);
        panel.add(this.btnDelete);
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(150);
        columnWidth.add(100);
        columnWidth.add(70);
        columnWidth.add(230);
        columnWidth.add(70);
        columnWidth.add(70);
        columnWidth.add(85);
        columnWidth.add(90);
        columnWidth.add(70);
        columnWidth.add(50);
        columnWidth.add(50);
        columnWidth.add(50);
        columnWidth.add(70);
        columnWidth.add(50);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            FinancialAccount item = this.tableModel.getRow(index);
            item = FinancialAccountDAO.getInstance().initialize(item);
            this.tableModel.setRow(index, item);
            FinancialAccountEntryForm editor = new FinancialAccountEntryForm(item);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

