/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InventoryUnitGroupEntryForm
extends BeanEditor<InventoryUnitGroup> {
    private POSTextField tfGroupName;
    private InventoryUnitGroup inventoryUnitGroup;

    public InventoryUnitGroupEntryForm(InventoryUnitGroup inventoryUnitGroup) {
        this.inventoryUnitGroup = inventoryUnitGroup;
        this.setLayout(new BorderLayout());
        this.createUI();
        this.setBean(inventoryUnitGroup);
    }

    public InventoryUnitGroupEntryForm() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void createUI() {
        JPanel itemInfoPanel = new JPanel();
        this.add((Component)itemInfoPanel, "Center");
        itemInfoPanel.setLayout((LayoutManager)new MigLayout("fill,center", "[][]", ""));
        JLabel lblGroupName = new JLabel(Messages.getString("NAME"));
        itemInfoPanel.add((Component)lblGroupName, "cell 0 0,alignx right");
        this.tfGroupName = new POSTextField();
        itemInfoPanel.add((Component)this.tfGroupName, "cell 1 0");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
            InventoryUnitGroupDAO inventoryUnitGroupDAO = new InventoryUnitGroupDAO();
            inventoryUnitGroupDAO.saveOrUpdate(inventoryUnitGroup);
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
        }
        return false;
    }

    @Override
    public void updateView() {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
        if (inventoryUnitGroup == null) {
            return;
        }
        this.tfGroupName.setText(inventoryUnitGroup.getName());
    }

    @Override
    public boolean updateModel() {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
        if (inventoryUnitGroup == null) {
            return false;
        }
        String groupName = this.tfGroupName.getText();
        GenericDAO.getInstance().checkIdOrNameExists(inventoryUnitGroup.getId(), groupName, InventoryUnitGroup.class);
        inventoryUnitGroup.setName(groupName);
        return true;
    }

    @Override
    public String getDisplayText() {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
        if (inventoryUnitGroup.getId() == null) {
            return Messages.getString("InventoryUnitGroupEntryForm.6");
        }
        return Messages.getString("InventoryUnitGroupEntryForm.7");
    }
}

