/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Address;
import com.floreantpos.model.Department;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class OutletEntryForm
extends BeanEditor<Outlet> {
    private Outlet outlet;
    private FixedLengthTextField txtName;
    private JTextField tfAddress;
    private JTextArea tfDesc;
    private CheckBoxList departmentlist = new CheckBoxList();

    public OutletEntryForm(Outlet outlet) {
        this.outlet = outlet;
        this.initComponents();
        this.initData();
        this.setBean(outlet);
    }

    public void initData() {
        List<Department> departmentTypes = DepartmentDAO.getInstance().findAll();
        if (departmentTypes == null) {
            return;
        }
        this.departmentlist.setModel(departmentTypes);
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("wrap 2,fillx", "[][grow]", ""));
        JLabel lblName = new JLabel(Messages.getString("NAME"));
        this.txtName = new FixedLengthTextField();
        this.txtName.setLength(20);
        this.tfAddress = new JTextField();
        this.tfDesc = new JTextArea(5, 5);
        contentPanel.add((Component)lblName, "alignx trailing");
        contentPanel.add((Component)this.txtName, "growx");
        JLabel lblAddress = new JLabel(Messages.getString("OutletEntryForm.6"));
        contentPanel.add((Component)lblAddress, "alignx trailing");
        contentPanel.add((Component)this.tfAddress, "growx");
        JLabel lblDesc = new JLabel(Messages.getString("OutletEntryForm.9"));
        contentPanel.add((Component)lblDesc, "alignx trailing");
        this.tfDesc.setLineWrap(true);
        contentPanel.add((Component)new JScrollPane(this.tfDesc), "growx,h 100!");
        this.departmentlist.setEnabled(true);
        TitledBorder titelDepertment = new TitledBorder(Messages.getString("OutletEntryForm.12"));
        JScrollPane departmentPane = new JScrollPane(this.departmentlist);
        departmentPane.setBorder(titelDepertment);
        contentPanel.add((Component)departmentPane, "skip 1, h 200px");
        this.add(contentPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Outlet item = (Outlet)this.getBean();
            OutletDAO outletDAO = new OutletDAO();
            outletDAO.saveOrUpdate(item);
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Outlet item = (Outlet)this.getBean();
        this.txtName.setText(item.getName());
        if (item.getAddress() != null) {
            this.tfAddress.setText(item.getAddress().getAddressLine());
        }
        this.tfDesc.setText(item.getDescription());
        this.departmentlist.selectItems(item.getDepartments());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Outlet term = (Outlet)this.getBean();
        String name = this.txtName.getText();
        String txtAddress = this.tfAddress.getText();
        String description = this.tfDesc.getText();
        Address address = new Address();
        address.setAddressLine(txtAddress);
        if (name == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OutletEntryForm.14"));
            return false;
        }
        this.outlet.setName(name);
        this.outlet.setAddress(address);
        this.outlet.setDescription(description);
        this.outlet.setDepartments(this.departmentlist.getCheckedValues());
        AddressDAO.getInstance().saveOrUpdate(address);
        return true;
    }

    @Override
    public String getDisplayText() {
        Outlet item = (Outlet)this.getBean();
        if (item.getId() == null) {
            return Messages.getString("OutletEntryForm.15");
        }
        return Messages.getString("OutletEntryForm.16");
    }
}

