/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.UserForm;
import com.floreantpos.ui.model.UserRoleForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class UserExplorer
extends TransparentPanel {
    private JXTreeTable treeTable = new JXTreeTable();
    private UserTreeTableModel treeTableModel;
    private JButton btnAddRole;
    private JButton btnCopy;
    private JButton btnBack;
    private JButton btnForward;
    private JLabel lblNumberOfItem;
    private JTextField txtSearchField;

    public UserExplorer() {
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowGrid(true, true);
        this.treeTable.setRowHeight(PosUIManager.getSize(30));
        this.treeTable.setLeafIcon(null);
        this.treeTable.setOpenIcon(null);
        this.treeTable.setClosedIcon(null);
        this.treeTable.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.btnBack = new JButton(Messages.getString("UserExplorer.0"));
        this.btnForward = new JButton(Messages.getString("UserExplorer.1"));
        this.lblNumberOfItem = new JLabel();
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = UserExplorer.this.treeTable.getSelectedRow();
                if (index < 0) {
                    return;
                }
                TreePath treePath = UserExplorer.this.treeTable.getPathForRow(index);
                DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                User user = (User)lastPathComponent.getUserObject();
                if (user == null) {
                    return;
                }
                UserExplorer.this.btnAddRole.setEnabled(user.isRoot());
                UserExplorer.this.btnCopy.setEnabled(user.isRoot());
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.createSearchPanel(), "North");
        this.buildUserTree();
        this.treeTable.expandAll();
        this.treeTable.collapseAll();
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int col = UserExplorer.this.treeTable.columnAtPoint(me.getPoint());
                if (me.getClickCount() == 2 && col == 0) {
                    UserExplorer.this.treeTable.expandPath(UserExplorer.this.treeTable.getPathForRow(UserExplorer.this.treeTable.getSelectedRow()));
                } else if (me.getClickCount() == 2 && col != 0) {
                    UserExplorer.this.editSelectedRow();
                }
            }
        });
        this.add((Component)new JScrollPane((Component)this.treeTable), "Center");
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UserForm editor = new UserForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(800, 600);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    User newUser = (User)editor.getBean();
                    MutableTreeTableNode root = (MutableTreeTableNode)UserExplorer.this.treeTableModel.getRoot();
                    UserExplorer.this.treeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)newUser), root, root.getChildCount());
                }
                catch (Exception x) {
                    PosLog.error(this.getClass(), x);
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.btnCopy = new JButton(POSConstants.COPY);
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = UserExplorer.this.treeTable.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserExplorer.2"));
                        return;
                    }
                    TreePath treePath = UserExplorer.this.treeTable.getPathForRow(index);
                    DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    User user = (User)lastPathComponent.getUserObject();
                    if (!user.isRoot().booleanValue()) {
                        return;
                    }
                    User user2 = new User();
                    user2.setId(user.getId());
                    user2.setType(user.getType());
                    user2.setFirstName(user.getFirstName());
                    user2.setLastName(user.getLastName());
                    user2.setPassword(user.getPassword());
                    user2.setSsn(user.getSsn());
                    UserForm editor = new UserForm();
                    editor.setEditMode(false);
                    editor.setBean(user2);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(800, 600);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    User newUser = (User)editor.getBean();
                    MutableTreeTableNode root = (MutableTreeTableNode)UserExplorer.this.treeTableModel.getRoot();
                    UserExplorer.this.treeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)newUser), root, root.getChildCount());
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserExplorer.this.editSelectedRow();
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = UserExplorer.this.treeTable.getSelectedRow();
                if (index < 0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                    return;
                }
                TreePath treePath = UserExplorer.this.treeTable.getPathForRow(index);
                DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                User user = (User)lastPathComponent.getUserObject();
                if (user == null) {
                    return;
                }
                UserDAO.getInstance().refresh(user);
                User currentUser = Application.getCurrentUser();
                if (currentUser != null && currentUser.getId().equals(user.getId())) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserExplorer.3"));
                    return;
                }
                if (currentUser != null && currentUser.getParentUser() != null && currentUser.getParentUser().getId().equals(user.getId())) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserExplorer.6"));
                    return;
                }
                try {
                    if (ConfirmDeleteDialog.showMessage(UserExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        if (user.isClockedIn().booleanValue()) {
                            if (ConfirmDeleteDialog.showMessage(UserExplorer.this, user.getFullName() + " " + Messages.getString("UserExplorer.5"), POSConstants.DELETE) == 0) {
                                user.setClockedIn(false);
                                user.setLastClockOutTime(new Date());
                            } else {
                                return;
                            }
                        }
                        UserDAO.getInstance().delete(user);
                        MutableTreeTableNode tableNode = UserExplorer.this.findTreeNodeForUser((MutableTreeTableNode)UserExplorer.this.treeTableModel.getRoot(), user.getId());
                        if (tableNode.getParent() != null) {
                            UserExplorer.this.treeTableModel.removeNodeFromParent(tableNode);
                        }
                    }
                }
                catch (ConstraintViolationException x) {
                    String message = POSConstants.USER + " " + user.getFirstName() + " " + user.getLastName() + " (" + user.getType() + ") " + POSConstants.ERROR_MESSAGE;
                    BOMessageDialog.showError(message, x);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.btnAddRole = new JButton(Messages.getString("UserExplorer.4"));
        this.btnAddRole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserExplorer.this.addNewRole();
            }
        });
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserExplorer.this.treeTableModel.setCurrentRowIndex(UserExplorer.this.treeTableModel.getPreviousRowIndex());
                UserExplorer.this.buildUserTree();
                UserExplorer.this.treeTable.expandAll();
                UserExplorer.this.treeTable.collapseAll();
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserExplorer.this.treeTableModel.setCurrentRowIndex(UserExplorer.this.treeTableModel.getNextRowIndex());
                UserExplorer.this.buildUserTree();
                UserExplorer.this.treeTable.expandAll();
                UserExplorer.this.treeTable.collapseAll();
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fill", "[right][]"));
        TransparentPanel panel = new TransparentPanel();
        panel.add(editButton);
        panel.add(deleteButton);
        panel.add(this.btnAddRole);
        bottomPanel.add((Component)panel, "");
        JPanel navigationPanel = new JPanel(new FlowLayout(4));
        navigationPanel.add(this.lblNumberOfItem);
        navigationPanel.add(this.btnBack);
        navigationPanel.add(this.btnForward);
        bottomPanel.add((Component)navigationPanel, "grow");
        this.add((Component)bottomPanel, "South");
    }

    private JPanel createSearchPanel() {
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout());
        JLabel lblFind = new JLabel(Messages.getString("UserExplorer.10"));
        this.txtSearchField = new JTextField(20);
        JButton btnSearch = new JButton(Messages.getString("Search"));
        JButton btnClear = new JButton(Messages.getString("UserExplorer.12"));
        this.txtSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserExplorer.this.doSearchUser();
            }
        });
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserExplorer.this.doSearchUser();
            }
        });
        btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserExplorer.this.txtSearchField.setText("");
            }
        });
        searchPanel.add(lblFind);
        searchPanel.add((Component)this.txtSearchField, "grow");
        searchPanel.add(btnSearch);
        searchPanel.add(btnClear);
        return searchPanel;
    }

    private MutableTreeTableNode findTreeNodeForUser(MutableTreeTableNode userNode, String id) {
        User user = (User)userNode.getUserObject();
        if (id.equals(user.getId())) {
            return userNode;
        }
        Enumeration children = userNode.children();
        while (children.hasMoreElements()) {
            MutableTreeTableNode treeTableNode = (MutableTreeTableNode)children.nextElement();
            MutableTreeTableNode findUserById = this.findTreeNodeForUser(treeTableNode, id);
            if (findUserById == null) continue;
            return findUserById;
        }
        return null;
    }

    private void buildUserTree() {
        int totalNumber;
        User dummy = new User();
        dummy.setId("0");
        dummy.setFirstName("Root");
        DefaultMutableTreeTableNode root = new DefaultMutableTreeTableNode((Object)dummy);
        root.setUserObject((Object)dummy);
        if (this.treeTableModel == null) {
            this.treeTableModel = new UserTreeTableModel(root);
            this.treeTable.setTreeTableModel((TreeTableModel)this.treeTableModel);
        } else {
            this.treeTableModel.setRoot((TreeTableNode)root);
        }
        String strFilter = this.txtSearchField.getText();
        this.treeTableModel.setNumRows(UserDAO.getInstance().rowCount(strFilter));
        List<User> userList = UserDAO.getInstance().loadUsers(this.treeTableModel, strFilter);
        for (User user : userList) {
            DefaultMutableTreeTableNode userNode = new DefaultMutableTreeTableNode((Object)user);
            List<User> linkedUserList = user.getLinkedUser();
            for (User linkedUser : linkedUserList) {
                if (linkedUser.isRoot().booleanValue() || linkedUser.isDeleted().booleanValue()) continue;
                DefaultMutableTreeTableNode node = new DefaultMutableTreeTableNode((Object)linkedUser);
                userNode.add((MutableTreeTableNode)node);
            }
            root.add((MutableTreeTableNode)userNode);
        }
        int startNumber = this.treeTableModel.getCurrentRowIndex() + 1;
        int endNumber = this.treeTableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.treeTableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("UserExplorer.17"), startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.treeTableModel.hasPrevious());
        this.btnForward.setEnabled(this.treeTableModel.hasNext());
    }

    private void editSelectedRow() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            User user = (User)lastPathComponent.getUserObject();
            if (!user.isRoot().booleanValue()) {
                UserRoleForm editor = new UserRoleForm(user);
                BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                dialog.openWithScale(800, 600);
                if (dialog.isCanceled()) {
                    return;
                }
            } else {
                UserForm editor = new UserForm();
                editor.setEditMode(true);
                editor.setBean(user);
                BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                dialog.openWithScale(800, 600);
                if (dialog.isCanceled()) {
                    return;
                }
            }
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void addNewRole() {
        try {
            int index = this.treeTable.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("UserExplorer.19"));
                return;
            }
            TreePath treePath = this.treeTable.getPathForRow(index);
            DefaultMutableTreeTableNode lastPathComponent = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            User user = (User)lastPathComponent.getUserObject();
            User roleUser = new User();
            roleUser.setParentUser(user);
            UserRoleForm editor = new UserRoleForm(roleUser);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(800, 600);
            if (dialog.isCanceled()) {
                return;
            }
            User parentUser = roleUser.getParentUser();
            MutableTreeTableNode root = (MutableTreeTableNode)this.treeTableModel.getRoot();
            if (parentUser != null) {
                MutableTreeTableNode parentNode = this.findTreeNodeForUser(root, parentUser.getId());
                if (parentNode != null) {
                    this.treeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)roleUser), parentNode, parentNode.getChildCount());
                }
            } else {
                MutableTreeTableNode parentNode = this.findTreeNodeForUser(root, Messages.getString("UserExplorer.20"));
                if (parentNode != null) {
                    this.treeTableModel.insertNodeInto((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)roleUser), parentNode, parentNode.getChildCount());
                }
            }
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doSearchUser() {
        this.treeTableModel.setCurrentRowIndex(0);
        this.buildUserTree();
        this.treeTable.expandAll();
        this.treeTable.collapseAll();
    }

    class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            if (hasFocus) {
                this.setBorder(UIManager.getBorder(Messages.getString("UserExplorer.32")));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }

    class UserTreeTableModel
    extends DefaultTreeTableModel
    implements PaginationSupport {
        private final String[] COLUMN_NAMES;
        private int numRows;
        private int currentRowIndex;
        private int pageSize;

        public UserTreeTableModel(DefaultMutableTreeTableNode rootLocation) {
            super((TreeTableNode)rootLocation);
            this.COLUMN_NAMES = new String[]{POSConstants.ID, Messages.getString("UserExplorer.21"), POSConstants.FIRST_NAME, POSConstants.LAST_NAME, Messages.getString("colRole"), Messages.getString("ACTIVE"), Messages.getString("UserExplorer.23"), Messages.getString("UserExplorer.24"), Messages.getString("UserExplorer.25"), Messages.getString("UserExplorer.26")};
            this.pageSize = 50;
        }

        public void setRoot(TreeTableNode root) {
            super.setRoot(root);
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int column) {
            return this.COLUMN_NAMES[column];
        }

        public boolean isCellEditable(Object node, int column) {
            return false;
        }

        public Object getValueAt(Object node, int column) {
            if (node instanceof DefaultMutableTreeTableNode) {
                User user = (User)((DefaultMutableTreeTableNode)node).getUserObject();
                if (user == null) {
                    return "";
                }
                boolean linkedUser = user.isRoot() == false;
                switch (column) {
                    case 0: {
                        return linkedUser ? "" : String.valueOf(user.getId());
                    }
                    case 1: {
                        return linkedUser ? "" : user.getImage();
                    }
                    case 2: {
                        return linkedUser ? "" : user.getFirstName();
                    }
                    case 3: {
                        return linkedUser ? "" : user.getLastName();
                    }
                    case 4: {
                        return user.getType();
                    }
                    case 5: {
                        return user.isActive();
                    }
                    case 6: {
                        return user.isStaffBank();
                    }
                    case 7: {
                        return user.isAutoStartStaffBank();
                    }
                    case 8: {
                        return user.isAllowReceiveTips();
                    }
                    case 9: {
                        return user.isDriver();
                    }
                }
            }
            return null;
        }

        @Override
        public int getNumRows() {
            return this.numRows;
        }

        @Override
        public void setNumRows(int numRows) {
            this.numRows = numRows;
        }

        @Override
        public int getCurrentRowIndex() {
            return this.currentRowIndex;
        }

        @Override
        public void setCurrentRowIndex(int currentRowIndex) {
            this.currentRowIndex = currentRowIndex;
        }

        @Override
        public int getPageSize() {
            return this.pageSize;
        }

        @Override
        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public boolean hasNext() {
            return this.currentRowIndex + this.pageSize < this.numRows;
        }

        @Override
        public boolean hasPrevious() {
            return this.currentRowIndex > 0;
        }

        @Override
        public int getNextRowIndex() {
            if (this.numRows == 0) {
                return 0;
            }
            return this.getCurrentRowIndex() + this.getPageSize();
        }

        @Override
        public int getPreviousRowIndex() {
            int i = this.getCurrentRowIndex() - this.getPageSize();
            if (i < 0) {
                i = 0;
            }
            return i;
        }

        @Override
        public void setRows(List rows) {
        }
    }
}

