/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidReasonDialog;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTable;

public class VoidReasonExplorer
extends TransparentPanel
implements RefreshableView {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<VoidReason> tableModel = new BeanTableModel(VoidReason.class);

    public VoidReasonExplorer() {
        this.tableModel.addColumn(Messages.getString("VoidReasonExplorer.0"), "reasonText");
        this.tableModel.addRows(VoidReasonDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new MultiLineTableCellRenderer());
        this.table.setAlignmentY(1.0f);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    VoidReasonExplorer.this.doEditVoidReason();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        addButton.addActionListener(e -> this.doAddVoidReason());
        editButton.addActionListener(e -> this.doEditVoidReason());
        deleteButton.addActionListener(e -> this.doDeleteVoidReason());
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        return panel;
    }

    private void doEditVoidReason() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            VoidReason voidReason = this.tableModel.getRow(index);
            VoidReasonDialog dialog = new VoidReasonDialog();
            dialog.setCaption(Messages.getString("VoidReasonExplorer.2"));
            dialog.setPreferredSize(PosUIManager.getSize(500, 300));
            dialog.setVoidReason(voidReason.getReasonText());
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            String reason = dialog.getVoidReason();
            voidReason.setReasonText(reason.trim());
            VoidReasonDAO.getInstance().saveOrUpdate(voidReason);
            this.table.repaint();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    private void doAddVoidReason() {
        try {
            VoidReasonDialog dialog = new VoidReasonDialog();
            dialog.setCaption(Messages.getString("VoidReasonExplorer.3"));
            dialog.setPreferredSize(PosUIManager.getSize(500, 300));
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            String reason = dialog.getVoidReason();
            VoidReason voidReason = new VoidReason();
            voidReason.setReasonText(reason.trim());
            VoidReasonDAO.getInstance().saveOrUpdate(voidReason);
            this.tableModel.addRow(voidReason);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    private void doDeleteVoidReason() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToDelete"));
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("VoidReasonExplorer.1"), POSConstants.CONFIRM) != 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            VoidReason voidReason = this.tableModel.getRow(index);
            VoidReasonDAO.getInstance().delete(voidReason);
            this.tableModel.removeRow(index);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    @Override
    public void refresh() {
        this.tableModel.removeAll();
        this.tableModel.addRows(VoidReasonDAO.getInstance().findAll());
        this.table.repaint();
    }
}

