/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.ui.model.MultipleCustomerSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class CustomerSelectionDialog
extends POSDialog
implements ActionListener {
    private MultipleCustomerSelectionView customerSelectorPanel;
    private List<Customer> customerList;
    private boolean singleSelectionEnable;
    private TitlePanel titelpanel;
    private static CustomerSelectionDialog instance;

    public CustomerSelectionDialog(JDialog parent, List<Customer> customerList) {
        super(parent, "", true);
        this.customerList = customerList;
        this.init();
    }

    public CustomerSelectionDialog(List<Customer> customerList) {
        super(POSUtil.getFocusedWindow(), "");
        this.customerList = customerList;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(Messages.getString("CustomerSelectionDialog.1"));
        this.titelpanel = new TitlePanel();
        this.titelpanel.setTitle(Messages.getString("CustomerSelectionDialog.4"));
        this.add((Component)this.titelpanel, "North");
        this.customerSelectorPanel = new MultipleCustomerSelectionView(this.customerList);
        PosSmallButton btnOk = new PosSmallButton(POSConstants.SELECT);
        btnOk.setActionCommand(POSConstants.OK);
        btnOk.setBackground(Color.GREEN);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosSmallButton btnCancel = new PosSmallButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 12 5", "", ""));
        PosSmallButton btnEdit = new PosSmallButton();
        PosSmallButton btnAdd = new PosSmallButton();
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerSelectionDialog.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    boolean setKeyPad = true;
                    CustomerForm editor = new CustomerForm(setKeyPad);
                    editor.enableCustomerFields(true);
                    BeanEditorDialog dialog = new BeanEditorDialog(editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Customer customer = (Customer)editor.getBean();
                    CustomerSelectionDialog.this.customerSelectorPanel.getModel().addRow(customer);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        footerPanel.add(btnAdd);
        footerPanel.add(btnEdit);
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)this.customerSelectorPanel, "Center");
        this.add((Component)footerPanel, "South");
    }

    public void setSingleSelectionEnable(boolean enable) {
        this.singleSelectionEnable = enable;
        if (enable) {
            this.titelpanel.setTitle(Messages.getString("CustomerSelectionDialog.9"));
        }
        this.customerSelectorPanel.setSingleSelectionEnable(enable);
    }

    public void setSelectedGroup(CustomerGroup customerGroup) {
        this.customerSelectorPanel.setSelectedGroup(customerGroup);
    }

    private void doOk() {
        if (this.singleSelectionEnable) {
            Customer customer = this.getSelectedRowData();
            if (customer == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustomerSelectionDialog.10"));
                return;
            }
        } else {
            List<Customer> customerList = this.customerSelectorPanel.getSelectedCustomerList();
            if (customerList == null || customerList.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustomerSelectionDialog.11"));
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    private void editSelectedRow() {
        try {
            int index = this.customerSelectorPanel.getSelectedRow();
            if (index < 0) {
                return;
            }
            Customer customer = this.customerSelectorPanel.getModel().getRow(index);
            CustomerForm editor = new CustomerForm();
            editor.enableCustomerFields(true);
            editor.setBean(customer);
            BeanEditorDialog dialog = new BeanEditorDialog(editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.customerSelectorPanel.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<Customer> getSelectedCustomerList() {
        return this.customerSelectorPanel.getSelectedCustomerList();
    }

    public Customer getSelectedRowData() {
        int index = this.customerSelectorPanel.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return this.customerSelectorPanel.getModel().getRow(index);
    }

    public static CustomerSelectionDialog getInstance(List<Customer> customerList, boolean singleSelection) {
        if (instance == null) {
            instance = new CustomerSelectionDialog(customerList);
            instance.setSingleSelectionEnable(singleSelection);
        }
        return instance;
    }
}

