/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuModifierForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class ModifierPageItemSelectionDialog
extends POSDialog {
    private JXTable table;
    private BeanTableModel<MenuModifier> tableModel;
    private JTextField tfName;
    private MenuModifier selectedMenuModifier;
    private final PaginatedListModel dataModel = new PaginatedListModel(20);
    private PosButton btnNext;
    private PosButton btnPrev;
    private ModifierGroup selectedGroup;
    private static ModifierPageItemSelectionDialog instance;
    private MenuItemModifierSpec modifierSpec;
    private String exstingPageName;
    private List modifierList;
    private TableRowSorter<TableModel> sorter;

    public ModifierPageItemSelectionDialog() {
        super(POSUtil.getFocusedWindow(), "");
        this.init();
        this.dataModel.setCurrentRowIndex(0);
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(MenuModifier.class);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", "price");
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.sorter = new TableRowSorter<BeanTableModel<MenuModifier>>(this.tableModel);
        this.table.setRowSorter(this.sorter);
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ModifierPageItemSelectionDialog.this.editSelectedRow();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        contentPanel.add(new JScrollPane((Component)this.table));
        contentPanel.add((Component)this.buildSearchForm(), "North");
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)this.table);
        this.add((Component)this.createButtonPanel(), "South");
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "", ""));
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        paginationButtonPanel.add((Component)this.btnPrev, "split 3,center");
        PosButton btnDot = new PosButton();
        btnDot.setBorder(null);
        btnDot.setOpaque(false);
        btnDot.setContentAreaFilled(false);
        btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        paginationButtonPanel.add((Component)btnDot, "w 10!");
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        paginationButtonPanel.add(this.btnNext);
        paginationButtonPanel.add((Component)new JSeparator(), "newline,span,grow");
        contentPanel.add((Component)paginationButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == ModifierPageItemSelectionDialog.this.btnPrev) {
                        ModifierPageItemSelectionDialog.this.scrollUp();
                    } else if (source == ModifierPageItemSelectionDialog.this.btnNext) {
                        ModifierPageItemSelectionDialog.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("inset 5 0 5 0", "[][grow][][][]", "[]5[]"));
        JLabel lblName = new JLabel(POSConstants.NAME);
        this.tfName = new JTextField(15);
        JButton searchBttn = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        panel.add((Component)lblName, "align label");
        panel.add((Component)this.tfName, "grow");
        panel.add(searchBttn);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        title.setTitleJustification(1);
        panel.setBorder(title);
        searchBttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageItemSelectionDialog.this.searchItem();
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageItemSelectionDialog.this.searchItem();
            }
        });
        return panel;
    }

    private void searchItem() {
        this.setDataModel(this.dataModel);
        if (this.dataModel.getSize() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        JButton btnOk = new JButton(Messages.getString("ModifierPageItemSelectionDialog.12"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageItemSelectionDialog.this.doOk();
            }
        });
        JButton btnCancel = new JButton(POSConstants.CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageItemSelectionDialog.this.setCanceled(true);
                ModifierPageItemSelectionDialog.this.dispose();
            }
        });
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageItemSelectionDialog.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuModifier menuItem = new MenuModifier();
                    MenuModifierForm editor = new MenuModifierForm(menuItem);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuModifier foodItem = (MenuModifier)editor.getBean();
                    ModifierPageItemSelectionDialog.this.tableModel.addRow(foodItem);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        btnOk.setBackground(Color.GREEN);
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0 0 5 0", "sg,fill", ""));
        int h = PosUIManager.getSize(40);
        panel.add((Component)btnAdd, "h " + h);
        panel.add((Component)btnEdit, "h " + h);
        panel.add((Component)btnOk, "h " + h);
        panel.add((Component)btnCancel, "h " + h);
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(10);
        columnWidth.add(400);
        columnWidth.add(70);
        columnWidth.add(70);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuModifier menuModifier = this.tableModel.getRow(index);
            this.tableModel.setRow(index, menuModifier);
            MenuModifierForm editor = new MenuModifierForm(menuModifier);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doOk() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.table.convertRowIndexToModel(index);
        this.selectedMenuModifier = this.tableModel.getRow(index);
        if (this.modifierSpec != null && this.hasSimilarItem()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ModifierPageItemSelectionDialog.20") + this.exstingPageName);
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    private boolean hasSimilarItem() {
        Set<MenuItemModifierPage> pages = this.modifierSpec.getModifierPages();
        if (pages == null) {
            return false;
        }
        for (MenuItemModifierPage page : pages) {
            List<MenuItemModifierPageItem> pageItems = page.getPageItems();
            if (pageItems == null) continue;
            for (MenuItemModifierPageItem pageItem : pageItems) {
                MenuModifier modifier = pageItem.getMenuModifier();
                if (modifier == null || !modifier.getId().equals(this.selectedMenuModifier.getId())) continue;
                this.exstingPageName = page.getName();
                return true;
            }
        }
        return false;
    }

    public MenuModifier getSelectedMenuModifier() {
        return this.selectedMenuModifier;
    }

    public void setSelectedMenuModifier(MenuModifier selectedMenuModifier) {
        this.selectedMenuModifier = selectedMenuModifier;
        if (selectedMenuModifier != null) {
            this.searchItem();
        }
    }

    private void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.setDataModel(this.dataModel);
    }

    private void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.setDataModel(this.dataModel);
    }

    private void setDataModel(PaginatedListModel dataModel) {
        this.tableModel.removeAll();
        this.modifierList = dataModel.getDataList();
        String txName = this.tfName.getText();
        if (txName.length() == 0) {
            this.sorter.setRowFilter(null);
        } else {
            this.tableModel.addRows(this.modifierList);
            this.sorter.setRowFilter(RowFilter.regexFilter(txName, new int[0]));
        }
        int nextRowIndex = dataModel.getNextRowIndex();
        this.tableModel.addRows(this.modifierList.subList(dataModel.getCurrentRowIndex(), nextRowIndex > dataModel.getSize() ? dataModel.getSize() : nextRowIndex));
        this.btnNext.setEnabled(dataModel.hasNext());
        this.btnPrev.setEnabled(dataModel.hasPrevious());
    }

    public void setSelectedModifierGroup(ModifierGroup modifierGroup) {
        if (this.selectedGroup != null && modifierGroup.getId().equals(this.selectedGroup.getId())) {
            return;
        }
        this.selectedGroup = ModifierGroupDAO.getInstance().get(modifierGroup.getId());
        this.dataModel.setCurrentRowIndex(0);
        List<MenuModifier> modifiers = modifierGroup.getModifiers();
        if (modifiers == null) {
            return;
        }
        this.dataModel.setNumRows(modifiers.size());
        this.dataModel.setData(modifiers);
        this.setDataModel(this.dataModel);
    }

    public static ModifierPageItemSelectionDialog getInstance(ModifierGroup modifierGroup) {
        if (instance == null) {
            instance = new ModifierPageItemSelectionDialog();
        }
        instance.setSelectedModifierGroup(modifierGroup);
        return instance;
    }

    public void setModifierSpec(MenuItemModifierSpec menuItemModifierSpec) {
        this.modifierSpec = menuItemModifierSpec;
    }
}

