/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config;

import com.floreantpos.Messages;
import com.floreantpos.config.AppConfig;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.util.PasswordHasher;
import java.awt.Color;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

public class TerminalConfig {
    private static final String USE_SETTLEMENT_PROMPT = "UseSettlementPrompt";
    private static final String SHOW_GUEST_SELECTION = "show_guest_selection";
    private static final String ORDER_TYPE_FILTER = "order_type_filter";
    private static final String PS_FILTER = "ps_filter";
    private static final String SHOW_TABLE_SELECTION = "show_table_selection";
    private static final String REGULAR_MODE = "regular_mode";
    private static final String KITCHEN_MODE = "kitchen_mode";
    private static final String CASHIER_MODE = "cashier_mode";
    private static final String SHOW_DB_CONFIGURATION = "show_db_configuration";
    private static final String UI_DEFAULT_FONT = "ui_default_font";
    private static final String TOUCH_FONT_SIZE = "TOUCH_FONT_SIZE";
    private static final String SCREEN_COMPONENT_SIZE_RATIO = "SCREEN_COMPONENT_SIZE_RATIO";
    private static final String TOUCH_BUTTON_HEIGHT = "TOUCH_BUTTON_HEIGHT";
    private static final String FLOOR_BUTTON_WIDTH = "FLOOR_BUTTON_WIDTH";
    private static final String FLOOR_BUTTON_HEIGHT = "FLOOR_BUTTON_HEIGHT";
    private static final String FLOOR_BUTTON_FONT_SIZE = "FLOOR_BUTTON_FONT_SIZE";
    private static final String ADMIN_PASSWORD = "admin_pass";
    private static final String SHOW_BARCODE_ON_RECEIPT = "show_barcode_on_receipt";
    private static final String DEFAULT_VIEW = "default_view";
    private static final String ACTIVE_CUSTOMER_DISPLAY = "active_customer_display";
    private static final String ACTIVE_SCALE_DISPLAY = "active_scale_display";
    private static final String ACTIVE_CALLER_ID_DEVICE = "active_caller_id_device";
    private static final String CALLER_ID_DEVICE = "caller_id_device";
    private static final String ORDER_VIEW_PAGE_SIZE = "order_view_page_size";
    public static final String SHOW_KDS_ON_LOGIN_SCREEN = "showkdsonloginscreen";
    public static final String KDS_ENABLED = "kdsenabled";
    static final String TERMINAL_ID = "terminal_id";
    static final String KIOSK_MODE = "kiosk_mode";
    static final String SMTP_HOST = "smtp_host";
    static final String SENDER_EMAIL = "sender_email";
    private static final String SENDER_PASSWORD = "sender_password";
    private static boolean multiple_order_supported = true;
    private static final String DEFAULT_LOCALE = "defaultLocal";
    private static final String PAGINATED_MENU_VIEW = "paginated_menu_view";
    private static final String AUTO_PRINT_RECEIPT = "auto_print_receipt";
    private static final String CHECK_FOR_UPDATE_ON_START_UP = "check_update_on_startup";
    private static final String OWNER_FILTER = "owner_filter";
    private static final String KDS_TICKETS_PER_PAGE = "kds.ticket.per_page";
    public static final String RED_TIME_OUT = "RedTimeOut";
    public static final String YELLOW_TIME_OUT = "YellowTimeOut";
    public static final String KDS_BACKGROUND = "kds.background";
    public static final String KDS_TEXT_COLOR = "kds.textcolor";
    public static final String KDS_SHOW_BORDER = "kds.border";
    public static final String KDS_SHOW_HORIZONTAL_LINE = "kds.sep";
    public static final String KDS_INITIAL_COMPONENT = "kds.initial.component";
    public static final String KDS_INITIAL_BG = "kds.initial.bg";
    public static final String KDS_INITIAL_FG = "kds.initial.fg";
    public static final String KDS_WARNING_COMPONENT = "kds.warning.component";
    public static final String KDS_WARNING_BG = "kds.warning.bg";
    public static final String KDS_WARNING_FG = "kds.warning.fg";
    public static final String KDS_OVER_COMPONENT = "kds.over.component";
    public static final String KDS_OVER_BG = "kds.over.bd";
    public static final String KDS_OVER_FG = "kds.over.fg";
    public static final String HIDE_INLINE_ITEM_BUMP = "kds.hide_item_bump";
    public static final String ORDER_FILTER_PANEL_VISIBLE = "order.filter_panel.visible";
    private static final String DEFAULT_DRAWER_AMOUNT = "DEFAULT_DRAWER_AMOUNT";
    private static PropertiesConfiguration config = AppConfig.getConfig();
    public static final String GIFT_ORDERTYPE = "gift.ordertype";
    private static final String TICKET_CREATION_DATE = "TICKET_CREATION_DATE";

    public static void setSMTPHost(String SMTP_host) {
        config.setProperty(SMTP_HOST, (Object)SMTP_host);
    }

    public static String getSMTPHost() {
        return (String)config.getProperty(SMTP_HOST);
    }

    public static void setSenderEmail(String sender) {
        config.setProperty(SENDER_EMAIL, (Object)sender);
    }

    public static void setSenderPassword(String senderPassword) {
        config.setProperty(SENDER_PASSWORD, (Object)senderPassword);
    }

    public static String getSenderPassword() {
        return (String)config.getProperty(SENDER_PASSWORD);
    }

    public static String getSenderEmail() {
        return (String)config.getProperty(SENDER_EMAIL);
    }

    public static String getTerminalId() {
        return config.getString(TERMINAL_ID, "");
    }

    public static void setTerminalId(String id) {
        config.setProperty(TERMINAL_ID, (Object)id);
    }

    public static boolean isShowKDSOnLogInScreen() {
        return config.getBoolean(SHOW_KDS_ON_LOGIN_SCREEN, false);
    }

    public static void setShowKDSOnLogInScreen(boolean show) {
        config.setProperty(SHOW_KDS_ON_LOGIN_SCREEN, (Object)show);
    }

    public static boolean isKioskMode() {
        return config.getBoolean(KIOSK_MODE, false);
    }

    public static void setKioskMode(boolean fullscreen) {
        config.setProperty(KIOSK_MODE, (Object)fullscreen);
    }

    public static String getAdminPassword() {
        return config.getString(ADMIN_PASSWORD, PasswordHasher.hashPassword("1111"));
    }

    public static void setAdminPassword(String password) {
        config.setProperty(ADMIN_PASSWORD, (Object)PasswordHasher.hashPassword(password));
    }

    public static boolean matchAdminPassword(String password) {
        return TerminalConfig.getAdminPassword().equals(PasswordHasher.hashPassword(password));
    }

    public static void setTouchScreenButtonHeight(int height) {
        config.setProperty(TOUCH_BUTTON_HEIGHT, (Object)height);
    }

    public static int getTouchScreenButtonHeight() {
        return config.getInt(TOUCH_BUTTON_HEIGHT, 60);
    }

    public static void setFloorButtonWidth(int width) {
        config.setProperty(FLOOR_BUTTON_WIDTH, (Object)width);
    }

    public static int getFloorButtonWidth() {
        return config.getInt(FLOOR_BUTTON_WIDTH, 90);
    }

    public static void setFloorButtonHeight(int height) {
        config.setProperty(FLOOR_BUTTON_HEIGHT, (Object)height);
    }

    public static int getFloorButtonHeight() {
        return config.getInt(FLOOR_BUTTON_HEIGHT, 90);
    }

    public static void setFloorButtonFontSize(int size) {
        config.setProperty(FLOOR_BUTTON_FONT_SIZE, (Object)size);
    }

    public static int getFloorButtonFontSize() {
        return config.getInt(FLOOR_BUTTON_FONT_SIZE, 30);
    }

    public static void setMenuItemButtonHeight(int height) {
        config.setProperty("menu_button_height", (Object)height);
    }

    public static int getMenuItemButtonHeight() {
        return config.getInt("menu_button_height", 120);
    }

    public static void setMenuItemButtonWidth(int width) {
        config.setProperty("menu_button_width", (Object)width);
    }

    public static int getMenuItemButtonWidth() {
        return config.getInt("menu_button_width", 120);
    }

    public static void setTouchScreenFontSize(int size) {
        config.setProperty(TOUCH_FONT_SIZE, (Object)size);
    }

    public static int getTouchScreenFontSize() {
        return config.getInt(TOUCH_FONT_SIZE, 12);
    }

    public static void setScreenScaleFactor(double size) {
        config.setProperty(SCREEN_COMPONENT_SIZE_RATIO, (Object)size);
    }

    public static double getScreenScaleFactor() {
        return config.getDouble(SCREEN_COMPONENT_SIZE_RATIO, 1.0);
    }

    public static boolean isOrderFilterPanelVisible() {
        return config.getBoolean(ORDER_FILTER_PANEL_VISIBLE, true);
    }

    public static void setOrderFilterPanelVisible(boolean visible) {
        config.setProperty(ORDER_FILTER_PANEL_VISIBLE, (Object)visible);
    }

    public static String getUiDefaultFont() {
        return config.getString(UI_DEFAULT_FONT);
    }

    public static void setUiDefaultFont(String fontName) {
        config.setProperty(UI_DEFAULT_FONT, (Object)fontName);
    }

    public static void setShowDbConfigureButton(boolean show) {
        config.setProperty(SHOW_DB_CONFIGURATION, (Object)show);
    }

    public static boolean isShowDbConfigureButton() {
        return config.getBoolean(SHOW_DB_CONFIGURATION, true);
    }

    public static void setShowBarcodeOnReceipt(boolean show) {
        config.setProperty(SHOW_BARCODE_ON_RECEIPT, (Object)show);
    }

    public static boolean isShowBarcodeOnReceipt() {
        return config.getBoolean(SHOW_BARCODE_ON_RECEIPT, false);
    }

    public static void setEnabledCallerIdDevice(boolean show) {
        config.setProperty(ACTIVE_CALLER_ID_DEVICE, (Object)show);
    }

    public static boolean isEanbledCallerIdDevice() {
        return config.getBoolean(ACTIVE_CALLER_ID_DEVICE, false);
    }

    public static boolean isMultipleOrderSupported() {
        return multiple_order_supported;
    }

    public static void setCustomerDisplay(boolean show) {
        config.setProperty(ACTIVE_CUSTOMER_DISPLAY, (Object)show);
    }

    public static boolean isActiveCustomerDisplay() {
        return config.getBoolean(ACTIVE_CUSTOMER_DISPLAY, false);
    }

    public static void setScaleDisplay(boolean show) {
        config.setProperty(ACTIVE_SCALE_DISPLAY, (Object)show);
    }

    public static boolean isActiveScaleDisplay() {
        return config.getBoolean(ACTIVE_SCALE_DISPLAY, false);
    }

    public static boolean isCashierMode() {
        return false;
    }

    public static void setCashierMode(boolean cashierMode) {
        config.setProperty(CASHIER_MODE, (Object)cashierMode);
    }

    public static boolean isRegularMode() {
        return config.getBoolean(REGULAR_MODE, false);
    }

    public static void setRegularMode(boolean regularMode) {
        config.setProperty(REGULAR_MODE, (Object)regularMode);
    }

    public static boolean isKitchenMode() {
        return config.getBoolean(KITCHEN_MODE, false);
    }

    public static void setKitchenMode(boolean kitchenMode) {
        config.setProperty(KITCHEN_MODE, (Object)kitchenMode);
    }

    public static String getOrderTypeFilter() {
        return config.getString(ORDER_TYPE_FILTER, "ALL");
    }

    public static void setOrderTypeFilter(String filter) {
        config.setProperty(ORDER_TYPE_FILTER, (Object)filter);
    }

    public static String getCallerIdDevice() {
        return config.getString(CALLER_ID_DEVICE, Messages.getString("TerminalConfig.0"));
    }

    public static void setCallerIdDevice(String device) {
        config.setProperty(CALLER_ID_DEVICE, (Object)device);
    }

    public static PaymentStatusFilter getPaymentStatusFilter() {
        return PaymentStatusFilter.fromString(config.getString(PS_FILTER));
    }

    public static void setPaymentStatusFilter(String filter) {
        config.setProperty(PS_FILTER, (Object)filter);
    }

    public static void setShouldShowTableSelection(boolean showTableSelection) {
        config.setProperty(SHOW_TABLE_SELECTION, (Object)showTableSelection);
    }

    public static boolean isShouldShowTableSelection() {
        return config.getBoolean(SHOW_TABLE_SELECTION, Boolean.TRUE);
    }

    public static void setShouldShowGuestSelection(boolean showGuestSelection) {
        config.setProperty(SHOW_GUEST_SELECTION, (Object)showGuestSelection);
    }

    public static boolean isShouldShowGuestSelection() {
        return config.getBoolean(SHOW_GUEST_SELECTION, Boolean.TRUE);
    }

    public static void setUseSettlementPrompt(boolean settlementPrompt) {
        config.setProperty(USE_SETTLEMENT_PROMPT, (Object)settlementPrompt);
    }

    public static boolean isUseSettlementPrompt() {
        return config.getBoolean(USE_SETTLEMENT_PROMPT, Boolean.FALSE);
    }

    public static void setMiscItemDefaultTaxId(String id) {
        config.setProperty("mistitemdefaulttaxid", (Object)id);
    }

    public static String getMiscItemDefaultTaxId() {
        return config.getString("mistitemdefaulttaxid", "-1");
    }

    public static void setDrawerPortName(String drawerPortName) {
        config.setProperty("drawerPortName", (Object)drawerPortName);
    }

    public static String getDrawerPortName() {
        return config.getString("drawerPortName", "COM1");
    }

    public static void setCustomerDisplayPort(String customerDisplayPort) {
        config.setProperty("customerDisplayPort", (Object)customerDisplayPort);
    }

    public static String getCustomerDisplayPort() {
        return config.getString("customerDisplayPort", "COM1");
    }

    public static void setCustomerDisplayMessage(String customerDisplayMessage) {
        config.setProperty("customerDisplayMessage", (Object)customerDisplayMessage);
    }

    public static String getCustomerDisplayMessage() {
        return config.getString("customerDisplayMessage", "12345678912345678912");
    }

    public static String getScaleActivationValue() {
        return config.getString("wd", "");
    }

    public static void setScalePort(String scalePort) {
        config.setProperty("scaleDisplayPort", (Object)scalePort);
    }

    public static String getScalePort() {
        return config.getString("scalePort", "COM7");
    }

    public static void setScaleDisplayMessage(String scaleDisplayMessage) {
        config.setProperty("scaleDisplayMessage", (Object)scaleDisplayMessage);
    }

    public static String getScaleDisplayMessage() {
        return config.getString("scaleDisplayMessage", "1234");
    }

    public static void setDrawerControlCodes(String controlCode) {
        config.setProperty("controlCode", (Object)controlCode);
    }

    public static String getDrawerControlCodes() {
        return config.getString("controlCode", "27,112,0,25,250");
    }

    public static String getDefaultDrawerControlCodes() {
        return "27,112,0,25,250";
    }

    public static String getDrawerPullReportHiddenColumns() {
        return config.getString("drawerPullReportColumns", "");
    }

    public static void setDrawerPullReportHiddenColumns(String value) {
        config.setProperty("drawerPullReportColumns", (Object)value);
    }

    public static String getTicketListViewHiddenColumns() {
        return config.getString("listViewColumns", "");
    }

    public static void setTicketListViewHiddenColumns(String value) {
        config.setProperty("listViewColumns", (Object)value);
    }

    public static String getDefaultView() {
        return config.getString(DEFAULT_VIEW, SwitchboardView.VIEW_NAME);
    }

    public static void setDefaultView(String viewName) {
        config.setProperty(DEFAULT_VIEW, (Object)viewName);
    }

    public static char[] getDrawerControlCodesArray() {
        String drawerControlCodes = TerminalConfig.getDefaultDrawerControlCodes();
        if (StringUtils.isEmpty((String)drawerControlCodes)) {
            drawerControlCodes = TerminalConfig.getDefaultDrawerControlCodes();
        }
        String[] split = drawerControlCodes.split(",");
        char[] codes = new char[split.length];
        for (int i = 0; i < split.length; ++i) {
            try {
                codes[i] = (char)Integer.parseInt(split[i]);
                continue;
            }
            catch (Exception x) {
                codes[i] = 48;
            }
        }
        return codes;
    }

    public static void setDefaultLocale(String defaultLocal) {
        config.setProperty(DEFAULT_LOCALE, (Object)defaultLocal);
    }

    public static Locale getDefaultLocale() {
        String defaultLocaleString = config.getString(DEFAULT_LOCALE, null);
        if (StringUtils.isEmpty((String)defaultLocaleString)) {
            return null;
        }
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer st = new StringTokenizer(defaultLocaleString, "_");
        if (st.hasMoreTokens()) {
            language = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            country = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            variant = st.nextToken();
        }
        Locale disName = new Locale(language, country, variant);
        return disName;
    }

    public static boolean isPaginatedMenuView() {
        return config.getBoolean(PAGINATED_MENU_VIEW, Boolean.FALSE);
    }

    public static void setPaginatedMenuView(boolean selected) {
        config.setProperty(PAGINATED_MENU_VIEW, (Object)selected);
    }

    @Deprecated
    public static boolean isAutoPrintReceipt() {
        return config.getBoolean(AUTO_PRINT_RECEIPT, Boolean.TRUE);
    }

    @Deprecated
    public static void setAutoPrintReceipt(boolean selected) {
        config.setProperty(AUTO_PRINT_RECEIPT, (Object)selected);
    }

    public static boolean isFilterByOwner() {
        return config.getBoolean(OWNER_FILTER, true);
    }

    public static void setFilterByOwner(boolean filter) {
        config.setProperty(OWNER_FILTER, (Object)filter);
    }

    public static void setOrderViewPageSize(int orderViewPageSize) {
        config.setProperty(ORDER_VIEW_PAGE_SIZE, (Object)orderViewPageSize);
    }

    public static int getOrderViewPageSize() {
        return config.getInt(ORDER_VIEW_PAGE_SIZE, 10);
    }

    public static void setCheckUpdateOnStartUp(boolean checkUpdate) {
        config.setProperty(CHECK_FOR_UPDATE_ON_START_UP, (Object)checkUpdate);
    }

    public static boolean isCheckUpdateOnStartUp() {
        return config.getBoolean(CHECK_FOR_UPDATE_ON_START_UP, Boolean.FALSE);
    }

    public static void setKDSTicketsPerPage(int value) {
        config.setProperty(KDS_TICKETS_PER_PAGE, (Object)value);
    }

    public static int getKDSTicketsPerPage() {
        return config.getInt(KDS_TICKETS_PER_PAGE, 8);
    }

    public static Color getColor(String propName, Color dfltColor) {
        Integer colorCode = config.getInt(propName, 0);
        if (colorCode == null || colorCode == 0) {
            return dfltColor;
        }
        return new Color(colorCode);
    }

    public static Color getColor(String propName) {
        return TerminalConfig.getColor(propName, null);
    }

    public static void setGiftOrdertype(String id) {
        config.setProperty(GIFT_ORDERTYPE, (Object)id);
    }

    public static String getGiftOrdertype() {
        return config.getString(GIFT_ORDERTYPE, null);
    }

    public static void setDefultDrawerAmount(double amount) {
        config.setProperty(DEFAULT_DRAWER_AMOUNT, (Object)amount);
    }

    public static double getDeafultDrawerAmount() {
        return config.getDouble(DEFAULT_DRAWER_AMOUNT, 0.0);
    }

    public static void setUpdateServerURL(String url) {
        config.setProperty("update_server_url", (Object)url);
    }

    public static String getUpdateServerURL() {
        return config.getString("update_server_url", null);
    }

    public static String getPluginUpdateServerURL(String pluginName) {
        return config.getString("update_server_url." + pluginName.trim().toLowerCase(), null);
    }

    public static void setTicketCreationDate(String date) {
        config.setProperty(TICKET_CREATION_DATE, (Object)date);
    }

    public static String getTicketCreationDate() {
        return config.getString(TICKET_CREATION_DATE, null);
    }
}

