/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ChargeConfigurationView
extends ConfigurationView {
    private POSTextField tfServiceCharge;
    private POSTextField tfDefaultGratuity;
    private POSTextField tfOvertimeMarkup;
    private JCheckBox chkUseDetailedReconciliation;
    private JCheckBox chkItemSalesPriceIncludesTax;
    private JCheckBox chkAutomaticallySyncCharges;
    private JCheckBox chkPenyRounding;
    private JComboBox cbTaxGroup;
    private JComboBox cbCurrency;
    private Outlet outlet;
    private Store store;

    public ChargeConfigurationView(Store store) {
        this.store = store;
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow]", ""));
        JLabel lblServiceCharge = new JLabel(Messages.getString("RestaurantConfigurationView.42") + ":");
        contentPanel.add((Component)lblServiceCharge, "alignx trailing");
        this.tfServiceCharge = new POSTextField();
        contentPanel.add((Component)this.tfServiceCharge, "growx");
        JLabel label = new JLabel("%");
        contentPanel.add((Component)label, "wrap");
        JLabel lblDefaultGratuity = new JLabel(Messages.getString("RestaurantConfigurationView.48") + ":");
        contentPanel.add((Component)lblDefaultGratuity, "flowy,alignx trailing");
        this.tfDefaultGratuity = new POSTextField();
        contentPanel.add((Component)this.tfDefaultGratuity, "growx");
        JLabel label_1 = new JLabel("%");
        contentPanel.add((Component)label_1, "wrap");
        JLabel lblOvertimeMarkup = new JLabel("Overtime markup:");
        contentPanel.add((Component)lblOvertimeMarkup, "flowy,alignx trailing");
        this.tfOvertimeMarkup = new POSTextField();
        contentPanel.add((Component)this.tfOvertimeMarkup, "growx");
        JLabel label_2 = new JLabel("%");
        contentPanel.add((Component)label_2, "wrap");
        JLabel lblTaxGroup = new JLabel("Tax Group:");
        this.cbTaxGroup = new JComboBox();
        contentPanel.add((Component)lblTaxGroup, "alignx trailing");
        contentPanel.add((Component)this.cbTaxGroup, "grow, wrap");
        JLabel lblCurrency = new JLabel("Currency:");
        this.cbCurrency = new JComboBox();
        contentPanel.add((Component)lblCurrency, "alignx trailing");
        contentPanel.add((Component)this.cbCurrency, "grow, wrap");
        this.chkUseDetailedReconciliation = new JCheckBox("Use detailed reconciliation");
        contentPanel.add((Component)this.chkUseDetailedReconciliation, "skip 1, wrap");
        this.chkItemSalesPriceIncludesTax = new JCheckBox(Messages.getString("TaxConfigurationView.4"));
        contentPanel.add((Component)this.chkItemSalesPriceIncludesTax, "skip 1,wrap");
        this.chkAutomaticallySyncCharges = new JCheckBox("Automatically Sync Charges to Salesforce when day is closed");
        contentPanel.add((Component)this.chkAutomaticallySyncCharges, "skip 1, wrap");
        this.chkPenyRounding = new JCheckBox("Allow peny rounding");
        contentPanel.add((Component)this.chkPenyRounding, "skip 1,wrap");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    private void initData() {
        ArrayList<TaxGroup> taxGroups = new ArrayList<TaxGroup>();
        taxGroups.add(null);
        taxGroups.addAll(TaxGroupDAO.getInstance().findAll());
        this.cbTaxGroup.setModel(new ComboBoxModel(taxGroups));
        ArrayList<Currency> currencyList = new ArrayList<Currency>();
        currencyList.add(null);
        currencyList.addAll(CurrencyDAO.getInstance().findAll());
        this.cbCurrency.setModel(new ComboBoxModel(currencyList));
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        double serviceCharge = 0.0;
        double gratuityPercentage = 0.0;
        String currencyName = null;
        String currencySymbol = null;
        if (StringUtils.isEmpty(currencyName)) {
            currencyName = POSConstants.DOLLAR;
        }
        if (StringUtils.isEmpty(currencySymbol)) {
            currencySymbol = "$";
        }
        serviceCharge = Double.parseDouble(this.tfServiceCharge.getText());
        gratuityPercentage = Double.parseDouble(this.tfDefaultGratuity.getText());
        double overtimeMarkup = Double.parseDouble(this.tfOvertimeMarkup.getText());
        if (overtimeMarkup > 100.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Overtime markup rate should not be more than 100% !");
            return false;
        }
        this.store.setCurrencyName(currencyName);
        this.store.setCurrencySymbol(currencySymbol);
        this.store.addProperty("overtime.markup", String.valueOf(overtimeMarkup));
        this.store.addProperty("store.peny.rounding", String.valueOf(this.chkPenyRounding.isSelected()));
        this.store.setUseDetailedReconciliation(this.chkUseDetailedReconciliation.isSelected());
        this.store.setItemPriceIncludesTax(this.chkItemSalesPriceIncludesTax.isSelected());
        this.store.addProperty("Charges.Automatically_Sync_Day", String.valueOf(this.chkAutomaticallySyncCharges.isSelected()));
        if (this.outlet != null) {
            this.outlet.setServiceChargePercentage(serviceCharge);
            this.outlet.setDefaultGratuityPercentage(gratuityPercentage);
            TaxGroup taxGroup = (TaxGroup)this.cbTaxGroup.getSelectedItem();
            this.outlet.setTaxGroup(taxGroup);
            Currency currency = (Currency)this.cbCurrency.getSelectedItem();
            this.outlet.setCurrency(currency);
            OutletDAO.getInstance().saveOrUpdate(this.outlet);
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.outlet = OutletDAO.getInstance().get(String.valueOf(this.store.getDefaultOutletId()));
        if (this.outlet != null) {
            this.tfServiceCharge.setText(String.valueOf(this.outlet.getServiceChargePercentage()));
            this.tfDefaultGratuity.setText(String.valueOf(this.outlet.getDefaultGratuityPercentage()));
            this.cbTaxGroup.setSelectedItem(this.outlet.getTaxGroup());
            this.cbCurrency.setSelectedItem(this.outlet.getCurrency());
        }
        this.tfOvertimeMarkup.setText(String.valueOf(this.store.getOvertimeMarkup()));
        this.chkUseDetailedReconciliation.setSelected(this.store.isUseDetailedReconciliation());
        this.chkItemSalesPriceIncludesTax.setSelected(this.store.isItemPriceIncludesTax());
        this.chkAutomaticallySyncCharges.setSelected(this.store.isAutoSyncCharges());
        this.chkPenyRounding.setSelected(this.store.isAllowPenyRounding());
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_CHARGE;
    }
}

