/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.SlideShowImageDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ImagePanel;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;

public class CustMonitorConfigurationDialog
extends POSDialog
implements ActionListener {
    private JRadioButton chkShowItemImage;
    private JRadioButton chkShowSlideShow;
    private JRadioButton chkShowImgWithSlideShow;
    private JTextField tfDuration;
    private Store store;
    private ButtonGroup buttonGroup;
    private JPanel imageCenterPanel;
    private PaginatedTableModel imageGalleryModel;
    private JButton btnPrevious;
    private JButton btnNext;
    private ImageResource selectedImageResource;

    public CustMonitorConfigurationDialog() {
        this.setTitle(VersionInfo.getAppName());
        this.imageGalleryModel = new PaginatedTableModel(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return null;
            }
        };
        this.imageGalleryModel.setRows(new ArrayList());
        this.imageGalleryModel.setPageSize(10);
        this.imageGalleryModel.setNumRows(SlideShowImageDAO.getInstance().rowCount());
        this.initComponents();
        this.updateView();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("CustMonitorConfigurationDialog.0"));
        this.add((Component)titlePanel, "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        this.add(tabbedPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        this.add((Component)bottomPanel, "South");
        PosButton btnSave = new PosButton(Messages.getString("CustMonitorConfigurationDialog.2"));
        PosButton btnClose = new PosButton(Messages.getString("Close"));
        btnSave.addActionListener(e -> this.doSave());
        btnClose.addActionListener(e -> {
            this.setCanceled(true);
            this.dispose();
        });
        bottomPanel.add(btnSave);
        bottomPanel.add(btnClose);
        tabbedPane.addTab(Messages.getString("CustMonitorConfigurationDialog.4"), this.doCreateBasicConfigPanel());
        tabbedPane.addTab(Messages.getString("CustMonitorConfigurationDialog.5"), this.doCreateImageConfigPanel());
    }

    private JPanel doCreateImageConfigPanel() {
        JPanel imagePanel = new JPanel(new BorderLayout());
        this.imageCenterPanel = new JPanel();
        this.imageCenterPanel = new JPanel(new WrapLayout());
        this.imageCenterPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        JScrollPane scrollPane = new JScrollPane(this.imageCenterPanel, 20, 30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel imageSouthPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        PosButton btnUpload = new PosButton(Messages.getString("CustMonitorConfigurationDialog.7"));
        btnUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustMonitorConfigurationDialog.this.doShowUploadDialog();
            }
        });
        PosButton btnDelete = new PosButton(Messages.getString("CustMonitorConfigurationDialog.8"));
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustMonitorConfigurationDialog.this.doRemoveSlideImage();
            }
        });
        this.btnPrevious = new JButton("<<<");
        this.btnNext = new JButton(">>>");
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustMonitorConfigurationDialog.this.imageGalleryModel.setCurrentRowIndex(CustMonitorConfigurationDialog.this.imageGalleryModel.getNextRowIndex());
                CustMonitorConfigurationDialog.this.createImagePanel(true);
            }
        });
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustMonitorConfigurationDialog.this.imageGalleryModel.setCurrentRowIndex(CustMonitorConfigurationDialog.this.imageGalleryModel.getPreviousRowIndex());
                CustMonitorConfigurationDialog.this.createImagePanel(true);
            }
        });
        this.btnPrevious.setEnabled(false);
        imageSouthPanel.add((Component)btnUpload, "split 2");
        imageSouthPanel.add(btnDelete);
        imageSouthPanel.add((Component)this.btnPrevious, "right, split 2");
        imageSouthPanel.add(this.btnNext);
        imagePanel.add(scrollPane);
        imagePanel.add((Component)imageSouthPanel, "South");
        return imagePanel;
    }

    protected void doRemoveSlideImage() {
        if (this.selectedImageResource == null) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("CustMonitorConfigurationDialog.13"), Messages.getString("CustMonitorConfigurationDialog.14"));
        if (option != 0) {
            return;
        }
        try {
            SlideShowImageDAO slideShowImageDAO;
            SlideShowImage slideShowImage;
            if (this.selectedImageResource.getId() != null && (slideShowImage = (slideShowImageDAO = SlideShowImageDAO.getInstance()).findByImageId(this.selectedImageResource.getId())) != null) {
                slideShowImageDAO.delete(slideShowImage);
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustMonitorConfigurationDialog.15"));
            this.imageGalleryModel.deleteItem(this.selectedImageResource);
            this.createImagePanel(false);
        }
        catch (Exception error) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), error.getMessage(), error);
        }
    }

    private JPanel doCreateBasicConfigPanel() {
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("center", "[][]", ""));
        this.buttonGroup = new ButtonGroup();
        this.chkShowItemImage = new JRadioButton(Messages.getString("CustMonitorConfigurationDialog.19"));
        this.chkShowSlideShow = new JRadioButton(Messages.getString("CustMonitorConfigurationDialog.20"));
        this.chkShowImgWithSlideShow = new JRadioButton(Messages.getString("CustMonitorConfigurationDialog.21"));
        this.buttonGroup.add(this.chkShowItemImage);
        this.buttonGroup.add(this.chkShowSlideShow);
        this.buttonGroup.add(this.chkShowImgWithSlideShow);
        JLabel lblDuration = new JLabel(Messages.getString("CustMonitorConfigurationDialog.22"));
        this.tfDuration = new JTextField();
        centerPanel.add((Component)this.chkShowItemImage, "wrap");
        centerPanel.add((Component)this.chkShowSlideShow, "wrap");
        centerPanel.add((Component)this.chkShowImgWithSlideShow, "wrap");
        centerPanel.add((Component)lblDuration, "split 3");
        centerPanel.add((Component)this.tfDuration, "grow");
        centerPanel.add(new JLabel(Messages.getString("CustMonitorConfigurationDialog.28")));
        return centerPanel;
    }

    private void doSave() {
        try {
            int displayOption = 0;
            if (this.chkShowItemImage.isSelected()) {
                displayOption = 0;
            } else if (this.chkShowSlideShow.isSelected()) {
                displayOption = 1;
            } else if (this.chkShowImgWithSlideShow.isSelected()) {
                displayOption = 2;
            }
            String duration = this.tfDuration.getText();
            this.store.addProperty("customer.monitor.display.option", String.valueOf(displayOption));
            this.store.addProperty("customer.monitor.slide.duration", duration);
            StoreDAO.getInstance().saveOrUpdate(this.store);
            List<ImageResource> imageResources = this.imageGalleryModel.getRows();
            if (imageResources != null) {
                Iterator iterator = imageResources.iterator();
                while (iterator.hasNext()) {
                    ImageResource imageResource = (ImageResource)iterator.next();
                    SlideShowImage slideShowImage = SlideShowImageDAO.getInstance().findByImageId(imageResource.getId());
                    if (slideShowImage == null) continue;
                    iterator.remove();
                }
                SlideShowImageDAO.getInstance().saveAll(imageResources);
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void updateView() {
        this.store = DataProvider.get().getStore();
        int disOption = this.store.getCustomerMonitorDisplayOption();
        switch (disOption) {
            case 0: {
                this.chkShowItemImage.setSelected(true);
                break;
            }
            case 1: {
                this.chkShowSlideShow.setSelected(true);
                break;
            }
            case 2: {
                this.chkShowImgWithSlideShow.setSelected(true);
                break;
            }
        }
        int slideDuration = this.store.getCustomerMonitorDisplaySlideDuration();
        this.tfDuration.setText("" + slideDuration);
        this.createImagePanel(true);
    }

    private void doShowUploadDialog() {
        try {
            ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
            dialog.setTitle(Messages.getString("CustMonitorConfigurationDialog.30"));
            dialog.setSize(PosUIManager.getSize(650, 600));
            dialog.setSelectBtnVisible(true);
            dialog.setResizable(false);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            ImageResource imageResource = dialog.getImageResource();
            this.imageGalleryModel.addItem(imageResource);
            this.createImagePanel(false);
        }
        catch (PosException e1) {
            POSMessageDialog.showError(e1.getMessage());
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private void createImagePanel(boolean isInitialize) {
        this.imageCenterPanel.removeAll();
        this.imageCenterPanel.revalidate();
        this.imageCenterPanel.repaint();
        if (isInitialize) {
            SlideShowImageDAO.getInstance().getImages(this.imageGalleryModel);
        }
        List rows = this.imageGalleryModel.getRows();
        ButtonGroup btnGroup = new ButtonGroup();
        if (rows != null) {
            for (ImageResource imageResource : rows) {
                ImagePanel imgPanel = new ImagePanel(this, imageResource, btnGroup);
                this.imageCenterPanel.add((Component)imgPanel, "aligny, top");
            }
        }
        this.btnPrevious.setEnabled(this.imageGalleryModel.hasPrevious());
        this.btnNext.setEnabled(this.imageGalleryModel.hasNext());
        this.imageCenterPanel.revalidate();
        this.imageCenterPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JToggleButton tgButton = (JToggleButton)e.getSource();
        if (tgButton.isSelected()) {
            this.selectedImageResource = (ImageResource)tgButton.getClientProperty("selected");
        }
    }
}

