/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class KitchenDisplayConfigurationView
extends ConfigurationView {
    private JTextField txtYellowTime;
    private JTextField txtRedTime;
    private JCheckBox chkEnableKds;
    private JCheckBox chkShowKdsOnLoginScreen;

    public KitchenDisplayConfigurationView() {
        this.initComponents();
        this.chkShowKdsOnLoginScreen.setEnabled(false);
        this.txtYellowTime.setEnabled(false);
        this.txtRedTime.setEnabled(false);
    }

    @Override
    public boolean save() throws Exception {
        AppConfig.put("YellowTimeOut", this.txtYellowTime.getText());
        AppConfig.put("RedTimeOut", this.txtRedTime.getText());
        TerminalConfig.setShowKDSOnLogInScreen(this.chkShowKdsOnLoginScreen.isSelected());
        Store store = DataProvider.get().getStore();
        store.setKDSenabled(this.chkEnableKds.isSelected());
        StoreDAO.getInstance().update(store);
        return true;
    }

    @Override
    public void initialize() throws Exception {
        String yellowTimeOut = AppConfig.getString("YellowTimeOut");
        String redTimeOut = AppConfig.getString("RedTimeOut");
        this.chkEnableKds.setSelected(DataProvider.get().getStore().isKDSenabled());
        this.chkShowKdsOnLoginScreen.setSelected(TerminalConfig.isShowKDSOnLogInScreen());
        if (yellowTimeOut != null) {
            this.txtYellowTime.setText(yellowTimeOut);
        }
        if (redTimeOut != null) {
            this.txtRedTime.setText(redTimeOut);
        }
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return Messages.getString("KitchenDisplayConfigurationView.0");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.txtYellowTime = new JTextField(5);
        this.txtRedTime = new JTextField(5);
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel chkBoxPanel = new JPanel(new BorderLayout());
        this.chkEnableKds = new JCheckBox(Messages.getString("KitchenDisplayConfigurationView.2"));
        this.chkShowKdsOnLoginScreen = new JCheckBox(Messages.getString("KitchenDisplayConfigurationView.3"));
        this.chkEnableKds.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    KitchenDisplayConfigurationView.this.chkShowKdsOnLoginScreen.setEnabled(true);
                    KitchenDisplayConfigurationView.this.txtYellowTime.setEnabled(true);
                    KitchenDisplayConfigurationView.this.txtRedTime.setEnabled(true);
                    KitchenDisplayConfigurationView.this.txtYellowTime.setText("90");
                    KitchenDisplayConfigurationView.this.txtRedTime.setText("120");
                } else {
                    KitchenDisplayConfigurationView.this.chkShowKdsOnLoginScreen.setSelected(false);
                    KitchenDisplayConfigurationView.this.chkShowKdsOnLoginScreen.setEnabled(false);
                    KitchenDisplayConfigurationView.this.txtYellowTime.setEnabled(false);
                    KitchenDisplayConfigurationView.this.txtRedTime.setEnabled(false);
                }
            }
        });
        chkBoxPanel.add((Component)this.chkEnableKds, "North");
        chkBoxPanel.add((Component)this.chkShowKdsOnLoginScreen, "South");
        contentPanel.add((Component)chkBoxPanel, "North");
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout());
        footerPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("KitchenDisplayConfigurationView.1")));
        JLabel lblYellowTime = new JLabel(Messages.getString("PrintConfigurationView.7"));
        JLabel lblRedTime = new JLabel(Messages.getString("PrintConfigurationView.9"));
        footerPanel.add((Component)lblYellowTime, "grow");
        footerPanel.add((Component)this.txtYellowTime, "grow");
        footerPanel.add((Component)new JLabel(Messages.getString("PrintConfigurationView.14")), "grow, wrap");
        footerPanel.add((Component)lblRedTime, "grow");
        footerPanel.add((Component)this.txtRedTime, "grow");
        footerPanel.add((Component)new JLabel(Messages.getString("PrintConfigurationView.18")), "grow");
        contentPanel.add((Component)footerPanel, "Center");
        this.add(contentPanel);
    }
}

