/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.MailTemplate;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.MailPreviewDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.MailTemplateUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;

public class MailTemplateConfigurationView
extends JPanel {
    private Store store;
    private JTextField tfEmailSubject;
    private JTextPane emailBodyTextArea;
    private JList<MailTemplate> listMailTemplates;
    private JList<ReceiptParam> listParams;

    public MailTemplateConfigurationView() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        int size = Application.getPosWindow().getSize().width / 3 + 80;
        int width = PosUIManager.getSize(size);
        int height = PosUIManager.getSize(125);
        int fontSize = PosUIManager.getDefaultFontSize();
        contentPanel.setLayout((LayoutManager)new MigLayout("ins 10 ,wrap 1,fill", "[" + width + "]", "[][grow," + height + "]"));
        this.listMailTemplates = new JList();
        this.listMailTemplates.setFocusable(false);
        this.listMailTemplates.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    MailTemplateConfigurationView.this.doUpdateFields();
                }
            }
        });
        this.listParams = new JList();
        this.listParams.setFocusable(false);
        this.listParams.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MailTemplateConfigurationView.this.insertReceiptParam();
                }
            }
        });
        JScrollPane listMailTemplateScrollPane = new JScrollPane(this.listMailTemplates);
        listMailTemplateScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("MailTemplateConfigurationView.0")));
        listMailTemplateScrollPane.setPreferredSize(PosUIManager.getSize(250, 200));
        JScrollPane listParamScrollPane = new JScrollPane(this.listParams);
        listParamScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("MailTemplateConfigurationView.1")));
        listParamScrollPane.setPreferredSize(PosUIManager.getSize(250, 200));
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)listMailTemplateScrollPane, "North");
        westPanel.add((Component)listParamScrollPane, "Center");
        this.add((Component)westPanel, "West");
        this.tfEmailSubject = new JTextField();
        contentPanel.add((Component)new JLabel(Messages.getString("MailTemplateConfigurationView.2")), "split 2");
        contentPanel.add((Component)this.tfEmailSubject, "growx");
        this.emailBodyTextArea = new JTextPane();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setFontSize(attributes, fontSize);
        StyleConstants.setAlignment(attributes, 0);
        this.emailBodyTextArea.setParagraphAttributes(attributes, true);
        JScrollPane emailBodyScrollPane = new JScrollPane(this.emailBodyTextArea);
        emailBodyScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("MailTemplateConfigurationView.4")));
        contentPanel.add((Component)emailBodyScrollPane, "grow");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        this.add(scrollPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 3 0 3 0"));
        bottomPanel.add((Component)new JSeparator(), "span,growx");
        JButton btnOk = new JButton(POSConstants.SAVE);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MailTemplateConfigurationView.this.save();
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.36"));
                }
                catch (Exception e1) {
                    BOMessageDialog.showError(e1.getMessage());
                }
            }
        });
        bottomPanel.add((Component)btnOk, "split 2,center, gapbottom 0");
        JButton btnEmailPreview = new JButton(Messages.getString("ReceiptConfigurationView.64"));
        btnEmailPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MailTemplateConfigurationView.this.doShowEmailPreview();
            }
        });
        bottomPanel.add(btnEmailPreview);
        this.add((Component)bottomPanel, "South");
    }

    private void insertReceiptParam() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JTextComponent textComponent = null;
        if (!(focusOwner instanceof JTextComponent)) {
            return;
        }
        textComponent = (JTextComponent)focusOwner;
        ReceiptParam receiptParam = this.listParams.getSelectedValue();
        if (receiptParam == null) {
            return;
        }
        String text = "$!" + receiptParam.getParamName();
        textComponent.replaceSelection(text);
    }

    private void doShowEmailPreview() {
        MailPreviewDialog dialog = new MailPreviewDialog(this.emailBodyTextArea.getText());
        dialog.setTitle(Messages.getString("MailTemplateConfigurationView.5"));
        dialog.setDefaultCloseOperation(2);
        dialog.open();
    }

    public void initialize() throws Exception {
        DataProvider.get().refreshStore();
        this.store = DataProvider.get().getStore();
        MailTemplate[] mailTemplate = MailTemplate.values();
        List<MailTemplate> mailTemplatesList = Arrays.asList(mailTemplate);
        this.listMailTemplates.setModel(new ListModel<MailTemplate>(mailTemplatesList));
        this.listMailTemplates.setSelectedIndex(0);
        ReceiptParam[] receiptParams = ReceiptParam.values();
        List<ReceiptParam> paramsToExclude = Arrays.asList(ReceiptParam.BARCODE, ReceiptParam.CUSTOMER_SIGNATURE, ReceiptParam.CUSTOMER_NO, ReceiptParam.LOYALTY_REDEEM, ReceiptParam.LOYALTY_EARNED, ReceiptParam.LOYALTY_TOTAL, ReceiptParam.DELIVERY_ADDRESS, ReceiptParam.ONLINE_ORDER_ID, ReceiptParam.DRIVER_NAME, ReceiptParam.DRIVER_ID, ReceiptParam.DELIVERY_DATE, ReceiptParam.RETURN_DATE);
        ArrayList<ReceiptParam> receiptParamsList = new ArrayList<ReceiptParam>();
        for (ReceiptParam receiptParam : receiptParams) {
            if (paramsToExclude.contains((Object)receiptParam)) continue;
            receiptParamsList.add(receiptParam);
        }
        receiptParamsList.sort(Comparator.comparing(Enum::name));
        this.listParams.setModel(new ListModel(receiptParamsList));
    }

    public boolean save() throws Exception {
        DataProvider.get().refreshStore();
        this.store = DataProvider.get().getStore();
        this.emailBodyTextArea.getDocument().putProperty("__EndOfLine__", "<br>");
        String emailSubject = this.tfEmailSubject.getText();
        String emailBody = this.emailBodyTextArea.getText();
        if (emailSubject.replaceAll("<br>", "").isEmpty()) {
            emailSubject = "";
        }
        if (emailBody.replaceAll("<br>", "").isEmpty()) {
            emailBody = "";
        }
        Map<String, String> properties = this.store.getProperties();
        MailTemplate mailTemplate = this.listMailTemplates.getSelectedValue();
        POSUtil.storeLongProperty(properties, mailTemplate.getSubjectKey(), emailSubject, 255);
        POSUtil.storeLongProperty(properties, mailTemplate.getBodyKey(), emailBody, 255);
        StoreDAO.getInstance().saveOrUpdate(this.store);
        Application.getInstance().refreshStore();
        return true;
    }

    private void doUpdateFields() {
        String emailSubject = "";
        String emailBody = "";
        MailTemplate mailTemplate = this.listMailTemplates.getSelectedValue();
        if (mailTemplate != null) {
            emailSubject = MailTemplateUtil.getTemplate(this.store, mailTemplate.getSubjectKey());
            emailBody = MailTemplateUtil.getTemplate(this.store, mailTemplate.getBodyKey());
        }
        emailBody = emailBody.replaceAll("<br>", "\n");
        this.tfEmailSubject.setText(emailSubject);
        this.emailBodyTextArea.setText(emailBody);
    }
}

