/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.AddPrinterGroupDialog;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PrinterGroupView
extends JPanel {
    private JList<PrinterGroup> list;
    private DefaultListModel<PrinterGroup> listModel;

    public PrinterGroupView() {
    }

    public PrinterGroupView(String title) {
        this.setBorder(BorderFactory.createTitledBorder(title));
        this.setLayout(new BorderLayout(10, 10));
        JPanel panel = new JPanel();
        this.add((Component)panel, "South");
        JButton btnAdd = new JButton(POSConstants.ADD);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrinterGroupView.this.doAddPrinterGroup();
            }
        });
        panel.add(btnAdd);
        JButton btnEdit = new JButton(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrinterGroupView.this.doEditPrinterGroup();
            }
        });
        panel.add(btnEdit);
        JButton btnDelete = new JButton(POSConstants.DELETE);
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrinterGroupView.this.doDeletePrinterGroup();
            }
        });
        panel.add(btnDelete);
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "Center");
        this.listModel = new DefaultListModel();
        List<PrinterGroup> all = PrinterGroupDAO.getInstance().findAll();
        for (PrinterGroup printerGroup : all) {
            this.listModel.addElement(printerGroup);
        }
        this.list = new JList<PrinterGroup>(this.listModel);
        scrollPane.setViewportView(this.list);
    }

    private void doDeletePrinterGroup() {
        PrinterGroup pGroup = this.list.getSelectedValue();
        if (pGroup == null) {
            String message = Messages.getString("SELECT_A_ROW");
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
            return;
        }
        try {
            String title = Messages.getString("PrinterGroupView.1");
            String message = Messages.getString("PrinterGroupView.2");
            message = String.format(message, pGroup.getName());
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, title);
            if (option != 0) {
                return;
            }
            PrinterGroupDAO.getInstance().delete(pGroup.getId());
            this.listModel.removeElement(pGroup);
        }
        catch (PosException e) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(e.getMessage(), e.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
        }
        this.refresh();
    }

    protected void doEditPrinterGroup() {
        try {
            PrinterGroup pGroup = this.list.getSelectedValue();
            if (pGroup == null) {
                String message = Messages.getString("SELECT_A_ROW");
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                return;
            }
            AddPrinterGroupDialog dialog = new AddPrinterGroupDialog();
            dialog.setPrinterGroup(pGroup);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            PrinterGroup printerGroup = dialog.getPrinterGroup();
            GenericDAO.getInstance().checkIdOrNameExists(printerGroup.getId(), printerGroup.getName(), PrinterGroup.class);
            PrinterGroupDAO.getInstance().saveOrUpdate(printerGroup);
            this.list.repaint();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    protected void doAddPrinterGroup() {
        try {
            AddPrinterGroupDialog dialog = new AddPrinterGroupDialog();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            PrinterGroup printerGroup = dialog.getPrinterGroup();
            GenericDAO.getInstance().checkIdOrNameExists(printerGroup.getId(), printerGroup.getName(), PrinterGroup.class);
            PrinterGroupDAO.getInstance().saveOrUpdate(printerGroup);
            this.listModel.addElement(printerGroup);
            this.list.repaint();
            this.list.setSelectedValue(printerGroup, Boolean.TRUE);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void refresh() {
        this.listModel.clear();
        List<PrinterGroup> all = PrinterGroupDAO.getInstance().findAll();
        for (PrinterGroup printersG : all) {
            this.listModel.addElement(printersG);
        }
    }
}

