/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TipSuggestion;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TipsSuggestionDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PreviewTicketUtil;
import com.floreantpos.util.ReceiptUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReceiptConfigurationView
extends JPanel {
    private boolean initialized = false;
    private JTextPane ticketHeaderTextArea;
    private JTextPane ticketfooterTextArea;
    private JTextPane ticketBottomTextArea;
    private JTextPane orderInfoTextPane;
    private JTextPane additionalOrderInfoTextPane;
    private JList<TipSuggestion> listOfTips;
    private JList<ReceiptParam> listParams;
    private OrderType selectedOrderType;
    private Store store;
    private ButtonGroup btnGroup2;
    private boolean kitchenReceipt;
    private OrderInfoView mainReceiptView = null;
    private KitchenReceiptView kitchenReceiptView = null;
    private JCheckBox cbTipsSuggestion = new JCheckBox(Messages.getString("ReceiptConfigurationView.0"));
    private JComboBox cbModifierColor = new JComboBox();
    private JComboBox cbSeatColor = new JComboBox();
    private JComboBox cbHeaderTextFontFamily = new JComboBox();
    private JComboBox cbHeaderTextFontSize = new JComboBox();
    private JComboBox cbBodyTextFontFamily = new JComboBox();
    private JComboBox cbBodyTextFontSize = new JComboBox();
    private String[] fonts;
    private JComboBox cbCookingInstructionColor = new JComboBox();
    private JCheckBox chkModifierPrice = new JCheckBox(Messages.getString("ReceiptConfigurationView.1"));
    private JCheckBox chkZeroCostModifier = new JCheckBox(Messages.getString("ZeroCostModifier"));
    private JCheckBox cbTipsBlock = new JCheckBox(Messages.getString("ReceiptConfigurationView.2"));
    private JCheckBox chkTaxBreakDown = new JCheckBox(Messages.getString("ReceiptConfigurationView.3"));
    private JCheckBox chkPrintTranslatedName = new JCheckBox(Messages.getString("ReceiptConfigurationView.111"));
    private POSToggleButton btnAll;
    private POSToggleButton btnGuestCheck;
    private POSToggleButton btnGuestCheckCreditCard;
    private JComboBox<ReciptPaperSize> selectPageSize;
    private JButton btnAddTips;
    private JButton btnEditTips;
    private JButton btnDeleteTips;
    private JScrollPane listOfTipsParam;
    private JPanel tipsConfigPanel;
    private JPanel mainReceiptPanel = null;
    private JPanel kitchenReceiptPanel = null;
    private JComboBox selectPrintPreviewSystem;
    private FontPropertiesPanel ticketHeaderPropertiesPanel;
    private FontPropertiesPanel orderInfoPropertiesPanel;
    private FontPropertiesPanel additionalOrderInfoPropertiesPanel;
    private FontPropertiesPanel ticketBottomPropertiesPanel;
    private FontPropertiesPanel footerPropertiesPanel;
    private FontPropertiesPanel detailsPropertiesPanel;

    public ReceiptConfigurationView() {
        this(false);
    }

    public ReceiptConfigurationView(boolean kitchenReceipt) {
        this.kitchenReceipt = kitchenReceipt;
        this.initComponents();
    }

    public void initialize() throws Exception {
        if (this.initialized) {
            this.refresh();
            return;
        }
        DataProvider.get().refreshStore();
        this.store = DataProvider.get().getStore();
        ReceiptParam[] receiptParams = ReceiptParam.values();
        List<ReceiptParam> receiptParamsList = Arrays.asList(receiptParams);
        receiptParamsList.sort(Comparator.comparing(Enum::name));
        this.listParams.setModel(new ListModel<ReceiptParam>(receiptParamsList));
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        String reciptPaperSizeStr = currentTerminal.getProperty("main.recipt.paper_size", ReciptPaperSize.Eighty.name());
        String kitchenPaperSizeStr = currentTerminal.getProperty("kitchen.recipt.paper_size", ReciptPaperSize.Eighty.name());
        String reciptPrintPreviewSystem = currentTerminal.getProperty("main.receipt.print_preview_system", "Standard");
        String kitchenPrintPreviewSystem = currentTerminal.getProperty("kitchen.receipt.print_preview_system", "Standard");
        if (!this.kitchenReceipt) {
            ReciptPaperSize mainReciptPaperSize = ReciptPaperSize.fromName(reciptPaperSizeStr);
            this.selectPageSize.setSelectedItem((Object)mainReciptPaperSize);
            this.selectPrintPreviewSystem.setSelectedItem(reciptPrintPreviewSystem);
        } else {
            ReciptPaperSize kitchenRecipPaperSize = ReciptPaperSize.fromName(kitchenPaperSizeStr);
            this.selectPageSize.setSelectedItem((Object)kitchenRecipPaperSize);
            this.selectPrintPreviewSystem.setSelectedItem(kitchenPrintPreviewSystem);
        }
        if (this.kitchenReceipt) {
            this.initKitchenReceiptPrintPreview();
        } else {
            this.initReceiptPrintPreview();
        }
        this.doUpdateFields();
        this.updatePropertiesPanelVisibility();
        this.initTipsSuggestions();
        this.initialized = true;
    }

    private String getHtmlColorValue(Object selectedItem) {
        String hex = "#000000";
        Color color = Color.black;
        if (selectedItem != null) {
            color = ((SimpleColor)((Object)selectedItem)).color;
        }
        try {
            hex = "#" + Integer.toHexString(color.getRGB()).substring(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hex;
    }

    public boolean save(boolean isContainOrderTypeId) throws Exception {
        boolean hasOrderTypeId;
        DataProvider.get().refreshStore();
        this.store = DataProvider.get().getStore();
        this.ticketHeaderTextArea.getDocument().putProperty("__EndOfLine__", "<br>");
        this.orderInfoTextPane.getDocument().putProperty("__EndOfLine__", "<br>");
        this.additionalOrderInfoTextPane.getDocument().putProperty("__EndOfLine__", "<br>");
        this.ticketfooterTextArea.getDocument().putProperty("__EndOfLine__", "<br>");
        this.ticketBottomTextArea.getDocument().putProperty("__EndOfLine__", "<br>");
        String ticketHeader = this.ticketHeaderTextArea.getText();
        String orderInfo = this.orderInfoTextPane.getText();
        String extraOrderInfo = this.additionalOrderInfoTextPane.getText();
        String footerInfo = this.ticketfooterTextArea.getText();
        String bottomInfo = this.ticketBottomTextArea.getText();
        if (ticketHeader.replaceAll("<br>", "").isEmpty()) {
            ticketHeader = "";
        }
        if (orderInfo.replaceAll("<br>", "").isEmpty()) {
            orderInfo = "";
        }
        if (extraOrderInfo.replaceAll("<br>", "").isEmpty()) {
            extraOrderInfo = "";
        }
        if (footerInfo.replaceAll("<br>", "").isEmpty()) {
            footerInfo = "";
        }
        if (bottomInfo.replaceAll("<br>", "").isEmpty()) {
            bottomInfo = "";
        }
        String orderTypeId = "";
        boolean bl = hasOrderTypeId = this.selectedOrderType != null && isContainOrderTypeId;
        if (hasOrderTypeId && this.selectedOrderType.getId() != "generic_order") {
            orderTypeId = this.selectedOrderType.getId() + ".";
        }
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < this.listOfTips.getModel().getSize(); ++i) {
            TipSuggestion tipSuggestion = this.listOfTips.getModel().getElementAt(i);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("percentage", (Object)NumberUtil.trimDecilamIfNotNeeded(tipSuggestion.getPercentage()));
            jsonObject.put("sortOrder", tipSuggestion.getSortOrder());
            jsonArray.put((Object)jsonObject);
        }
        Map<String, String> properties = this.store.getProperties();
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        ReciptPaperSize selectedPageSize = (ReciptPaperSize)((Object)this.selectPageSize.getSelectedItem());
        if (!this.kitchenReceipt) {
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.header", ticketHeader, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.order.info", orderInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.order.extrainfo1", extraOrderInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.footer", footerInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "ticket.bottom", bottomInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "tips_suggestion", jsonArray.toString(), 255);
            this.store.addProperty(orderTypeId + "ticket.modifier.color", this.getHtmlColorValue(this.cbModifierColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "ticket.seat.color", this.getHtmlColorValue(this.cbSeatColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "ticket.instruction.color", this.getHtmlColorValue(this.cbCookingInstructionColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "receipt.show_tips_suggestion", String.valueOf(this.cbTipsSuggestion.isSelected()));
            this.store.addProperty(orderTypeId + "receipt.show_tips_block", String.valueOf(this.cbTipsBlock.isSelected()));
            this.store.addProperty(orderTypeId + "receipt.show_tax_breakdown", String.valueOf(this.chkTaxBreakDown.isSelected()));
            this.store.addProperty("showModifierPrice", String.valueOf(this.chkModifierPrice.isSelected()));
            this.store.addProperty("suppress.zerocost.modifiers", String.valueOf(this.chkZeroCostModifier.isSelected()));
            this.ticketHeaderPropertiesPanel.updateModel("ticket.header");
            this.orderInfoPropertiesPanel.updateModel("ticket.order.info");
            this.additionalOrderInfoPropertiesPanel.updateModel("ticket.order.extrainfo1");
            this.ticketBottomPropertiesPanel.updateModel("ticket.footer");
            this.footerPropertiesPanel.updateModel("ticket.bottom");
            this.detailsPropertiesPanel.updateModel("ticket.details");
            currentTerminal.addProperty("main.recipt.paper_size", selectedPageSize.name());
            currentTerminal.addProperty("main.receipt.print_preview_system", String.valueOf(this.selectPrintPreviewSystem.getSelectedItem()));
        } else {
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.header", ticketHeader, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.order.info", orderInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.order.extrainfo1", extraOrderInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.footer", footerInfo, 255);
            POSUtil.storeLongProperty(properties, orderTypeId + "kitchen.bottom", bottomInfo, 255);
            this.store.addProperty(orderTypeId + "kitchen_ticket.modifier.color", this.getHtmlColorValue(this.cbModifierColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "kitchen_ticket.seat.color", this.getHtmlColorValue(this.cbSeatColor.getSelectedItem()));
            this.store.addProperty(orderTypeId + "kitchen_ticket.instruction.color", this.getHtmlColorValue(this.cbCookingInstructionColor.getSelectedItem()));
            this.store.addProperty("kitchen_receipt.print_translated_name", String.valueOf(this.chkPrintTranslatedName.isSelected()));
            this.ticketHeaderPropertiesPanel.updateModel("kitchen.header");
            this.orderInfoPropertiesPanel.updateModel("kitchen.order.info");
            this.additionalOrderInfoPropertiesPanel.updateModel("kitchen.order.extrainfo1");
            this.ticketBottomPropertiesPanel.updateModel("kitchen.footer");
            this.footerPropertiesPanel.updateModel("kitchen.bottom");
            this.detailsPropertiesPanel.updateModel("kitchen.details");
            currentTerminal.addProperty("kitchen.recipt.paper_size", selectedPageSize.name());
            currentTerminal.addProperty("kitchen.receipt.print_preview_system", String.valueOf(this.selectPrintPreviewSystem.getSelectedItem()));
        }
        String storeLogoParam = ReceiptParam.STORE_LOGO.getParamName();
        if (ticketHeader.contains(storeLogoParam) || extraOrderInfo.contains(storeLogoParam) || orderInfo.contains(storeLogoParam) || footerInfo.contains(storeLogoParam) || bottomInfo.contains(storeLogoParam)) {
            POSUtil.storeLongProperty(properties, this.kitchenReceipt ? orderTypeId + "kitchen.header.logo.show" : orderTypeId + "ticket.header.logo.show", "true", 255);
        } else {
            POSUtil.storeLongProperty(properties, this.kitchenReceipt ? orderTypeId + "kitchen.header.logo.show" : orderTypeId + "ticket.header.logo.show", "false", 255);
        }
        TerminalDAO.getInstance().update(currentTerminal);
        StoreDAO.getInstance().saveOrUpdate(this.store);
        Application.getInstance().refreshStore();
        return true;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        int size = Application.getPosWindow().getSize().width / 3 + 80;
        int width = PosUIManager.getSize(size);
        int height = PosUIManager.getSize(125);
        int fontSize = PosUIManager.getDefaultFontSize();
        contentPanel.setLayout((LayoutManager)new MigLayout("ins 0 5 10 5 ,wrap 1,filly", "[" + width + "]", "[" + height + "][grow," + height + "][grow," + height + "][grow," + height + "][" + height + "][]"));
        this.listParams = new JList();
        this.listParams.setFocusable(false);
        this.listParams.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReceiptConfigurationView.this.insertReceiptParam();
                }
            }
        });
        JScrollPane listParamScrollPane = new JScrollPane(this.listParams);
        listParamScrollPane.setBorder(BorderFactory.createTitledBorder("Params"));
        listParamScrollPane.setPreferredSize(PosUIManager.getSize(130, 200));
        JPanel westPanel = new JPanel(new BorderLayout());
        JPanel filterContentPanel = new JPanel(new BorderLayout());
        JPanel pageFilterPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        pageFilterPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.33")));
        this.selectPageSize = new JComboBox<ReciptPaperSize>(ReciptPaperSize.values());
        pageFilterPanel.add(this.selectPageSize, "grow");
        filterContentPanel.add((Component)pageFilterPanel, "South");
        JPanel printPreviewSystem = new JPanel((LayoutManager)new MigLayout("fill"));
        printPreviewSystem.setBorder(BorderFactory.createTitledBorder("Print preview"));
        this.selectPrintPreviewSystem = new JComboBox();
        this.selectPrintPreviewSystem.addItem("Standard");
        this.selectPrintPreviewSystem.addItem("EscPOS");
        this.selectPrintPreviewSystem.addItemListener(e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            this.updatePropertiesPanelVisibility();
        });
        printPreviewSystem.add((Component)this.selectPrintPreviewSystem, "grow");
        filterContentPanel.add((Component)printPreviewSystem, "North");
        westPanel.add((Component)filterContentPanel, "North");
        westPanel.add((Component)listParamScrollPane, "Center");
        this.add((Component)westPanel, "West");
        this.ticketHeaderPropertiesPanel = new FontPropertiesPanel();
        this.orderInfoPropertiesPanel = new FontPropertiesPanel();
        this.additionalOrderInfoPropertiesPanel = new FontPropertiesPanel();
        this.ticketBottomPropertiesPanel = new FontPropertiesPanel();
        this.footerPropertiesPanel = new FontPropertiesPanel();
        this.detailsPropertiesPanel = new FontPropertiesPanel();
        this.setVisibleFontPropertiesPanel(false);
        this.ticketHeaderTextArea = new JTextPane();
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setFontSize(attributes, fontSize);
        StyleConstants.setAlignment(attributes, 1);
        this.ticketHeaderTextArea.setParagraphAttributes(attributes, true);
        contentPanel.add(this.createTextPaneLayout(Messages.getString("ReceiptConfigurationView.26"), this.ticketHeaderPropertiesPanel, this.ticketHeaderTextArea), "grow");
        this.orderInfoTextPane = new JTextPane();
        this.orderInfoTextPane.setParagraphAttributes(attributes, true);
        contentPanel.add(this.createTextPaneLayout(Messages.getString("ReceiptConfigurationView.28"), this.orderInfoPropertiesPanel, this.orderInfoTextPane), "grow");
        this.additionalOrderInfoTextPane = new JTextPane();
        StyleConstants.setAlignment(attributes, 0);
        this.additionalOrderInfoTextPane.setParagraphAttributes(attributes, true);
        contentPanel.add(this.createTextPaneLayout(Messages.getString("ReceiptConfigurationView.30"), this.additionalOrderInfoPropertiesPanel, this.additionalOrderInfoTextPane), "grow");
        this.ticketBottomTextArea = new JTextPane();
        StyleConstants.setAlignment(attributes, 0);
        this.ticketBottomTextArea.setParagraphAttributes(attributes, true);
        contentPanel.add(this.createTextPaneLayout(Messages.getString("ReceiptConfigurationView.37"), this.ticketBottomPropertiesPanel, this.ticketBottomTextArea), "grow");
        this.ticketfooterTextArea = new JTextPane();
        StyleConstants.setAlignment(attributes, 1);
        this.ticketfooterTextArea.setParagraphAttributes(attributes, true);
        contentPanel.add(this.createTextPaneLayout(Messages.getString("ReceiptConfigurationView.32"), this.footerPropertiesPanel, this.ticketfooterTextArea), "grow");
        this.detailsPropertiesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PosMessage.112")));
        contentPanel.add((Component)this.detailsPropertiesPanel, "grow");
        contentPanel.add((Component)this.createTipsPanel(), "grow");
        contentPanel.add((Component)this.createTipsConfigPanel(), "grow, gap left 50");
        contentPanel.add((Component)this.createColorSelectionPanel(), "grow,wrap,gap bottom 50");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        this.add(scrollPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 3 0 3 0"));
        bottomPanel.add((Component)new JSeparator(), "span,growx");
        JButton btnRestoreDefault = new JButton(POSConstants.RESTORE_DEFAULTS);
        btnRestoreDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.35"), POSConstants.CONFIRM) == 1) {
                    return;
                }
                ReceiptConfigurationView.this.populateDefaultReceiptProperties();
            }
        });
        bottomPanel.add((Component)btnRestoreDefault, "split 2,center, gapbottom 0");
        JButton btnOk = new JButton(POSConstants.SAVE);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReceiptConfigurationView.this.save(true);
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.36"));
                    if (ReceiptConfigurationView.this.kitchenReceipt) {
                        ReceiptConfigurationView.this.doShowKitchenReceiptPrintPriview(false);
                    } else {
                        ReceiptConfigurationView.this.doShowPrintPriview(false);
                    }
                }
                catch (Exception e1) {
                    BOMessageDialog.showError(e1.getMessage());
                }
            }
        });
        bottomPanel.add(btnOk);
        this.add((Component)bottomPanel, "South");
    }

    private Component createTextPaneLayout(String title, JPanel propertiesPanel, JTextPane textPane) {
        JPanel textPaneContainer = new JPanel(new BorderLayout());
        JScrollPane headerSectionScrollPane = new JScrollPane(textPane);
        textPaneContainer.setBorder(BorderFactory.createTitledBorder(title));
        textPaneContainer.add((Component)propertiesPanel, "North");
        textPaneContainer.add(headerSectionScrollPane);
        return textPaneContainer;
    }

    private JPanel createTipsPanel() {
        JPanel tipsPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3"));
        this.cbTipsSuggestion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ReceiptConfigurationView.this.fieldVisible(true);
                } else {
                    ReceiptConfigurationView.this.fieldVisible(false);
                }
            }
        });
        tipsPanel.add((Component)this.chkModifierPrice, "wrap");
        tipsPanel.add((Component)this.chkZeroCostModifier, "wrap");
        tipsPanel.add((Component)this.cbTipsBlock, "wrap");
        tipsPanel.add((Component)this.chkTaxBreakDown, "wrap");
        tipsPanel.add((Component)this.chkPrintTranslatedName, "wrap");
        tipsPanel.add((Component)this.cbTipsSuggestion, "wrap");
        return tipsPanel;
    }

    private JPanel createTipsConfigPanel() {
        this.tipsConfigPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3"));
        this.tipsConfigPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TipsSuggestion")));
        this.listOfTips = new JList();
        this.listOfTipsParam = new JScrollPane(this.listOfTips);
        this.listOfTipsParam.setPreferredSize(PosUIManager.getSize(130, 120));
        this.btnAddTips = new JButton(POSConstants.ADD_BUTTON_TEXT);
        this.btnAddTips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptConfigurationView.this.addTipSuggestions();
            }
        });
        this.btnEditTips = new JButton(POSConstants.EDIT);
        this.btnEditTips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptConfigurationView.this.editTipSuggestions();
            }
        });
        this.btnDeleteTips = new JButton(POSConstants.DELETE);
        this.btnDeleteTips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptConfigurationView.this.deleteTipSuggestions();
            }
        });
        this.tipsConfigPanel.add(this.listOfTipsParam);
        this.tipsConfigPanel.add(this.btnAddTips);
        this.tipsConfigPanel.add(this.btnEditTips);
        this.tipsConfigPanel.add(this.btnDeleteTips);
        this.fieldVisible(false);
        return this.tipsConfigPanel;
    }

    private void fieldVisible(boolean visibility) {
        this.listOfTipsParam.setVisible(visibility);
        this.btnAddTips.setVisible(visibility);
        this.btnEditTips.setVisible(visibility);
        this.btnDeleteTips.setVisible(visibility);
        this.tipsConfigPanel.setVisible(visibility);
    }

    private JPanel createTextSelectionPanel() {
        JPanel textSelectionPanel = new JPanel(new GridLayout(0, 1));
        GraphicsEnvironment graphics = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fonts = graphics.getAvailableFontFamilyNames();
        this.cbHeaderTextFontFamily.setModel(new DefaultComboBoxModel<String>(this.fonts));
        this.cbBodyTextFontFamily.setModel(new DefaultComboBoxModel<String>(this.fonts));
        Integer[] sizes = new Integer[]{10, 12, 14, 16, 18, 20, 22, 24};
        this.cbHeaderTextFontSize.setModel(new DefaultComboBoxModel<Integer>(sizes));
        this.cbBodyTextFontSize.setModel(new DefaultComboBoxModel<Integer>(sizes));
        JPanel headerTextPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        headerTextPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.72")));
        headerTextPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        headerTextPanel.add(this.cbHeaderTextFontFamily);
        headerTextPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        headerTextPanel.add(this.cbHeaderTextFontSize);
        JPanel bodyTextPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        bodyTextPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.71")));
        bodyTextPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        bodyTextPanel.add(this.cbBodyTextFontFamily);
        bodyTextPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        bodyTextPanel.add(this.cbBodyTextFontSize);
        textSelectionPanel.add((Component)headerTextPanel, "grow, wrap");
        textSelectionPanel.add((Component)bodyTextPanel, "grow");
        return textSelectionPanel;
    }

    private JPanel createColorSelectionPanel() {
        JPanel colorSelectionPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx"));
        colorSelectionPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.9")));
        this.cbModifierColor.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.cbCookingInstructionColor.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.cbSeatColor.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        colorSelectionPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.10")), "split 6");
        colorSelectionPanel.add((Component)this.cbModifierColor, "");
        colorSelectionPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.13")));
        colorSelectionPanel.add((Component)this.cbSeatColor, "");
        colorSelectionPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.15")));
        colorSelectionPanel.add((Component)this.cbCookingInstructionColor, "");
        return colorSelectionPanel;
    }

    private void populateDefaultReceiptProperties() {
        try {
            this.refresh();
            if (this.kitchenReceipt) {
                ReceiptUtil.populateDefaultKitchenReceiptProperties(this.store);
            } else {
                ReceiptUtil.populateDefaultTicketReceiptProperties(this.store);
            }
            this.deleteOrderTypeBasedProperties();
            this.initialized = false;
            this.initialize();
            this.save(false);
            if (this.kitchenReceipt) {
                this.doShowKitchenReceiptPrintPriview(false);
            } else {
                this.doShowPrintPriview(false);
            }
        }
        catch (Exception e1) {
            BOMessageDialog.showError(e1.getMessage());
        }
    }

    private void deleteOrderTypeBasedProperties() {
        if (this.selectedOrderType == null) {
            return;
        }
        String ordertypeId = this.selectedOrderType.getId();
        try {
            Map<String, String> propertyMap = this.store.getProperties();
            if (!this.kitchenReceipt) {
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.header");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.order.info");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.footer");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.bottom");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.order.extrainfo1");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.order.extrainfo2");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.modifier.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.seat.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.instruction.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "ticket.header.logo.show");
            } else {
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.header");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.order.info");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.footer");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.order.extrainfo1");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.order.extrainfo2");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen_ticket.modifier.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen_ticket.seat.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen_ticket.instruction.color");
                POSUtil.removeLongProperty(propertyMap, ordertypeId + "." + "kitchen.header.logo.show");
            }
            StoreDAO.getInstance().saveOrUpdate(this.store);
            Application.getInstance().refreshStore();
        }
        catch (Exception e) {
            PosLog.error(ReceiptConfigurationView.class, e.getMessage(), e);
        }
    }

    private void initReceiptPrintPreview() {
        if (this.mainReceiptView != null && this.mainReceiptPanel != null) {
            return;
        }
        List<OrderType> orderTypes = DataProvider.get().getOrderTypes();
        String constraints = "w " + PosUIManager.getSize(90);
        if (orderTypes == null || orderTypes.isEmpty()) {
            this.doShowOrdertypeMissMessage();
            return;
        }
        ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
        try {
            this.mainReceiptView = new OrderInfoView(ticketsToShow);
            this.mainReceiptView.setPreferredSize(PosUIManager.getSize(500, 0));
            this.mainReceiptView.setBorder(new EmptyBorder(8, 0, 5, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add((Component)this.mainReceiptView, "East");
        this.mainReceiptView.add(this.createReceiptViewButtonActionPanel(), "South");
        this.mainReceiptPanel = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 5 3 5 18", "sg,fill", ""));
        ActionListener reportPreviewAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptConfigurationView.this.orderTypeButtonClicked(e);
            }
        };
        ButtonGroup btnGroup = new ButtonGroup();
        this.selectedOrderType = null;
        this.btnAll = new POSToggleButton(POSConstants.ALL);
        this.btnAll.addActionListener(reportPreviewAction);
        OrderType orderTypeAll = new OrderType("generic_order");
        this.btnAll.putClientProperty("orderType", orderTypeAll);
        btnGroup.add(this.btnAll);
        this.mainReceiptPanel.add((Component)this.btnAll, constraints);
        if (this.selectedOrderType == null) {
            this.selectedOrderType = orderTypeAll;
            this.btnAll.setSelected(true);
        }
        for (OrderType orderType : orderTypes) {
            POSToggleButton btnOrderType = new POSToggleButton("<html><center>" + orderType.getName() + "</center></html>");
            btnGroup.add(btnOrderType);
            this.mainReceiptPanel.add((Component)btnOrderType, constraints);
            btnOrderType.putClientProperty("orderType", orderType);
            btnOrderType.addActionListener(reportPreviewAction);
            if (this.selectedOrderType != null) continue;
            ticketsToShow.add(PreviewTicketUtil.createPreviewTicket(orderType, null));
        }
        this.mainReceiptPanel.add((Component)new JSeparator(), "gaptop 20");
        this.btnGroup2 = new ButtonGroup();
        this.btnGuestCheck = new POSToggleButton("<html><center>Guest Check</center></html>");
        this.btnGuestCheck.putClientProperty("guestCheck", "cash");
        this.btnGuestCheck.addActionListener(reportPreviewAction);
        this.btnGroup2.add(this.btnGuestCheck);
        this.mainReceiptPanel.add((Component)this.btnGuestCheck, constraints);
        this.btnGuestCheckCreditCard = new POSToggleButton("<html><center>Guest Check (Credit Card)</center><html>");
        this.btnGuestCheckCreditCard.putClientProperty("guestCheck", "creditCard");
        this.btnGuestCheckCreditCard.addActionListener(reportPreviewAction);
        this.btnGroup2.add(this.btnGuestCheckCreditCard);
        this.mainReceiptPanel.add((Component)this.btnGuestCheckCreditCard, constraints);
        JScrollPane scrollPane = new JScrollPane(this.mainReceiptPanel, 20, 31);
        this.mainReceiptView.add((Component)scrollPane, "East");
        this.doShowPrintPriview(false);
    }

    private String getProperty(String orderTypeId, String propertyName) {
        String property;
        if (StringUtils.isNotEmpty((String)orderTypeId)) {
            orderTypeId = orderTypeId + ".";
        }
        if (StringUtils.isEmpty((String)(property = this.store.getProperty(orderTypeId + propertyName)))) {
            property = this.store.getProperty(propertyName);
        }
        return property;
    }

    private void doUpdateFields() {
        String ticketHeader = "";
        String orderInfo = "";
        String additionalOrderInfo = "";
        String footerInfo = "";
        String bottomSection = "";
        String orderTypeId = "";
        if (this.selectedOrderType != null && this.selectedOrderType.getId() != "generic_order") {
            orderTypeId = this.selectedOrderType.getId();
        }
        if (!this.kitchenReceipt) {
            ticketHeader = ReceiptUtil.getReceiptSection(this.store, "ticket.header", orderTypeId);
            orderInfo = ReceiptUtil.getReceiptSection(this.store, "ticket.order.info", orderTypeId);
            additionalOrderInfo = ReceiptUtil.getReceiptSection(this.store, "ticket.order.extrainfo1", orderTypeId);
            footerInfo = ReceiptUtil.getReceiptSection(this.store, "ticket.footer", orderTypeId);
            bottomSection = ReceiptUtil.getReceiptSection(this.store, "ticket.bottom", orderTypeId);
            this.ticketHeaderPropertiesPanel.updateView("ticket.header");
            this.orderInfoPropertiesPanel.updateView("ticket.order.info");
            this.additionalOrderInfoPropertiesPanel.updateView("ticket.order.extrainfo1");
            this.ticketBottomPropertiesPanel.updateView("ticket.footer");
            this.footerPropertiesPanel.updateView("ticket.bottom");
            this.detailsPropertiesPanel.updateView("ticket.details");
            this.cbModifierColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "ticket.modifier.color")));
            this.cbSeatColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "ticket.seat.color")));
            this.cbCookingInstructionColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "ticket.instruction.color")));
            this.chkModifierPrice.setSelected(POSUtil.getBoolean(this.store.getProperty("showModifierPrice")));
            this.chkZeroCostModifier.setSelected(POSUtil.getBoolean(this.store.getProperty("suppress.zerocost.modifiers")));
            this.cbTipsSuggestion.setSelected(ReceiptUtil.getReceiptBooleanProp(this.store, "receipt.show_tips_suggestion", orderTypeId));
            this.cbTipsBlock.setSelected(ReceiptUtil.getReceiptBooleanProp(this.store, "receipt.show_tips_block", orderTypeId));
            this.chkTaxBreakDown.setSelected(ReceiptUtil.getReceiptBooleanProp(this.store, "receipt.show_tax_breakdown", orderTypeId));
        } else {
            ticketHeader = ReceiptUtil.getReceiptSection(this.store, "kitchen.header", orderTypeId);
            orderInfo = ReceiptUtil.getReceiptSection(this.store, "kitchen.order.info", orderTypeId);
            additionalOrderInfo = ReceiptUtil.getReceiptSection(this.store, "kitchen.order.extrainfo1", orderTypeId);
            footerInfo = ReceiptUtil.getReceiptSection(this.store, "kitchen.footer", orderTypeId);
            bottomSection = ReceiptUtil.getReceiptSection(this.store, "kitchen.bottom", orderTypeId);
            this.ticketHeaderPropertiesPanel.updateView("kitchen.header");
            this.orderInfoPropertiesPanel.updateView("kitchen.order.info");
            this.additionalOrderInfoPropertiesPanel.updateView("kitchen.order.extrainfo1");
            this.ticketBottomPropertiesPanel.updateView("kitchen.footer");
            this.footerPropertiesPanel.updateView("kitchen.bottom");
            this.detailsPropertiesPanel.updateView("kitchen.details");
            this.cbModifierColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "kitchen_ticket.modifier.color")));
            this.cbSeatColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "kitchen_ticket.seat.color")));
            this.cbCookingInstructionColor.setSelectedItem((Object)SimpleColor.getColor(this.getProperty(orderTypeId, "kitchen_ticket.instruction.color")));
            boolean isPrintTranslatedName = this.store.getProperty("kitchen_receipt.print_translated_name") == null ? false : Boolean.valueOf(this.store.getProperty("kitchen_receipt.print_translated_name"));
            this.chkPrintTranslatedName.setSelected(isPrintTranslatedName);
        }
        this.chkModifierPrice.setVisible(!this.kitchenReceipt && this.selectedOrderType.getId() == "generic_order");
        this.chkZeroCostModifier.setVisible(!this.kitchenReceipt && this.selectedOrderType.getId() == "generic_order");
        this.chkTaxBreakDown.setVisible(!this.kitchenReceipt);
        this.cbTipsSuggestion.setVisible(!this.kitchenReceipt);
        this.cbTipsBlock.setVisible(!this.kitchenReceipt);
        this.chkPrintTranslatedName.setVisible(this.kitchenReceipt);
        ticketHeader = ticketHeader.replaceAll("<br>", "\n");
        orderInfo = orderInfo.replaceAll("<br>", "\n");
        additionalOrderInfo = additionalOrderInfo.replaceAll("<br>", "\n");
        footerInfo = footerInfo.replaceAll("<br>", "\n");
        this.ticketHeaderTextArea.setText(ticketHeader);
        this.orderInfoTextPane.setText(orderInfo);
        this.additionalOrderInfoTextPane.setText(additionalOrderInfo);
        this.ticketfooterTextArea.setText(footerInfo);
        this.ticketBottomTextArea.setText(bottomSection);
        this.initTipsSuggestions();
    }

    private void updatePropertiesPanelVisibility() {
        try {
            boolean visiblePropertiesPanel = this.selectPrintPreviewSystem.getSelectedItem() != null && this.selectPrintPreviewSystem.getSelectedItem().toString().equals("EscPOS");
            this.setVisibleFontPropertiesPanel(visiblePropertiesPanel);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void setVisibleFontPropertiesPanel(boolean visiblePropertiesPanel) {
        this.ticketHeaderPropertiesPanel.setVisible(visiblePropertiesPanel);
        this.orderInfoPropertiesPanel.setVisible(visiblePropertiesPanel);
        this.additionalOrderInfoPropertiesPanel.setVisible(visiblePropertiesPanel);
        this.ticketBottomPropertiesPanel.setVisible(visiblePropertiesPanel);
        this.footerPropertiesPanel.setVisible(visiblePropertiesPanel);
        this.detailsPropertiesPanel.setVisible(visiblePropertiesPanel);
    }

    private void initKitchenReceiptPrintPreview() {
        try {
            if (this.kitchenReceiptPanel != null && this.kitchenReceiptView != null) {
                return;
            }
            List<OrderType> orderTypes = DataProvider.get().getOrderTypes();
            if (orderTypes == null || orderTypes.isEmpty()) {
                this.doShowOrdertypeMissMessage();
                return;
            }
            this.kitchenReceiptView = new KitchenReceiptView();
            this.kitchenReceiptView.setBorder(new EmptyBorder(8, 0, 5, 0));
            this.kitchenReceiptView.setPreferredSize(PosUIManager.getSize(500, 0));
            this.add((Component)this.kitchenReceiptView, "East");
            this.kitchenReceiptView.add(this.createReceiptViewButtonActionPanel(), "South");
            this.kitchenReceiptPanel = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 5 3 5 18", "sg,fill", ""));
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    POSToggleButton source = (POSToggleButton)e.getSource();
                    OrderType clientProperty = (OrderType)source.getClientProperty("orderType");
                    if (clientProperty != null) {
                        ReceiptConfigurationView.this.selectedOrderType = clientProperty;
                    }
                    ReceiptConfigurationView.this.doUpdateFields();
                    ReceiptConfigurationView.this.doShowKitchenReceiptPrintPriview(true);
                }
            };
            ButtonGroup btnGroup = new ButtonGroup();
            this.selectedOrderType = null;
            for (OrderType orderType : orderTypes) {
                POSToggleButton btnOrderType = new POSToggleButton("<html><center>" + orderType.getName() + "</center></html>");
                btnGroup.add(btnOrderType);
                String constraints = "w " + PosUIManager.getSize(90);
                this.kitchenReceiptPanel.add((Component)btnOrderType, constraints);
                btnOrderType.putClientProperty("orderType", orderType);
                btnOrderType.addActionListener(listener);
                if (this.selectedOrderType != null) continue;
                this.selectedOrderType = orderType;
                btnOrderType.setSelected(true);
            }
            JScrollPane scrollPane = new JScrollPane(this.kitchenReceiptPanel, 20, 31);
            this.kitchenReceiptView.add((Component)scrollPane, "East");
            this.doShowKitchenReceiptPrintPriview(false);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }

    private void doShowOrdertypeMissMessage() {
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.66"));
        this.removeAll();
    }

    private Component createReceiptViewButtonActionPanel() {
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("ins 5 5 0 5"));
        JButton btnPrintPreview = new JButton(Messages.getString("ReceiptConfigurationView.64"));
        btnPrintPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReceiptConfigurationView.this.kitchenReceipt) {
                    ReceiptConfigurationView.this.doShowKitchenReceiptPrintPriview(true);
                } else {
                    ReceiptConfigurationView.this.doShowPrintPriview(true);
                }
            }
        });
        JButton btnPrintTestPage = new JButton(Messages.getString("ReceiptConfigurationView.65"));
        btnPrintTestPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptConfigurationView.this.doPrintTestPage();
            }
        });
        bottomPanel.add((Component)btnPrintPreview, "gapleft 100!,split 2");
        bottomPanel.add(btnPrintTestPage);
        return bottomPanel;
    }

    private void doShowPrintPriview(boolean save) {
        try {
            block13: {
                if (save) {
                    this.save(true);
                }
                if (this.btnGuestCheckCreditCard.isSelected() || this.btnGuestCheck.isSelected()) {
                    String guestCheckType = null;
                    if (this.btnGuestCheck.isSelected()) {
                        guestCheckType = (String)this.btnGuestCheck.getClientProperty("guestCheck");
                    } else if (this.btnGuestCheckCreditCard.isSelected()) {
                        guestCheckType = (String)this.btnGuestCheckCreditCard.getClientProperty("guestCheck");
                    }
                    ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
                    Ticket createNewTicket = PreviewTicketUtil.createPreviewTicket(this.selectedOrderType, guestCheckType);
                    ticketsToShow.add(createNewTicket);
                    this.mainReceiptView.setTickets(ticketsToShow);
                    try {
                        this.mainReceiptView.getReportPanel().removeAll();
                        if (guestCheckType == null) {
                            this.mainReceiptView.createReport();
                            break block13;
                        }
                        this.mainReceiptView.createReport(createNewTicket.getTransactions().iterator().next());
                    }
                    catch (Exception e1) {
                        PosLog.error(ReceiptConfigurationView.class, e1.getMessage());
                    }
                } else {
                    ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
                    Ticket createNewTicket = PreviewTicketUtil.createPreviewTicket(this.selectedOrderType, null);
                    ticketsToShow.add(createNewTicket);
                    this.mainReceiptView.setTickets(ticketsToShow);
                    try {
                        this.mainReceiptView.getReportPanel().removeAll();
                        this.mainReceiptView.createReport();
                    }
                    catch (Exception e1) {
                        PosLog.error(ReceiptConfigurationView.class, e1.getMessage());
                    }
                }
            }
            this.mainReceiptView.revalidate();
            this.mainReceiptView.repaint();
            this.doUpdateFields();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doShowKitchenReceiptPrintPriview(boolean save) {
        try {
            if (save) {
                this.save(true);
            }
            Ticket createNewTicket = PreviewTicketUtil.createPreviewTicket(this.selectedOrderType, null);
            try {
                this.kitchenReceiptView.getReportPanel().removeAll();
                this.kitchenReceiptView.createReport(createNewTicket);
                this.kitchenReceiptView.revalidate();
                this.kitchenReceiptView.repaint();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void insertReceiptParam() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JTextComponent textComponent = null;
        if (!(focusOwner instanceof JTextComponent)) {
            return;
        }
        textComponent = (JTextComponent)focusOwner;
        ReceiptParam receiptParam = this.listParams.getSelectedValue();
        if (receiptParam == null) {
            return;
        }
        String text = "<" + receiptParam.getParamName() + ">$" + receiptParam.getParamName() + "</" + receiptParam.getParamName() + ">";
        textComponent.replaceSelection(text);
    }

    private void refresh() {
        DataProvider.get().refreshStore();
        this.store = DataProvider.get().getStore();
    }

    private void orderTypeButtonClicked(ActionEvent e) {
        try {
            String guestCheckType;
            POSToggleButton source = (POSToggleButton)e.getSource();
            OrderType clientProperty = (OrderType)source.getClientProperty("orderType");
            if (clientProperty != null) {
                this.selectedOrderType = clientProperty;
            }
            if (StringUtils.isEmpty((String)(guestCheckType = (String)source.getClientProperty("guestCheck")))) {
                guestCheckType = null;
                this.btnGroup2.clearSelection();
            }
            ArrayList<Ticket> ticketsToShow = new ArrayList<Ticket>();
            Ticket createNewTicket = PreviewTicketUtil.createPreviewTicket(this.selectedOrderType, guestCheckType);
            ticketsToShow.add(createNewTicket);
            this.doUpdateFields();
            this.mainReceiptView.setTickets(ticketsToShow);
            this.mainReceiptView.getReportPanel().removeAll();
            if (guestCheckType == null) {
                this.mainReceiptView.createReport();
            } else {
                this.mainReceiptView.createReport(createNewTicket.getTransactions().iterator().next());
            }
            this.mainReceiptView.revalidate();
            this.mainReceiptView.repaint();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(this, e1.getMessage(), e1);
        }
    }

    private void addTipSuggestions() {
        try {
            TipsSuggestionDialog dialog = new TipsSuggestionDialog(Messages.getString("AddTips"));
            dialog.setSize(PosUIManager.getSize(400, 250));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            ArrayList<TipSuggestion> values = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.listOfTips.getModel().getSize(); ++i) {
                values.add(this.listOfTips.getModel().getElementAt(i));
            }
            values.add(dialog.getTipSuggestion());
            Collections.sort(values, (o1, o2) -> o1.getSortOrder() - o2.getSortOrder());
            this.addTipsSuggestionToModel(values);
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private void editTipSuggestions() {
        try {
            TipSuggestion selectedValue = this.listOfTips.getSelectedValue();
            if (selectedValue == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectTipSuggestion"));
                return;
            }
            TipsSuggestionDialog dialog = new TipsSuggestionDialog(Messages.getString("EditTips"));
            dialog.setTipsPercentage(selectedValue.getPercentage());
            dialog.setTipsSortOrder(selectedValue.getSortOrder());
            dialog.setSize(PosUIManager.getSize(400, 250));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            int index = this.listOfTips.getSelectedIndex();
            ArrayList<TipSuggestion> values = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.listOfTips.getModel().getSize(); ++i) {
                values.add(this.listOfTips.getModel().getElementAt(i));
            }
            values.remove(index);
            values.add(index, dialog.getTipSuggestion());
            Collections.sort(values, (o1, o2) -> o1.getSortOrder() - o2.getSortOrder());
            this.addTipsSuggestionToModel(values);
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private void deleteTipSuggestions() {
        try {
            int index = this.listOfTips.getSelectedIndex();
            if (index == -1) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectTipSuggestion"));
                return;
            }
            ArrayList<TipSuggestion> values = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.listOfTips.getModel().getSize(); ++i) {
                values.add(this.listOfTips.getModel().getElementAt(i));
            }
            values.remove(index);
            this.addTipsSuggestionToModel(values);
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private void addTipsSuggestionToModel(List<TipSuggestion> values) {
        ListModel<TipSuggestion> listModel = new ListModel<TipSuggestion>(values);
        this.listOfTips.setModel(listModel);
        this.listOfTips.revalidate();
        this.listOfTips.repaint();
    }

    private void initTipsSuggestions() throws JSONException, JsonSyntaxException {
        if (this.selectedOrderType != null) {
            String tipsSection = ReceiptUtil.getReceiptSection(this.store, "tips_suggestion", this.selectedOrderType.getId());
            if (tipsSection == null) {
                tipsSection = "[{\"percentage\":25,\"sortOrder\":1},{\"percentage\":20,\"sortOrder\":2},{\"percentage\":18,\"sortOrder\":3},{\"percentage\":15,\"sortOrder\":4}]";
            }
            JSONArray arrays = new JSONArray(tipsSection);
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            ArrayList<TipSuggestion> values = new ArrayList<TipSuggestion>();
            for (int i = 0; i < arrays.length(); ++i) {
                Object ts = arrays.get(i);
                if (ts == null) continue;
                values.add((TipSuggestion)gson.fromJson(ts.toString(), TipSuggestion.class));
            }
            Collections.sort(values, (o1, o2) -> o1.getSortOrder() - o2.getSortOrder());
            this.addTipsSuggestionToModel(values);
        }
    }

    private void doPrintTestPage() {
        try {
            this.save(false);
            if (this.kitchenReceipt && ReceiptPrintService.hasNoKitchenReceiptPrinters() || !this.kitchenReceipt && ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            if (this.kitchenReceipt) {
                this.kitchenReceiptView.print();
            } else {
                this.mainReceiptView.print();
            }
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, e1);
        }
    }

    static enum SimpleColor {
        black(Color.black),
        red(Color.red);

        final Color color;

        private SimpleColor(Color color) {
            this.color = color;
        }

        public static SimpleColor getColor(String value) {
            Color color = SimpleColor.getAwtColor(value);
            if (color != null) {
                for (SimpleColor simpleColor : SimpleColor.values()) {
                    if (simpleColor.color.getRGB() != color.getRGB()) continue;
                    return simpleColor;
                }
            }
            return black;
        }

        public static Color getAwtColor(String propertyValue) {
            try {
                return Color.decode(propertyValue);
            }
            catch (Exception exception) {
                return Color.black;
            }
        }

        static String[] listModel() {
            List<SimpleColor> values = Arrays.asList(SimpleColor.values());
            String s = values.toString().replaceAll(" ", "");
            return s.substring(1, s.length() - 1).split(",");
        }
    }

    public class KitchenReceiptView
    extends JPanel {
        private JPanel reportPanel;
        private Ticket ticket;

        public KitchenReceiptView() {
            this.createUI();
        }

        public void createUI() {
            this.reportPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
            PosScrollPane scrollPane = new PosScrollPane(this.reportPanel);
            scrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.add(scrollPane);
        }

        public void createReport(Ticket ticket) throws Exception {
            this.ticket = ticket;
            try {
                ReceiptPrintService.getKitchenReceiptPrintPreviewService().rendererKitchenReceipt(ticket, this.reportPanel);
            }
            catch (Exception e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
            }
        }

        public void print() throws Exception {
            ReceiptPrintService.printToKitchen(this.ticket, false, false);
        }

        public JPanel getReportPanel() {
            return this.reportPanel;
        }
    }

    private class FontPropertiesPanel
    extends JPanel {
        private static final String FONT_A_CODE = "48";
        private static final String FONT_B_CODE = "01";
        public static final String FONT_TYPE_A = "Font A";
        public static final String FONT_TYPE_B = "Font B";
        private JCheckBox chkFontWeight;
        private JComboBox<Object> cbFontSize;
        private JComboBox<String> cbFontType;
        private FixedLengthTextField tfFontType;

        public FontPropertiesPanel() {
            this.setLayout((LayoutManager)new MigLayout("center,ins 0 0 3 0"));
            this.chkFontWeight = new JCheckBox(Messages.getString("Bold"));
            ArrayList<String> fontSizeList = new ArrayList<String>();
            fontSizeList.add("");
            for (int i = 10; i <= 39; ++i) {
                fontSizeList.add(String.format("%02d", i));
            }
            this.cbFontSize = new JComboBox<Object>(fontSizeList.toArray());
            this.cbFontType = new JComboBox<String>(new String[]{"", FONT_TYPE_A, FONT_TYPE_B});
            this.tfFontType = new FixedLengthTextField();
            this.tfFontType.setLength(2);
            this.add(this.chkFontWeight);
            this.add((Component)new JLabel(Messages.getString("Size")), "gapleft 10!");
            this.add(this.cbFontSize, "w 50!");
            this.add(new JLabel(Messages.getString("Type")));
            this.add(this.cbFontType);
            this.add((Component)this.tfFontType, "w 50!");
            this.cbFontType.addItemListener(e -> {
                if (e.getStateChange() != 1) {
                    return;
                }
                this.fontTypeChanged();
            });
        }

        public void updateView(String section) {
            try {
                this.chkFontWeight.setSelected(ReceiptConfigurationView.this.store.getBooleanProperty(section + ".font-weight", false));
                String fontSize = ReceiptConfigurationView.this.store.getProperty(section + ".font-size", "");
                if (StringUtils.isEmpty((String)fontSize)) {
                    this.cbFontSize.setSelectedIndex(0);
                } else {
                    this.cbFontSize.setSelectedItem(fontSize);
                }
                String fontType = ReceiptConfigurationView.this.store.getProperty(section + ".font-type", "");
                if (StringUtils.isEmpty((String)fontType)) {
                    this.cbFontType.setSelectedIndex(0);
                } else {
                    this.cbFontType.setSelectedItem(this.getSelectedFontTypeValue(fontType));
                }
                this.tfFontType.setText(fontType);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }

        public void updateModel(String section) {
            try {
                ReceiptConfigurationView.this.store.addProperty(section + ".font-weight", String.valueOf(this.chkFontWeight.isSelected()));
                ReceiptConfigurationView.this.store.addProperty(section + ".font-size", this.cbFontSize.getSelectedItem() == null ? "" : this.cbFontSize.getSelectedItem().toString());
                ReceiptConfigurationView.this.store.addProperty(section + ".font-type", this.tfFontType.getText());
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }

        private void fontTypeChanged() {
            try {
                if (this.cbFontType.getSelectedItem() == null || StringUtils.isBlank((String)this.cbFontType.getSelectedItem().toString())) {
                    this.tfFontType.setText("");
                    return;
                }
                this.tfFontType.setText(this.getSelectedFontTypeValue());
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }

        private String getSelectedFontTypeValue() {
            Object selectedValue = this.cbFontType.getSelectedItem();
            if (selectedValue == null) {
                return "";
            }
            switch (selectedValue.toString()) {
                case "Font B": {
                    return FONT_B_CODE;
                }
                case "Font A": {
                    return FONT_A_CODE;
                }
            }
            return "";
        }

        private String getSelectedFontTypeValue(String btyeArray) {
            if (btyeArray == null) {
                return "";
            }
            if (FONT_A_CODE.equalsIgnoreCase(btyeArray)) {
                return FONT_TYPE_A;
            }
            if (FONT_B_CODE.equalsIgnoreCase(btyeArray)) {
                return FONT_TYPE_B;
            }
            return "";
        }
    }
}

