/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Store;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class StoreConfigurationView
extends ConfigurationView {
    private Store store;
    private FixedLengthTextField tfRestaurantName;
    private FixedLengthTextField tfAddressLine1;
    private FixedLengthTextField tfAddressLine2;
    private FixedLengthTextField tfAddressLine3;
    private POSTextField tfTelephone;
    private POSTextField tfServiceCharge;
    private POSTextField tfDefaultGratuity;
    private POSTextField tfTicketFooter;
    private JTextField tfZipCode;
    private JLabel lblLoginImage;
    private JCheckBox chkCreateMember;
    private JCheckBox chkHideMembers;
    private JCheckBox chkHideVoidedItem;
    private JCheckBox chkShowCategoryBreakOut;
    private JCheckBox chkMultiUpload;
    private ImageResource imageResource;
    private POSTextField tfAdminEmail;

    public StoreConfigurationView(Store store) {
        this.store = store;
        this.setLayout((LayoutManager)new MigLayout("", "[grow][grow][][grow]", "[][][][][][][][][][][][][][][][][]"));
        JLabel lblNewLabel = new JLabel(Messages.getString("RestaurantConfigurationView.3") + ":");
        this.add((Component)lblNewLabel, "cell 0 1,alignx trailing");
        this.tfRestaurantName = new FixedLengthTextField(120);
        this.add((Component)this.tfRestaurantName, "cell 1 1 3 1,growx");
        JLabel lblAddressLine = new JLabel(Messages.getString("RestaurantConfigurationView.7") + ":");
        this.add((Component)lblAddressLine, "cell 0 2,alignx trailing");
        this.tfAddressLine1 = new FixedLengthTextField(60);
        this.add((Component)this.tfAddressLine1, "cell 1 2 3 1,growx");
        JLabel lblAddressLine_1 = new JLabel(Messages.getString("RestaurantConfigurationView.11") + ":");
        this.add((Component)lblAddressLine_1, "cell 0 3,alignx trailing");
        this.tfAddressLine2 = new FixedLengthTextField(60);
        this.add((Component)this.tfAddressLine2, "cell 1 3 3 1,growx");
        JLabel lblAddressLine_2 = new JLabel(Messages.getString("RestaurantConfigurationView.15") + ":");
        this.add((Component)lblAddressLine_2, "cell 0 4,alignx trailing");
        this.tfAddressLine3 = new FixedLengthTextField(60);
        this.add((Component)this.tfAddressLine3, "cell 1 4 3 1,growx");
        JLabel lblZipCode = new JLabel(Messages.getString("RestaurantConfigurationView.19"));
        this.add((Component)lblZipCode, "cell 0 5,alignx trailing");
        this.tfZipCode = new JTextField();
        this.add((Component)this.tfZipCode, "cell 1 5,growx");
        this.tfZipCode.setColumns(10);
        JLabel lblPhone = new JLabel(Messages.getString("RestaurantConfigurationView.22"));
        this.add((Component)lblPhone, "cell 0 6,alignx trailing");
        this.tfTelephone = new POSTextField();
        this.add((Component)this.tfTelephone, "cell 1 6,growx");
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 8 4 1,growx");
        JLabel lblAdminEmail = new JLabel(Messages.getString("StoreConfigurationView.7"));
        this.add((Component)lblAdminEmail, "cell 0 10,alignx trailing");
        this.tfAdminEmail = new POSTextField();
        this.add((Component)this.tfAdminEmail, "flowx,cell 1 10, growx");
        JSeparator separator_1 = new JSeparator();
        this.add((Component)separator_1, "cell 0 11 4 1,growx");
        JLabel lblServiceCharge = new JLabel(Messages.getString("RestaurantConfigurationView.42") + ":");
        this.add((Component)lblServiceCharge, "cell 0 12,alignx trailing");
        this.tfServiceCharge = new POSTextField();
        this.add((Component)this.tfServiceCharge, "cell 1 12,growx");
        JLabel label = new JLabel("%");
        this.add((Component)label, "cell 2 12");
        JLabel lblDefaultGratuity = new JLabel(Messages.getString("RestaurantConfigurationView.48") + ":");
        this.add((Component)lblDefaultGratuity, "flowy,cell 0 13,alignx trailing");
        this.tfDefaultGratuity = new POSTextField();
        this.add((Component)this.tfDefaultGratuity, "cell 1 13,growx");
        JLabel label_1 = new JLabel("%");
        this.add((Component)label_1, "cell 2 13");
        JLabel lblTicketFooterMessage = new JLabel(Messages.getString("RestaurantConfigurationView.54") + ":");
        this.add((Component)lblTicketFooterMessage, "cell 0 14,alignx trailing");
        this.tfTicketFooter = new POSTextField();
        this.add((Component)this.tfTicketFooter, "cell 1 14 3 1,growx");
        this.chkCreateMember = new JCheckBox(Messages.getString("StoreConfigurationView.2"));
        this.add((Component)this.chkCreateMember, "cell 1 15,growx");
        this.chkHideMembers = new JCheckBox(Messages.getString("StoreConfigurationView.3"));
        this.add((Component)this.chkHideMembers, "cell 1 16,growx");
        this.chkHideVoidedItem = new JCheckBox("Hide voided items in receipt");
        this.add((Component)this.chkHideVoidedItem, "cell 1 17,growx");
        this.chkShowCategoryBreakOut = new JCheckBox(Messages.getString("StoreUXConfigurationView.3"));
        this.add((Component)this.chkShowCategoryBreakOut, "cell 1 18,growx");
        this.chkMultiUpload = new JCheckBox(Messages.getString("TerminalForm.17"));
        this.add((Component)this.chkMultiUpload, "cell 1 19,growx");
        this.lblLoginImage = new JLabel();
        JButton btnBrowse = new JButton(Messages.getString("StoreConfigurationView.6"));
        btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreConfigurationView.this.doSelectImageFile();
            }
        });
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        String name = null;
        String addr1 = null;
        String addr2 = null;
        String addr3 = null;
        String telephone = null;
        String currencyName = null;
        String currencySymbol = null;
        int capacity = 0;
        int tables = 0;
        double serviceCharge = 0.0;
        double gratuityPercentage = 0.0;
        name = this.tfRestaurantName.getText();
        addr1 = this.tfAddressLine1.getText();
        addr2 = this.tfAddressLine2.getText();
        addr3 = this.tfAddressLine3.getText();
        telephone = this.tfTelephone.getText();
        if (StringUtils.isEmpty(currencyName)) {
            currencyName = POSConstants.DOLLAR;
        }
        if (StringUtils.isEmpty(currencySymbol)) {
            currencySymbol = "$";
        }
        try {
            serviceCharge = Double.parseDouble(this.tfServiceCharge.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            gratuityPercentage = Double.parseDouble(this.tfDefaultGratuity.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.store.setName(name);
        this.store.setAddressLine1(addr1);
        this.store.setAddressLine2(addr2);
        this.store.setAddressLine3(addr3);
        this.store.setZipCode(this.tfZipCode.getText());
        this.store.setTelephone(telephone);
        this.store.setCapacity(capacity);
        this.store.setTables(tables);
        this.store.setCurrencyName(currencyName);
        this.store.setCurrencySymbol(currencySymbol);
        this.store.setServiceChargePercentage(serviceCharge);
        this.store.setDefaultGratuityPercentage(gratuityPercentage);
        this.store.setTicketFooterMessage(this.tfTicketFooter.getText());
        this.store.setShowVoidedItemsOnTicket(!this.chkHideVoidedItem.isSelected());
        if (this.imageResource != null) {
            this.store.setLoginScreenBackgroundId(this.imageResource.getId());
        }
        this.store.setAdminEmail(this.tfAdminEmail.getText());
        this.store.addProperty("member.create.permission", String.valueOf(this.chkCreateMember.isSelected()));
        this.store.addProperty("hideRestrictedMembers", String.valueOf(this.chkHideMembers.isSelected()));
        this.store.addProperty("show_category_breakout.in_server_Summary", String.valueOf(this.chkShowCategoryBreakOut.isSelected()));
        this.store.setEnableMultiUploadButton(this.chkMultiUpload.isSelected());
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.tfRestaurantName.setText(this.store.getName());
        this.tfAddressLine1.setText(this.store.getAddressLine1());
        this.tfAddressLine2.setText(this.store.getAddressLine2());
        this.tfAddressLine3.setText(this.store.getAddressLine3());
        this.tfZipCode.setText(this.store.getZipCode());
        this.tfTelephone.setText(this.store.getTelephone());
        this.tfServiceCharge.setText(String.valueOf(this.store.getServiceChargePercentage()));
        this.tfDefaultGratuity.setText(String.valueOf(this.store.getDefaultGratuityPercentage()));
        this.tfTicketFooter.setText(this.store.getTicketFooterMessage());
        this.chkCreateMember.setSelected(this.store.hasCreateMemberPermission());
        this.chkHideVoidedItem.setSelected(!this.store.isShowVoidedItemsOnTicket());
        this.chkShowCategoryBreakOut.setSelected(POSUtil.getBoolean(this.store.getProperty("show_category_breakout.in_server_Summary")));
        this.chkMultiUpload.setSelected(this.store.isEnableMultiUploadButton());
        ImageIcon bgImage = this.store.getLoginScreenBackground();
        if (bgImage != null) {
            this.lblLoginImage.setIcon(new ImageIcon(bgImage.getImage().getScaledInstance(375, 120, 1)));
            this.imageResource = this.store.getLoginScreenBgImageResource();
        }
        this.chkHideMembers.setSelected(Boolean.valueOf(this.store.getProperty("hideRestrictedMembers", "false")));
        this.tfAdminEmail.setText(this.store.getAdminEmail());
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_STORE;
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setTitle(Messages.getString("StoreConfigurationView.11"));
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(true);
        dialog.setSelectBtnVisible(true);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblLoginImage.setIcon(this.imageResource.getScaledImage(200, 200));
        }
    }
}

