/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.explorer.TerminalForm;
import com.floreantpos.config.ui.CardConfigurationView;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.DatabaseConfigurationView;
import com.floreantpos.config.ui.GiftCardConfigurationView;
import com.floreantpos.config.ui.KitchenDisplayConfigurationView;
import com.floreantpos.config.ui.PaymentOptionConfigurationView;
import com.floreantpos.config.ui.PeripheralConfigurationView;
import com.floreantpos.config.ui.PrintConfigurationView;
import com.floreantpos.config.ui.TicketImportConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.TicketImportPlugin;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class TerminalConfigurationDialog
extends POSDialog
implements ChangeListener,
ActionListener {
    private static final String OK = POSConstants.OK;
    private static final String CANCEL = POSConstants.CANCEL;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private List<ConfigurationView> views = new ArrayList<ConfigurationView>();
    private Terminal terminal;

    public TerminalConfigurationDialog() {
        this(DataProvider.get().getCurrentTerminal());
    }

    public TerminalConfigurationDialog(Terminal terminal) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        boolean currentTerminal;
        this.terminal = terminal;
        boolean bl = currentTerminal = this.terminal.getId() == DataProvider.get().getCurrentTerminal().getId();
        if (currentTerminal) {
            this.setTitle(POSConstants.CONFIGURE_WINDOW_TITLE);
        } else {
            this.setTitle("Configure Terminal " + terminal.getId());
        }
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fill", "", "[fill,grow][]"));
        this.tabbedPane.addChangeListener(this);
        contentPanel.add((Component)this.tabbedPane, "span, grow");
        this.addView(new TerminalForm(this.terminal));
        this.addView(new PrintConfigurationView(this.terminal));
        if (DataProvider.get().getCurrentTerminal().equals(this.terminal)) {
            this.addView(new CardConfigurationView());
            this.addView(new DatabaseConfigurationView());
            this.addView(new PeripheralConfigurationView());
            this.addView(new GiftCardConfigurationView());
            this.addView(new KitchenDisplayConfigurationView());
            DataProvider.get().refreshCurrentTerminal();
            this.addView(new PaymentOptionConfigurationView(DataProvider.get().getCurrentTerminal()));
            TicketImportPlugin ticketImportPlugin = (TicketImportPlugin)ExtensionManager.getPlugin(TicketImportPlugin.class);
            if (ticketImportPlugin != null) {
                this.addView(new TicketImportConfigurationView());
            }
        }
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JButton btnCancel = new JButton(CANCEL);
        btnCancel.addActionListener(this);
        bottomPanel.add((Component)btnCancel, "dock east, gaptop 5,gapright 8, gapbottom 10");
        JButton btnOk = new JButton(OK);
        btnOk.addActionListener(this);
        bottomPanel.add((Component)btnOk, "dock east, gapright 5, gaptop 5, gapbottom 10");
        this.add((Component)bottomPanel, "South");
        this.setDefaultCloseOperation(2);
        for (FloreantPlugin plugin : ExtensionManager.getPlugins()) {
            plugin.initConfigurationView((JDialog)this);
        }
        this.add((Component)contentPanel, "Center");
    }

    public void addView(ConfigurationView view) {
        this.tabbedPane.addTab(view.getName(), view);
        this.views.add(view);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.stateChanged(null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ConfigurationView view = (ConfigurationView)this.tabbedPane.getSelectedComponent();
        if (!view.isInitialized()) {
            try {
                view.initialize();
            }
            catch (Exception e1) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e1);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (OK.equalsIgnoreCase(e.getActionCommand())) {
            try {
                for (ConfigurationView view : this.views) {
                    if (!view.isInitialized() || view.save()) continue;
                    return;
                }
                this.setCanceled(false);
                this.dispose();
            }
            catch (StaleStateException x) {
                POSMessageDialog.showError(this, x.getMessage());
            }
            catch (PosException x) {
                POSMessageDialog.showError(this, x.getMessage());
            }
            catch (Exception x) {
                POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
            }
        } else if (CANCEL.equalsIgnoreCase(e.getActionCommand())) {
            this.setCanceled(true);
            this.dispose();
        }
    }
}

