/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.customer.CustomerListTableModel;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.customer.CustomerTable;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.QuickCustomerForm;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DefaultCustomerListView
extends CustomerSelector {
    private PosButton btnCreateNewCustomer;
    private CustomerTable customerTable;
    private POSTextField tfMobileEmailName;
    private PosButton btnInfo;
    protected Customer selectedCustomer;
    private Ticket ticket;
    private PosButton btnCancel;
    private QwertyKeyPad qwertyKeyPad;
    private PosButton btnEditCustomer;
    private CustomerListTableModel customerListTableModel;
    private PosButton btnNext;
    private PosButton btnPrevious;
    private JLabel lblNumberOfItem;

    public DefaultCustomerListView() {
        this.initUI();
        this.doSearchCustomerPagingStart();
    }

    public DefaultCustomerListView(Ticket ticket) {
        this.ticket = ticket;
        this.initUI();
        this.loadCustomerFromTicket();
    }

    public void initUI() {
        this.setLayout(new BorderLayout());
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout());
        this.tfMobileEmailName = new POSTextField(120);
        this.tfMobileEmailName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCustomerListView.this.doSearchCustomerPagingStart();
            }
        });
        PosButton btnSearch = new PosButton(Messages.getString("CustomerSelectionDialog.15"));
        btnSearch.setFocusable(false);
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCustomerListView.this.doSearchCustomerPagingStart();
            }
        });
        PosButton btnKeyboard = new PosButton(IconFactory.getIcon("/images/", "keyboard.png"));
        btnKeyboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCustomerListView.this.qwertyKeyPad.setCollapsed(!DefaultCustomerListView.this.qwertyKeyPad.isCollapsed());
            }
        });
        searchPanel.add((Component)this.tfMobileEmailName, "growy");
        searchPanel.add((Component)btnKeyboard, "growy,w " + PosUIManager.getSize(80) + "!,h " + PosUIManager.getSize(35) + "!");
        searchPanel.add((Component)btnSearch, ",growy,h " + PosUIManager.getSize(35) + "!");
        this.add((Component)searchPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.setBorder(new TitledBorder(null, POSConstants.SELECT_CUSTOMER, 2, 2, null, null));
        JPanel customerListPanel = new JPanel(new BorderLayout(0, 0));
        customerListPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.customerTable = new CustomerTable();
        this.customerListTableModel = new CustomerListTableModel();
        this.customerTable.setModel(this.customerListTableModel);
        this.customerTable.setFocusable(false);
        this.customerTable.setRowHeight(30);
        this.customerTable.getTableHeader().setPreferredSize(new Dimension(100, 35));
        this.customerTable.getSelectionModel().setSelectionMode(0);
        this.customerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DefaultCustomerListView.this.selectedCustomer = DefaultCustomerListView.this.customerTable.getSelectedCustomer();
                if (DefaultCustomerListView.this.selectedCustomer == null) {
                    DefaultCustomerListView.this.btnInfo.setEnabled(false);
                }
            }
        });
        PosScrollPane scrollPane = new PosScrollPane();
        scrollPane.setFocusable(false);
        scrollPane.setViewportView(this.customerTable);
        customerListPanel.add((Component)scrollPane, "Center");
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3", "[][center, grow][]", ""));
        this.btnInfo = new PosButton(Messages.getString("CustomerSelectionDialog.23"));
        this.btnInfo.setFocusable(false);
        panel.add((Component)this.btnInfo, " skip 1, split 7");
        this.btnInfo.setEnabled(false);
        PosButton btnHistory = new PosButton(Messages.getString("CustomerSelectionDialog.24"));
        btnHistory.setEnabled(false);
        panel.add((Component)btnHistory, "");
        this.btnCreateNewCustomer = new PosButton(Messages.getString("NEW"));
        this.btnCreateNewCustomer.setFocusable(false);
        panel.add((Component)this.btnCreateNewCustomer, "");
        this.btnCreateNewCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCustomerListView.this.doCreateNewCustomer();
            }
        });
        this.btnEditCustomer = new PosButton(Messages.getString("EDIT"));
        this.btnEditCustomer.setFocusable(false);
        panel.add((Component)this.btnEditCustomer, "");
        this.btnEditCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCustomerListView.this.doEditCustomer();
            }
        });
        PosButton btnSelect = new PosButton(Messages.getString("CustomerSelectionDialog.28"));
        btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultCustomerListView.this.getSelectedCustomer() == null) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DefaultCustomerListView.0"));
                    return;
                }
                if (DefaultCustomerListView.this.isCreateNewTicket()) {
                    DefaultCustomerListView.this.doCreateNewTicket();
                } else {
                    DefaultCustomerListView.this.closeDialog(false);
                }
            }
        });
        panel.add((Component)btnSelect, "");
        this.btnCancel = new PosButton(Messages.getString("CANCEL"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultCustomerListView.this.closeDialog(true);
            }
        });
        panel.add((Component)this.btnCancel, "");
        this.btnNext = new PosButton(Messages.getString("DefaultCustomerListView.1"));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultCustomerListView.this.customerListTableModel.hasNext()) {
                    DefaultCustomerListView.this.customerListTableModel.setCurrentRowIndex(DefaultCustomerListView.this.customerListTableModel.getNextRowIndex());
                    DefaultCustomerListView.this.doSearchCustomer();
                }
            }
        });
        this.btnPrevious = new PosButton(Messages.getString("DefaultCustomerListView.2"));
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DefaultCustomerListView.this.customerListTableModel.hasPrevious()) {
                    DefaultCustomerListView.this.customerListTableModel.setCurrentRowIndex(DefaultCustomerListView.this.customerListTableModel.getPreviousRowIndex());
                    DefaultCustomerListView.this.doSearchCustomer();
                }
                DefaultCustomerListView.this.updateButtonStatus();
            }
        });
        this.lblNumberOfItem = new JLabel();
        panel.add(new JSeparator());
        panel.add(this.lblNumberOfItem);
        panel.add(this.btnPrevious);
        panel.add(this.btnNext);
        customerListPanel.add((Component)panel, "South");
        centerPanel.add((Component)customerListPanel, "Center");
        this.add(centerPanel);
        this.qwertyKeyPad = new QwertyKeyPad();
        this.qwertyKeyPad.setCollapsed(false);
        this.add((Component)((Object)this.qwertyKeyPad), "South");
        this.updateButtonStatus();
    }

    public void updateButtonStatus() {
        this.btnNext.setEnabled(this.customerListTableModel.hasNext());
        this.btnPrevious.setEnabled(this.customerListTableModel.hasPrevious());
    }

    private void loadCustomerFromTicket() {
        String customerIdString = this.ticket.getProperty("CUSTOMER_ID");
        if (StringUtils.isNotEmpty((String)customerIdString)) {
            Customer customer = CustomerDAO.getInstance().get(customerIdString);
            ArrayList<Customer> list = new ArrayList<Customer>();
            list.add(customer);
            this.customerTable.setModel(new CustomerListTableModel(list));
        }
    }

    private void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(canceled);
            windowAncestor.dispose();
        }
    }

    protected void doSetCustomer(Customer customer) {
        if (this.ticket != null) {
            this.ticket.setCustomer(customer);
            TicketDAO.getInstance().saveOrUpdate(this.ticket);
        }
    }

    private void doCreateNewTicket() {
        try {
            Customer selectedCustomer = this.getSelectedCustomer();
            if (selectedCustomer == null) {
                return;
            }
            this.closeDialog(false);
            OrderServiceFactory.getOrderService().createNewTicket(this.getOrderType(), null, selectedCustomer);
        }
        catch (TicketAlreadyExistsException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    protected void doRemoveCustomerFromTicket() {
        if (this.ticket == null) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("CustomerSelectionDialog.2"), Messages.getString("CONFIRM"));
        if (option != 0) {
            return;
        }
        this.ticket.removeCustomer();
        TicketDAO.getInstance().saveOrUpdate(this.ticket);
    }

    private void doSearchCustomerPagingStart() {
        this.customerListTableModel.setCurrentRowIndex(0);
        this.doSearchCustomer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSearchCustomer() {
        try {
            int totalNumber;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.qwertyKeyPad.setCollapsed(true);
            String mobileEmailName = this.tfMobileEmailName.getText();
            if (StringUtils.isEmpty((String)mobileEmailName)) {
                CustomerDAO.getInstance().loadCustomers(this.customerListTableModel);
            } else {
                CustomerDAO.getInstance().findByMobileLoyalityName(mobileEmailName, this.customerListTableModel);
            }
            if (this.customerListTableModel.getRows().size() == 0) {
                this.customerTable.getSelectionModel().addSelectionInterval(0, 0);
            }
            int startNumber = this.customerListTableModel.getCurrentRowIndex() + 1;
            int endNumber = this.customerListTableModel.getNextRowIndex();
            if (endNumber > (totalNumber = this.customerListTableModel.getNumRows())) {
                endNumber = totalNumber;
            }
            this.lblNumberOfItem.setText(String.format(Messages.getString("DefaultCustomerListView.3"), startNumber, endNumber, totalNumber));
            this.customerListTableModel.fireTableDataChanged();
            this.customerTable.repaint();
            this.updateButtonStatus();
        }
        catch (Exception e) {
            PosLog.error(DefaultCustomerListView.class, e);
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void doCreateNewCustomer() {
        boolean setKeyPad = true;
        QuickCustomerForm form = new QuickCustomerForm(setKeyPad);
        form.enableCustomerFields(true);
        BeanEditorDialog dialog = new BeanEditorDialog(form);
        dialog.setResizable(false);
        dialog.open();
        if (!dialog.isCanceled()) {
            this.selectedCustomer = (Customer)form.getBean();
            CustomerListTableModel model = (CustomerListTableModel)this.customerTable.getModel();
            model.addItem(this.selectedCustomer);
        }
    }

    protected void doEditCustomer() {
        int index = this.customerTable.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showError(this, Messages.getString("DefaultCustomerListView.4"));
            return;
        }
        CustomerListTableModel dataModel = (CustomerListTableModel)this.customerTable.getModel();
        Customer customer = (Customer)dataModel.getRowData(index);
        if (customer == null) {
            return;
        }
        QuickCustomerForm form = new QuickCustomerForm(customer);
        form.enableCustomerFields(true);
        BeanEditorDialog dialog = new BeanEditorDialog(form);
        dialog.setResizable(false);
        dialog.open();
        if (!dialog.isCanceled()) {
            dataModel.fireTableRowsUpdated(index, index);
        }
    }

    @Override
    public String getName() {
        return "C";
    }

    @Override
    public Customer getSelectedCustomer() {
        return this.selectedCustomer;
    }

    @Override
    public void updateView(boolean update) {
        Store store = DataProvider.get().getStore();
        this.btnCreateNewCustomer.setVisible(store.hasCreateMemberPermission());
        this.btnCancel.setVisible(update);
        this.loadCustomer();
    }

    private void loadCustomer() {
        Customer customer = this.getCustomer();
        if (customer != null) {
            this.doSearchCustomerPagingStart();
        } else {
            this.doSearchCustomerPagingStart();
        }
    }

    @Override
    public void redererCustomers() {
    }
}

