/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan;

import com.floreantpos.PosLog;
import com.floreantpos.SystemProperties;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.FloorLayoutPlugin;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.action.FloorPlanConfigurationAction;
import com.floreantpos.floorplan.action.ShowFloorsAction;
import com.floreantpos.floorplan.action.ShowTableTypesBrowserAction;
import com.floreantpos.floorplan.action.TableBookingBrowserAction;
import com.floreantpos.floorplan.ui.FloorPlanView;
import com.floreantpos.floorplan.ui.FloorStatusDisplay;
import com.floreantpos.floorplan.ui.ShopTableTypeForm;
import com.floreantpos.floorplan.versioning.VersionInfo;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.common.about.AboutPluginAction;
import com.orocube.common.util.ProductInfo;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import java.awt.Component;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

@PluginImplementation
public class FloorLayoutPluginImpl
extends FloorLayoutPlugin
implements ProductInfo {
    private boolean initialized = false;
    private FloorPlanView tableSelectionView;

    public void initConfigurationView(JDialog dialog) {
    }

    public void openTicketsAndTablesDisplay() {
        FloorStatusDisplay view = new FloorStatusDisplay();
        view.setIconImage(Application.getApplicationIcon().getImage());
        view.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        view.setVisible(true);
    }

    public List<ShopTable> captureTableNumbers(Ticket ticket) {
        this.initialize();
        return null;
    }

    public void initialize() {
        if (this.initialized || ShopFloorDAO.getInstance().hasFloor()) {
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("FloorLayoutPluginImpl.0"), Messages.getString("FloorLayoutPluginImpl.1"));
        if (option != 0) {
            return;
        }
        this.createDefaultFloor();
        this.initialized = true;
    }

    public void createDefaultFloor() {
        int i;
        ShopFloor floor = new ShopFloor();
        floor.setName("Main Floor");
        List<ShopTable> tableList = ShopTableDAO.getInstance().findAll();
        HashSet<ShopTable> shopTables = new HashSet<ShopTable>();
        if (tableList != null && !tableList.isEmpty()) {
            for (i = 0; i < tableList.size(); ++i) {
                ShopTable shopTable = tableList.get(i);
                shopTable.setX(this.getPositionX().get(i));
                shopTable.setY(this.getPositionY().get(i));
                ShopTableDAO.getInstance().saveOrUpdate(shopTable);
                shopTables.add(shopTable);
                if (i != 13) {
                    continue;
                }
                break;
            }
        } else {
            for (i = 0; i < this.getPositionX().size(); ++i) {
                shopTables.add(new ShopTable(floor, this.getPositionX().get(i), this.getPositionY().get(i), i + 1));
            }
        }
        floor.setTables(shopTables);
        Session session = ShopFloorDAO.getInstance().getSession();
        Transaction transaction = session.beginTransaction();
        session.saveOrUpdate((Object)floor);
        transaction.commit();
        session.close();
    }

    private List<Integer> getPositionX() {
        ArrayList<Integer> positionX = new ArrayList<Integer>();
        positionX.add(19);
        positionX.add(161);
        positionX.add(309);
        positionX.add(17);
        positionX.add(162);
        positionX.add(318);
        positionX.add(18);
        positionX.add(161);
        positionX.add(330);
        positionX.add(22);
        positionX.add(169);
        positionX.add(329);
        positionX.add(487);
        positionX.add(661);
        return positionX;
    }

    private List<Integer> getPositionY() {
        ArrayList<Integer> positionY = new ArrayList<Integer>();
        positionY.add(12);
        positionY.add(12);
        positionY.add(14);
        positionY.add(132);
        positionY.add(136);
        positionY.add(140);
        positionY.add(258);
        positionY.add(258);
        positionY.add(260);
        positionY.add(382);
        positionY.add(381);
        positionY.add(387);
        positionY.add(391);
        positionY.add(390);
        return positionY;
    }

    public void initUI(PosWindow posWindow) {
    }

    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
        JMenuBar menuBar = backOfficeWindow.getBackOfficeMenuBar();
        JMenu floorPlanMenu = backOfficeWindow.getFloorPlanMenu();
        floorPlanMenu.add(new JMenuItem(new ShowFloorsAction()));
        floorPlanMenu.add(new JMenuItem(new ShowTableTypesBrowserAction()));
        if (!SystemProperties.isForeTees()) {
            floorPlanMenu.add(new JMenuItem(new TableBookingBrowserAction()));
        }
        floorPlanMenu.add(new JMenuItem(new FloorPlanConfigurationAction()));
        menuBar.add(floorPlanMenu);
    }

    public void initAboutMenu(BackOfficeWindow backOfficeWindow) {
        JMenuBar menuBar = backOfficeWindow.getBackOfficeMenuBar();
        JMenu floorPlanMenu = backOfficeWindow.getFloorPlanMenu();
        floorPlanMenu.add(new JMenuItem((Action)new AboutPluginAction((LicenseSelectionListener)this, this.getLicense(), (Component)POSUtil.getBackOfficeWindow(), (ProductInfo)this)));
        menuBar.add(floorPlanMenu);
    }

    public String getId() {
        return String.valueOf("DefaultFloorLayoutPlugin".hashCode());
    }

    public BeanEditor<ShopTableType> getBeanEditor() {
        return new ShopTableTypeForm();
    }

    public FloorPlanView createTableSelector() {
        if (this.tableSelectionView == null) {
            this.tableSelectionView = new FloorPlanView();
        }
        return this.tableSelectionView;
    }

    public void updateView() {
        if (this.tableSelectionView != null) {
            this.tableSelectionView.rendererTables();
        }
    }

    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    public void restartPOS(boolean restart) {
        if (restart) {
            try {
                ProcessUtil.restart();
            }
            catch (Exception e) {
                PosLog.error(((Object)((Object)this)).getClass(), e);
            }
        }
    }

    public Component getParent() {
        return POSUtil.getFocusedWindow();
    }

    public boolean requireLicense() {
        return false;
    }

    public String getProductName() {
        return VersionInfo.getAppName();
    }

    public String getProductVersion() {
        return VersionInfo.getVersion();
    }

    public Integer getProductNumericVersion() {
        return VersionInfo.getNumericVersion();
    }

    public URL getChangeLogURL() {
        return ((Object)((Object)this)).getClass().getResource("/floorplan-change.log.xml");
    }

    public String getUpdateServerURL() {
        String updateUrl = TerminalConfig.getPluginUpdateServerURL("floorplan");
        if (StringUtils.isEmpty((String)updateUrl)) {
            updateUrl = "https://orodev.net/update/floorplan";
        }
        return updateUrl;
    }

    public int getMinParentNumericVersion() {
        return 1202;
    }

    public String getMinParentVersion() {
        return "1.4.146";
    }

    public boolean isEmbedded() {
        return true;
    }

    public boolean isActivated() {
        return true;
    }
}

