/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.SystemProperties;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.MergeTicketsAction;
import com.floreantpos.actions.NewBarTabAction;
import com.floreantpos.actions.ShowTransactionsAuthorizationsAction;
import com.floreantpos.actions.TransferTicketItemsAction;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.floorplan.dao.FloorplanDAO;
import com.floreantpos.floorplan.ui.FloorBookingView;
import com.floreantpos.floorplan.ui.FloorView;
import com.floreantpos.floorplan.ui.MultiFloorTabPane;
import com.floreantpos.floorplan.ui.TableBookingForm;
import com.floreantpos.floorplan.ui.booking.AllReservationDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.CacheRefreshListener;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.GuestCheckTktFirstOpenDialog;
import com.floreantpos.ui.dialog.GuestChkBillDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.UiRenderer;
import com.floreantpos.ui.tableselection.BarTabSelectionView;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jdesktop.swingx.JXCollapsiblePane;

public class FloorPlanView
extends TableSelectionView
implements DataChangeListener,
ActionListener,
IMqttMessageListener,
CacheRefreshListener {
    private static FloorPlanView instance;
    private JPanel leftBookingOrderPanel;
    private JPanel btnAddBookingPanel;
    private JXCollapsiblePane leftInnerCollapsiblePane;
    private POSToggleButton btnCollapsePlus;
    private POSToggleButton btnCollapseMinus;
    private JXCollapsiblePane leftCollapsiblePane;
    private MultiFloorTabPane floorTabPane;
    private POSToggleButton btnGroup;
    private PosButton btnDone;
    private PosButton btnCancel;
    private PosBlinkButton btnRefresh;
    private PosButton btnAuthorize;
    private POSToggleButton btnHoldFire;
    private POSToggleButton btnGuestCheck;
    private POSToggleButton btnSplitCheck;
    private POSToggleButton btnSettle;
    private POSToggleButton btnReorder;
    private POSToggleButton btnRelease;
    private PosButton btnNewBarTab;
    private PosButton btnMargeTickets;
    private PosButton btnTransferTicketItems;
    private POSToggleButton btnRearrange;
    private PosButton btnGroupSettle;
    private PosButton btnSwitchOptions;
    private boolean isOptions;
    private PosButton btnTimeLog;
    private PosButton btnStatus;
    private PosButton btnTmFirstOpened;
    private PosButton btnTmBillPrint;
    private PosButton btnCloseDialog;
    private ButtonGroup btnGroups;
    private boolean complete;
    private boolean seat;
    private Ticket currentTicket;
    private JPanel mainPanel;

    public FloorPlanView() {
        this.initComponents();
        this.subscribeToNotificationService();
        DataProvider.get().addCacheRefreshListener(this);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.add((Component)this.createButtonActionPanel(), "East");
        if (SystemProperties.isShowTableReservation()) {
            this.add((Component)this.createReservationPanel(), "West");
            this.createLeftBookingInfoPanel(this.mainPanel);
        }
        this.mainPanel.add(this.crateFloorPane());
        this.add(this.mainPanel);
    }

    private MultiFloorTabPane crateFloorPane() {
        this.floorTabPane = new MultiFloorTabPane(this);
        List<ShopFloor> shopFloors = ShopFloorDAO.getInstance().findAll();
        for (ShopFloor shopFloor : shopFloors) {
            this.floorTabPane.addFloor(shopFloor);
        }
        return this.floorTabPane;
    }

    private JPanel createButtonActionPanel() {
        HorizontalTouchScrollPanel actionBtnPanel = new HorizontalTouchScrollPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1", "grow,sg,fill", ""));
        actionBtnPanel.setPreferredSize(PosUIManager.getSize(130, 0));
        this.btnGroups = new ButtonGroup();
        this.btnGroup = new POSToggleButton(Messages.getString("TableLayoutView.31"));
        this.btnDone = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.btnCancel = new PosButton(POSConstants.CANCEL);
        this.btnHoldFire = new POSToggleButton(Messages.getString("TableLayoutView.2"));
        this.btnGuestCheck = new POSToggleButton(Messages.getString("TableLayoutView.3"));
        this.btnSplitCheck = new POSToggleButton(Messages.getString("TableLayoutView.4"));
        this.btnSettle = new POSToggleButton(Messages.getString("TableLayoutView.5"));
        this.btnGroupSettle = new PosButton(Messages.getString("TableLayoutView.6"));
        this.btnAuthorize = new PosButton(Messages.getString("TableLayoutView.7"));
        this.btnReorder = new POSToggleButton(Messages.getString("FloorPlanView.0"));
        this.btnRelease = new POSToggleButton(Messages.getString("TableLayoutView.9"));
        this.btnGroup.addActionListener(this);
        this.btnDone.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.btnDone.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnGroups.add(this.btnGroup);
        this.btnGroups.add(this.btnHoldFire);
        this.btnGroups.add(this.btnGuestCheck);
        this.btnGroups.add(this.btnSplitCheck);
        this.btnGroups.add(this.btnSettle);
        this.btnGroups.add(this.btnReorder);
        this.btnGroups.add(this.btnRelease);
        this.btnNewBarTab = new PosButton(Messages.getString("TableLayoutView.10"));
        this.btnNewBarTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BarTabSelectionView barSelectedFloorView = (BarTabSelectionView)FloorPlanView.this.floorTabPane.getSelectedFloorView();
                if (barSelectedFloorView == null) {
                    return;
                }
                List<ShopTable> selectedTables = FloorPlanView.this.getSelectedTables();
                NewBarTabAction newBarTabAction = new NewBarTabAction(FloorPlanView.this.getOrderType(), selectedTables, POSUtil.getFocusedWindow());
                newBarTabAction.actionPerformed(e);
                FloorPlanView.this.closeDialog(false);
            }
        });
        this.btnNewBarTab.setVisible(false);
        this.btnMargeTickets = new PosButton(Messages.getString("TableLayoutView.11"));
        this.btnMargeTickets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloorPlanView.this.doShowMargeTicketDialog();
            }
        });
        this.btnTransferTicketItems = new PosButton("<html><body><center>Transfer<br/>items</center></body></html>");
        this.btnTransferTicketItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloorPlanView.this.doShowTransferTicketItemsDialog();
            }
        });
        ((Container)actionBtnPanel).add((Component)this.btnGroup, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnNewBarTab, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnDone, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnCancel, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnHoldFire, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnGuestCheck, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnSplitCheck, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnMargeTickets, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnTransferTicketItems, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnSettle, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnGroupSettle, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnReorder, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnAuthorize, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnRelease, "grow");
        this.btnTmFirstOpened = new PosButton(Messages.getString("TableLayoutView.13"));
        this.btnTmFirstOpened.setVisible(false);
        this.btnTmBillPrint = new PosButton(Messages.getString("TableLayoutView.14"));
        this.btnTmBillPrint.setVisible(false);
        this.btnTimeLog = new PosButton(Messages.getString("TableLayoutView.15"));
        this.btnTimeLog.setVisible(false);
        this.btnStatus = new PosButton(Messages.getString("TableLayoutView.16"));
        this.btnStatus.setVisible(false);
        this.btnRearrange = new POSToggleButton(Messages.getString("TableLayoutView.17"));
        this.btnRearrange.setVisible(false);
        this.btnRearrange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FloorPlanView.this.doSetRearrangeMode();
            }
        });
        this.btnTimeLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FloorPlanView.this.toggleTimeLog(FloorPlanView.this.isOptions, false);
            }
        });
        this.btnStatus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FloorPlanView.this.toggleTimeLog(FloorPlanView.this.isOptions, true);
            }
        });
        this.btnTmFirstOpened.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloorPlanView.this.doShowTimeFirstOpen();
            }
        });
        this.btnTmBillPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloorPlanView.this.doShowTimeBillPrint();
            }
        });
        ((Container)actionBtnPanel).add((Component)this.btnTimeLog, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnStatus, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnTmFirstOpened, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnTmBillPrint, "grow");
        ((Container)actionBtnPanel).add((Component)this.btnRearrange, "grow");
        this.isOptions = false;
        this.btnRefresh = new PosBlinkButton(POSConstants.REFRESH);
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloorPlanView.this.doRefresh();
            }
        });
        ((Container)actionBtnPanel).add((Component)this.btnRefresh, "grow");
        this.btnSwitchOptions = new PosButton(Messages.getString("TableLayoutView.23"));
        this.btnSwitchOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FloorPlanView.this.doShowSpecialFunc();
            }
        });
        ((Container)actionBtnPanel).add((Component)this.btnSwitchOptions, "grow");
        this.btnAuthorize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ShowTransactionsAuthorizationsAction().execute();
            }
        });
        this.btnGroupSettle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new GroupSettleTicketAction(Application.getCurrentUser()).actionPerformed(null);
                FloorPlanView.this.doRefresh();
            }
        });
        this.btnCloseDialog = new PosButton(Messages.getString("TableLayoutView.26"));
        this.btnCloseDialog.setVisible(false);
        this.btnCloseDialog.addActionListener(e -> this.closeDialog(true));
        ((Container)actionBtnPanel).add((Component)this.btnCloseDialog, "grow");
        return actionBtnPanel;
    }

    private void doSetRearrangeMode() {
        try {
            UiRenderer selectedFloorView = this.floorTabPane.getSelectedFloorView();
            if (selectedFloorView == null || !(selectedFloorView instanceof FloorView)) {
                return;
            }
            ((FloorView)selectedFloorView).setRearrange(this.btnRearrange.isSelected());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE + e);
        }
    }

    private void toggleTimeLog(boolean on, boolean isShowStatus) {
        try {
            UiRenderer selectedFloorView = this.floorTabPane.getSelectedFloorView();
            if (selectedFloorView == null || !(selectedFloorView instanceof FloorView)) {
                return;
            }
            Set<ShopTable> tables = ((FloorView)selectedFloorView).getFloor().getTables();
            if (tables == null) {
                return;
            }
            ArrayList<Ticket> availableTickets = new ArrayList<Ticket>();
            for (ShopTable shopTable : tables) {
                if (on) {
                    List<String> ticketNumbers = shopTable.getShopTableStatus().getListOfTicketNumbers();
                    if (ticketNumbers != null && ticketNumbers.size() > 0) {
                        int guestNumber = 0;
                        for (String string : ticketNumbers) {
                            Ticket ticket = TicketDAO.getInstance().get(string);
                            if (ticket != null) {
                                shopTable.setTicketCreateTime(ticket.getCreateDate());
                                availableTickets.add(ticket);
                                guestNumber += ticket.getNumberOfGuests().intValue();
                                continue;
                            }
                            shopTable.setTicketCreateTime(null);
                        }
                        shopTable.setGuestNumber(guestNumber >= 0 ? guestNumber : 0);
                        shopTable.setShowStatus(isShowStatus);
                        continue;
                    }
                    shopTable.setTicketCreateTime(null);
                    shopTable.setShowStatus(false);
                    continue;
                }
                shopTable.setTicketCreateTime(null);
                shopTable.setShowStatus(false);
            }
            ((FloorView)selectedFloorView).updateTables();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE + e);
        }
    }

    private void doShowTimeFirstOpen() {
        GuestCheckTktFirstOpenDialog dialog = new GuestCheckTktFirstOpenDialog();
        dialog.setData(this.getAvailableTickets());
        dialog.setSize(PosUIManager.getSize(700, 500));
        dialog.open();
    }

    private ArrayList<Ticket> getAvailableTickets() {
        FloorView selectedFloorView = (FloorView)this.floorTabPane.getSelectedFloorView();
        ArrayList<Ticket> availableTickets = new ArrayList<Ticket>();
        try {
            if (selectedFloorView == null) {
                return availableTickets;
            }
            Set<ShopTable> tables = selectedFloorView.getFloor().getTables();
            if (tables == null) {
                return availableTickets;
            }
            for (ShopTable shopTable : tables) {
                List<String> ticketNumbers = shopTable.getShopTableStatus().getListOfTicketNumbers();
                if (ticketNumbers == null || ticketNumbers.size() <= 0) continue;
                String string = ticketNumbers.get(0);
                Ticket ticket = TicketDAO.getInstance().get(string);
                if (ticket == null) continue;
                availableTickets.add(ticket);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE + e);
        }
        return availableTickets;
    }

    private void doShowTimeBillPrint() {
        GuestChkBillDialog dialog = new GuestChkBillDialog();
        dialog.setSize(PosUIManager.getSize(700, 500));
        dialog.open();
    }

    private void doShowSpecialFunc() {
        if (!this.isHomeViewMode()) {
            return;
        }
        if (!this.isOptions) {
            this.btnSwitchOptions.setText(Messages.getString("TableLayoutView.28"));
            this.isOptions = true;
            this.showOptions(this.isOptions);
            this.btnRearrange.setSelected(false);
            this.doSetRearrangeMode();
        } else {
            this.isOptions = false;
            this.toggleTimeLog(this.isOptions, false);
            this.showOptions(this.isOptions);
            this.btnRearrange.setSelected(false);
            this.doSetRearrangeMode();
        }
    }

    private void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(canceled);
            this.setTicketTransferMode(false);
            windowAncestor.dispose();
        }
    }

    public void doRefresh() {
        if (SystemProperties.isShowTableReservation()) {
            this.createCustomerBookingInfoPanel();
        }
        this.clearSelection();
        this.rendererTables();
        this.btnRefresh.setBlinking(false);
        this.setCreateNewTicket(true);
    }

    private JPanel createReservationPanel() {
        this.leftCollapsiblePane = new JXCollapsiblePane(JXCollapsiblePane.Direction.LEFT);
        this.leftCollapsiblePane.setBorder((Border)new EmptyBorder(10, 0, 5, 0));
        this.leftCollapsiblePane.setCollapsed(false);
        this.leftCollapsiblePane.setVisible(true);
        this.btnCollapsePlus = new POSToggleButton("+");
        this.btnCollapsePlus.setPreferredSize(PosUIManager.getSize(30, 60));
        this.btnCollapsePlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FloorPlanView.this.btnCollapseMinus.setSelected(true);
                    FloorPlanView.this.leftCollapsiblePane.setCollapsed(true);
                    FloorPlanView.this.doCollapse(FloorPlanView.this.btnCollapsePlus, e);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        JPanel leftPanel = new JPanel(new BorderLayout());
        this.leftCollapsiblePane.add((Component)this.btnCollapsePlus, (Object)"North");
        leftPanel.add((Component)this.leftCollapsiblePane, "North");
        return leftPanel;
    }

    private void doShowMargeTicketDialog() {
        new MergeTicketsAction().actionPerformed(null);
        this.doRefresh();
    }

    private void doShowTransferTicketItemsDialog() {
        new TransferTicketItemsAction().actionPerformed(null);
        this.doRefresh();
    }

    private void createLeftBookingInfoPanel(JPanel mainPanel) {
        this.leftInnerCollapsiblePane = new JXCollapsiblePane(JXCollapsiblePane.Direction.LEFT);
        this.leftInnerCollapsiblePane.setCollapsed(true);
        this.btnAddBookingPanel = new JPanel(new BorderLayout(5, 5));
        this.btnAddBookingPanel.setVisible(true);
        JPanel leftInnerPanel = new JPanel(new BorderLayout());
        leftInnerPanel.setPreferredSize(PosUIManager.getSize(250, 0));
        leftInnerPanel.setBorder(new EmptyBorder(0, 2, 0, 0));
        String textAdd = Messages.getString("MapTableSelectionView.1");
        PosButton btnAddBooking = new PosButton(textAdd);
        btnAddBooking.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FloorPlanView.this.doBooking();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        this.btnCollapseMinus = new POSToggleButton("-");
        this.btnCollapseMinus.setPreferredSize(PosUIManager.getSize(50, 20));
        this.btnCollapseMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FloorPlanView.this.btnCollapsePlus.setSelected(false);
                    FloorPlanView.this.leftCollapsiblePane.setCollapsed(false);
                    FloorPlanView.this.doCollapse(FloorPlanView.this.btnCollapseMinus, e);
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
                }
            }
        });
        String textAll = Messages.getString("MapTableSelectionView.3");
        PosButton btnAllReservation = new PosButton(textAll);
        btnAllReservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FloorPlanView.this.showAllReservataion();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage());
                }
            }
        });
        this.btnAddBookingPanel.setPreferredSize(PosUIManager.getSize(0, 45));
        this.btnAddBookingPanel.add((Component)btnAddBooking, "West");
        this.btnAddBookingPanel.add(btnAllReservation);
        this.btnAddBookingPanel.add((Component)this.btnCollapseMinus, "East");
        this.btnAddBookingPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.leftBookingOrderPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.leftBookingOrderPanel.setVisible(true);
        JScrollPane scrollPane = new JScrollPane(this.leftBookingOrderPanel);
        scrollPane.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("MapTableSelectionView.5"), 2, 0));
        this.createCustomerBookingInfoPanel();
        leftInnerPanel.add((Component)this.btnAddBookingPanel, "North");
        leftInnerPanel.add((Component)scrollPane, "Center");
        this.leftInnerCollapsiblePane.add((Component)leftInnerPanel);
        mainPanel.add((Component)this.leftInnerCollapsiblePane, "West");
    }

    private void showAllReservataion() {
        AllReservationDialog allReservationDialog = new AllReservationDialog();
        allReservationDialog.open();
    }

    public void createCustomerBookingInfoPanel() {
        if (this.leftBookingOrderPanel == null) {
            return;
        }
        this.leftBookingOrderPanel.removeAll();
        List<BookingInfo> todaysBookingList = FloorplanDAO.getInstance().getTodaysBooking("open", null);
        String[] colorList = new String[]{"#e6ff33", "#acff33", "#f7dc6f ", "#85c1e9", "#fadbd8"};
        if (todaysBookingList != null) {
            int count = 0;
            for (BookingInfo bookingInfo : todaysBookingList) {
                FloorBookingView floorBookingView = new FloorBookingView(bookingInfo, this);
                if (count >= colorList.length) {
                    count = 0;
                }
                floorBookingView.setBackground(Color.decode(colorList[count].trim()));
                this.leftBookingOrderPanel.add((Component)floorBookingView, "growx,wrap");
                ++count;
            }
        }
        this.leftBookingOrderPanel.repaint();
        this.leftBookingOrderPanel.revalidate();
    }

    @Override
    public void rendererTables() {
        JPanel selectedComponent;
        UiRenderer selectedFloorView = this.floorTabPane.getSelectedFloorView();
        if (selectedFloorView instanceof FloorView) {
            selectedComponent = (FloorView)selectedFloorView;
            ((FloorView)selectedComponent).renderFloor();
        } else if (selectedFloorView instanceof BarTabSelectionView) {
            selectedComponent = (BarTabSelectionView)selectedFloorView;
            ((BarTabSelectionView)selectedComponent).updateView(this.orderType);
        } else {
            this.floorTabPane.selectFirstFloor();
        }
        OrderType orderType = this.getOrderType();
        if (orderType != null) {
            if (orderType.isEnableReorder().booleanValue()) {
                this.btnReorder.setVisible(true);
            } else {
                this.btnReorder.setVisible(false);
            }
        }
    }

    public void setVisibleBarTabBtn(boolean isVisible) {
        this.btnNewBarTab.setVisible(isVisible);
        this.btnGroup.setVisible(!isVisible);
        this.btnHoldFire.setVisible(!isVisible);
        this.btnGuestCheck.setVisible(isVisible && this.isHomeViewMode());
        this.btnSplitCheck.setVisible(!isVisible);
        this.btnSettle.setVisible(isVisible && this.isHomeViewMode());
        this.btnMargeTickets.setVisible(isVisible && this.isHomeViewMode());
        this.btnTransferTicketItems.setVisible(isVisible && this.isHomeViewMode());
        this.btnGroupSettle.setVisible(!isVisible);
        this.btnAuthorize.setVisible(!isVisible);
        this.btnRelease.setVisible(!isVisible);
        this.btnSwitchOptions.setVisible(!isVisible);
    }

    @Override
    public List<ShopTable> getSelectedTables() {
        UiRenderer selectedFloorView = this.floorTabPane.getSelectedFloorView();
        if (selectedFloorView != null && selectedFloorView instanceof FloorView) {
            return ((FloorView)selectedFloorView).getSelectedTables();
        }
        return new ArrayList<ShopTable>();
    }

    @Override
    public void setTicket(Ticket ticket) {
        this.currentTicket = ticket;
        super.setTicket(ticket);
    }

    @Override
    public void updateButtonsVisibility() {
        this.btnCloseDialog.setVisible(!this.isHomeViewMode());
        boolean bartabMode = this.floorTabPane.isBartabMode();
        if (bartabMode) {
            this.setVisibleBarTabBtn(true);
            return;
        }
        this.btnCloseDialog.setVisible(!this.isHomeViewMode());
        if (!this.isHomeViewMode()) {
            boolean transferMode = Boolean.TRUE;
            this.btnGroup.setVisible(transferMode);
            this.btnDone.setVisible(!transferMode);
            this.btnSwitchOptions.setVisible(false);
            this.btnCancel.setVisible(!transferMode);
            this.btnTimeLog.setVisible(!transferMode);
            this.btnStatus.setVisible(!transferMode);
            this.btnRearrange.setVisible(!transferMode);
            this.btnHoldFire.setVisible(!transferMode);
            this.btnGuestCheck.setVisible(!transferMode);
            this.btnSplitCheck.setVisible(!transferMode);
            this.btnSettle.setVisible(!transferMode);
            this.btnGroupSettle.setVisible(!transferMode);
            this.btnRelease.setVisible(!transferMode);
            this.btnAuthorize.setVisible(!transferMode);
            this.btnMargeTickets.setVisible(!transferMode);
            this.btnTransferTicketItems.setVisible(!transferMode);
            this.btnNewBarTab.setVisible(!transferMode);
            this.btnRefresh.setVisible(!transferMode);
        }
    }

    public static FloorPlanView getInstance() {
        if (null == instance) {
            instance = new FloorPlanView();
        }
        return instance;
    }

    @Override
    public void dataAdded(Object object) {
    }

    @Override
    public void dataChanged(Object object) {
    }

    @Override
    public void dataRemoved(Object object) {
    }

    @Override
    public Object getSelectedData() {
        return null;
    }

    @Override
    public void dataSetUpdated() {
    }

    @Override
    public void dataChangeCanceled(Object object) {
    }

    private void doCollapse(JToggleButton btnCollapse, ActionEvent e) {
        JToggleButton button = (JToggleButton)e.getSource();
        boolean collapsed = button.isSelected();
        this.leftInnerCollapsiblePane.setCollapsed(!collapsed);
    }

    private void doBooking() {
        TableBookingForm bookingForm = new TableBookingForm(new BookingInfo());
        BeanEditorDialog dialog = new BeanEditorDialog(bookingForm);
        dialog.open();
        if (!dialog.isCanceled()) {
            this.createCustomerBookingInfoPanel();
        }
    }

    @Override
    public void refresh() {
        this.doRefresh();
    }

    public Ticket getCurrentTicket() {
        return this.currentTicket;
    }

    @Override
    public void clearSelection() {
        this.btnGroups.clearSelection();
        if (!this.isTicketTransferMode()) {
            this.btnGroup.setVisible(true);
            this.btnDone.setVisible(false);
            this.btnCancel.setVisible(false);
            this.showOptions(this.isOptions);
        }
    }

    private void showOptions(boolean show) {
        boolean bartabMode = this.floorTabPane.isBartabMode();
        try {
            if (!this.isHomeViewMode()) {
                return;
            }
            if (!show) {
                this.btnSwitchOptions.setText(Messages.getString("TableLayoutView.29"));
            }
            this.btnTmFirstOpened.setVisible(show);
            this.btnTmBillPrint.setVisible(show);
            this.btnTimeLog.setVisible(show);
            this.btnStatus.setVisible(show);
            this.btnRearrange.setVisible(show);
            this.btnGroup.setVisible(!show);
            this.btnHoldFire.setVisible(!show);
            this.btnGuestCheck.setVisible(!show);
            this.btnSplitCheck.setVisible(!show);
            this.btnSettle.setVisible(!show);
            this.btnGroupSettle.setVisible(!show);
            this.btnRelease.setVisible(!show);
            this.btnAuthorize.setVisible(!show);
            this.btnRefresh.setVisible(!show);
            this.btnMargeTickets.setVisible(!show);
            this.btnTransferTicketItems.setVisible(!show);
            this.btnSwitchOptions.setVisible(false);
        }
        finally {
            if (bartabMode) {
                this.setVisibleBarTabBtn(true);
            } else {
                this.btnNewBarTab.setVisible(false);
            }
        }
    }

    public boolean shouldGroup() {
        return this.btnGroup.isSelected();
    }

    public boolean shouldHoldFire() {
        return this.btnHoldFire.isSelected();
    }

    @Override
    public boolean shouldGuestCheck() {
        return this.btnGuestCheck.isSelected();
    }

    public boolean shouldSplitCheck() {
        return this.btnSplitCheck.isSelected();
    }

    @Override
    public boolean shouldSettle() {
        return this.btnSettle.isSelected();
    }

    @Override
    public boolean shouldReorder() {
        return super.shouldReorder() || this.btnReorder.isSelected();
    }

    public boolean shouldRelease() {
        return this.btnRelease.isSelected();
    }

    public boolean isSeat() {
        return this.seat;
    }

    public void setSeat(boolean seat) {
        this.seat = seat;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        FloorView selectedFloorView = (FloorView)this.floorTabPane.getSelectedFloorView();
        if (object == this.btnGroup) {
            this.showHomeScreenActionButtons(false);
            if (this.isCreateNewTicket()) {
                selectedFloorView.addedTableListModel.clear();
            }
            this.btnDone.setVisible(true);
            this.btnCancel.setVisible(true);
        } else if (object == this.btnDone) {
            if (this.btnGroup.isSelected() && selectedFloorView.doGroupAction()) {
                this.showHomeScreenActionButtons(true);
                if (this.isCreateNewTicket()) {
                    selectedFloorView.clearSelection();
                }
                this.clearSelection();
                this.setTicketTransferMode(false);
            }
        } else if (object == this.btnCancel) {
            if (this.isHomeViewMode()) {
                this.showHomeScreenActionButtons(true);
                this.clearSelection();
            } else {
                this.btnDone.setVisible(Boolean.FALSE);
                this.btnCancel.setVisible(Boolean.FALSE);
            }
            selectedFloorView.clearSelection();
            selectedFloorView.renderFloor();
            this.setTicket(this.getCurrentTicket());
            if (this.isCreateNewTicket()) {
                this.rendererTables();
            }
        }
    }

    private void showHomeScreenActionButtons(boolean isVisible) {
        if (!this.isHomeViewMode()) {
            this.updateButtonsVisibility();
        } else {
            this.btnTimeLog.setVisible(isVisible);
            this.btnStatus.setVisible(isVisible);
            this.btnRearrange.setVisible(isVisible);
            this.btnHoldFire.setVisible(isVisible);
            this.btnGuestCheck.setVisible(isVisible);
            this.btnSplitCheck.setVisible(isVisible);
            this.btnSettle.setVisible(isVisible);
            this.btnGroupSettle.setVisible(isVisible);
            this.btnRelease.setVisible(isVisible);
            this.btnAuthorize.setVisible(isVisible);
            this.btnRefresh.setVisible(isVisible);
            this.btnMargeTickets.setVisible(isVisible);
            this.btnTransferTicketItems.setVisible(isVisible);
            this.btnSwitchOptions.setVisible(isVisible);
        }
    }

    @Override
    public void setOrderType(OrderType orderType) {
        super.setOrderType(orderType);
        this.floorTabPane.setOrderType(orderType);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        String command = new String(message.getPayload());
        if ("1".equals(command) || "2".equals(command)) {
            this.btnRefresh.setBlinking(true);
        }
    }

    private void subscribeToNotificationService() {
        try {
            OroMqttClient.getInstance().subscribeToStore("MQTT-COMMAND", 0, (IMqttMessageListener)this);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public void cacheRefreshed() {
        if (!this.isShowing()) {
            return;
        }
        this.mainPanel.remove(this.floorTabPane);
        MultiFloorTabPane floorPane = this.crateFloorPane();
        floorPane.setOrderType(this.orderType);
        this.mainPanel.add(floorPane);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
        this.floorTabPane.selectFirstFloor();
    }
}

