/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.dao.ShopFloorDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class FloorSelectionDialog
extends POSDialog {
    private ScrollableFlowPanel buttonsPanel;
    private ShopFloor selectedFloor;

    public FloorSelectionDialog() {
        this.initializeComponent();
        this.initializeData();
        this.setResizable(true);
    }

    private void initializeComponent() {
        this.setTitle("Select Floor");
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Select Floor");
        this.add((Component)titlePanel, "North");
        JPanel buttonActionPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        PosButton btnCancel = new PosButton(POSConstants.CANCEL.toUpperCase());
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FloorSelectionDialog.this.selectedFloor = null;
                FloorSelectionDialog.this.setCanceled(true);
                FloorSelectionDialog.this.dispose();
            }
        });
        buttonActionPanel.add((Component)btnCancel, "grow, span");
        JPanel footerPanel = new JPanel(new BorderLayout());
        footerPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        footerPanel.add((Component)new JSeparator(), "North");
        footerPanel.add(buttonActionPanel);
        this.add((Component)footerPanel, "South");
        this.buttonsPanel = new ScrollableFlowPanel(3);
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(80, 0));
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), scrollPane.getBorder()));
        this.add((Component)scrollPane, "Center");
        this.setSize(550, 450);
    }

    private void initializeData() {
        try {
            List<ShopFloor> shopFloors = ShopFloorDAO.getInstance().findAll();
            ButtonGroup group = new ButtonGroup();
            for (ShopFloor shopFloor : shopFloors) {
                ShopFloorButton shopFloorButton = new ShopFloorButton(shopFloor);
                this.buttonsPanel.add(shopFloorButton);
                group.add(shopFloorButton);
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    protected void doFinish() {
        if (this.selectedFloor == null) {
            POSMessageDialog.showMessage("Please select one floor");
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public ShopFloor getSelectedFloor() {
        return this.selectedFloor;
    }

    private class ShopFloorButton
    extends POSToggleButton
    implements ActionListener {
        private static final int BUTTON_SIZE = 120;
        ShopFloor shopFloor;

        ShopFloorButton(ShopFloor shopFloor) {
            this.shopFloor = shopFloor;
            this.setFont(this.getFont().deriveFont(18.0f));
            this.setText(shopFloor.getName());
            this.setPreferredSize(new Dimension(120, 120));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FloorSelectionDialog.this.selectedFloor = this.shopFloor;
            FloorSelectionDialog.this.doFinish();
        }
    }
}

