/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.Command;
import com.floreantpos.bo.ui.ModelBrowser;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.BookingBeanEditor;
import com.floreantpos.ui.SearchPanel;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;

public class ReservationModelBrowser<E>
extends ModelBrowser {
    private BookingBeanEditor beanEditor;
    private JButton btnSeat = new JButton(Messages.getString("ReservationModelBrowser.0"));
    private JButton btnNoAppear = new JButton(Messages.getString("ReservationModelBrowser.1"));
    private JButton btnDelay = new JButton(Messages.getString("ReservationModelBrowser.2"));
    private JButton btnBookingCancel = new JButton(Messages.getString("ReservationModelBrowser.3"));
    private JButton btnBookingClose = new JButton(Messages.getString("ReservationModelBrowser.4"));
    private int selectedRow;

    public ReservationModelBrowser(BookingBeanEditor<E> beanEditor, SearchPanel<E> searchPanel) {
        super(beanEditor, searchPanel);
        this.beanEditor = beanEditor;
        this.btnSeat.setEnabled(false);
        this.btnNoAppear.setEnabled(false);
        this.btnDelay.setEnabled(false);
        this.btnBookingCancel.setEnabled(false);
        this.btnBookingClose.setEnabled(false);
    }

    @Override
    public void init(TableModel tableModel) {
        super.init(tableModel);
        this.buttonPanel.add(this.btnSeat);
        this.buttonPanel.add(this.btnDelay);
        this.buttonPanel.add(this.btnNoAppear);
        this.buttonPanel.add(this.btnBookingCancel);
        this.buttonPanel.add(this.btnBookingClose);
        this.btnSeat.addActionListener(this);
        this.btnDelay.addActionListener(this);
        this.btnNoAppear.addActionListener(this);
        this.btnBookingCancel.addActionListener(this);
        this.btnBookingClose.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command command = Command.fromString(e.getActionCommand());
        try {
            this.selectedRow = this.browserTable.getSelectedRow();
            switch (command) {
                case NEW: {
                    this.beanEditor.setBean(null);
                    this.beanEditor.createNew();
                    this.beanEditor.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    this.browserTable.clearSelection();
                    this.setBookingStatus(false);
                    break;
                }
                case EDIT: {
                    this.beanEditor.edit();
                    this.beanEditor.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    this.setBookingStatus(false);
                    break;
                }
                case CANCEL: {
                    this.doCancelEditing();
                    break;
                }
                case SAVE: {
                    if (!this.beanEditor.save()) break;
                    this.beanEditor.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.setBookingStatus(false);
                    this.refreshTable();
                    this.refreshTableBookingSearchPanel();
                    this.customSelectedRow();
                    break;
                }
                case DELETE: {
                    if (!this.beanEditor.delete()) break;
                    this.beanEditor.setBean(null);
                    this.beanEditor.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.setBookingStatus(false);
                    this.refreshTableBookingSearchPanel();
                    this.refreshTable();
                    break;
                }
            }
            this.handleAdditionaButtonActionIfApplicable(e);
            if (e.getSource() == this.btnSeat) {
                this.beanEditor.bookingStatus("seat");
                this.customSelectedRow();
            } else if (e.getSource() == this.btnBookingCancel) {
                this.beanEditor.bookingStatus("cancel");
                this.customSelectedRow();
            } else if (e.getSource() == this.btnDelay) {
                this.beanEditor.bookingStatus("delay");
                this.customSelectedRow();
            } else if (e.getSource() == this.btnNoAppear) {
                this.beanEditor.bookingStatus("no appear");
                this.customSelectedRow();
            } else if (e.getSource() == this.btnBookingClose) {
                this.beanEditor.bookingStatus("close");
                this.customSelectedRow();
                if (this.browserTable.getRowCount() == 0) {
                    this.beanEditor.clearFields();
                    this.setBookingStatus(false);
                    this.btnDelete.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                }
            }
            BookingInfo bookingInfo = (BookingInfo)this.beanEditor.getBean();
            if (bookingInfo != null) {
                this.setButtonStatus(bookingInfo.getStatus());
            }
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (this.browserTable.getSelectedRow() != -1) {
            this.setBookingStatus(true);
            int index = this.browserTable.getSelectedRow();
            BookingInfo bookingInfo = (BookingInfo)((BeanTableModel)this.browserTable.getModel()).getRow(index);
            this.setButtonStatus(bookingInfo.getStatus());
        }
    }

    @Override
    public void doCancelEditing() {
        super.doCancelEditing();
        if (this.browserTable.getSelectedRow() != -1) {
            this.setBookingStatus(true);
            return;
        }
        this.setBookingStatus(false);
    }

    private void refreshTableBookingSearchPanel() {
        this.getSearchPanel().refreshSearchPanel();
    }

    private void customSelectedRow() {
        if (this.selectedRow == -1) {
            return;
        }
        if (this.browserTable.getRowCount() == 0) {
            return;
        }
        if (this.selectedRow >= this.browserTable.getRowCount()) {
            this.browserTable.setRowSelectionInterval(this.selectedRow - 1, this.selectedRow - 1);
        } else {
            this.browserTable.setRowSelectionInterval(this.selectedRow, this.selectedRow);
        }
    }

    @Override
    public void refreshButtonPanel() {
        super.refreshButtonPanel();
        this.btnSeat.setEnabled(false);
        this.btnNoAppear.setEnabled(false);
        this.btnDelay.setEnabled(false);
        this.btnBookingCancel.setEnabled(false);
        this.btnBookingClose.setEnabled(false);
    }

    private void setBookingStatus(boolean enable) {
        this.btnSeat.setEnabled(enable);
        this.btnBookingCancel.setEnabled(enable);
        this.btnDelay.setEnabled(enable);
        this.btnNoAppear.setEnabled(enable);
        this.btnBookingClose.setEnabled(enable);
    }

    public void setButtonStatus(String bookingStatus) {
        if (StringUtils.isEmpty((String)bookingStatus)) {
            return;
        }
        switch (bookingStatus) {
            case "seat": {
                this.btnSeat.setEnabled(false);
                this.btnBookingCancel.setEnabled(false);
                this.btnDelay.setEnabled(false);
                this.btnNoAppear.setEnabled(false);
                this.btnBookingClose.setEnabled(true);
                this.btnDelete.setEnabled(false);
                this.btnCancel.setEnabled(true);
                break;
            }
        }
    }
}

