/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.floorplan.ui;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.floorplan.Messages;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.ShopTableButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class TableStatusDialog
extends POSDialog {
    private JRadioButton rbFree;
    private JRadioButton rbBooked;
    private JRadioButton rbDirty;
    private JRadioButton rbServing;
    private JRadioButton rbDisable;
    private ShopTable table;
    private ShopTableButton shopTableButton;

    public TableStatusDialog() {
        this.createUI();
    }

    public TableStatusDialog(ShopTable table, ShopTableButton button) {
        this.table = table;
        this.shopTableButton = button;
        this.createUI();
        this.updateView();
    }

    private void updateView() {
        if (this.table != null) {
            this.rbFree.setSelected(true);
            this.rbServing.setSelected(this.table.getTableStatus().equals((Object)TableStatus.Serving));
            this.rbBooked.setSelected(this.table.getTableStatus().equals((Object)TableStatus.Booked));
            this.rbDirty.setSelected(this.table.getTableStatus().equals((Object)TableStatus.Dirty));
            this.rbDisable.setSelected(this.table.getTableStatus().equals((Object)TableStatus.Disable));
        }
    }

    private void createUI() {
        this.setTitle(Messages.getString("TableStatusDialog.0"));
        this.rbFree = new JRadioButton(Messages.getString("TableStatusDialog.1"));
        this.rbBooked = new JRadioButton(Messages.getString("TableStatusDialog.2"));
        this.rbDirty = new JRadioButton(Messages.getString("TableStatusDialog.3"));
        this.rbServing = new JRadioButton(Messages.getString("TableStatusDialog.4"));
        this.rbDisable = new JRadioButton(Messages.getString("TableStatusDialog.5"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbFree);
        buttonGroup.add(this.rbBooked);
        buttonGroup.add(this.rbDirty);
        buttonGroup.add(this.rbServing);
        buttonGroup.add(this.rbDisable);
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new FlowLayout(1, 5, 5));
        statusPanel.add(this.rbFree);
        statusPanel.add(this.rbBooked);
        statusPanel.add(this.rbDirty);
        statusPanel.add(this.rbServing);
        statusPanel.add(this.rbDisable);
        this.add(statusPanel);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("TableStatusDialog.6"));
        panel.add(titlePanel);
        this.add((Component)panel, "North");
        JPanel footerPanel = new JPanel(new BorderLayout());
        footerPanel.add((Component)new JSeparator(), "North");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        footerPanel.add(buttonPanel);
        this.getContentPane().add((Component)footerPanel, "South");
        PosButton btnOk = new PosButton();
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableStatusDialog.this.rbFree.isSelected()) {
                    TableStatusDialog.this.table.setTableStatus(TableStatus.Available);
                } else if (TableStatusDialog.this.rbServing.isSelected()) {
                    TableStatusDialog.this.table.setTableStatus(TableStatus.Serving);
                } else if (TableStatusDialog.this.rbBooked.isSelected()) {
                    TableStatusDialog.this.table.setTableStatus(TableStatus.Booked);
                } else if (TableStatusDialog.this.rbDirty.isSelected()) {
                    TableStatusDialog.this.table.setTableStatus(TableStatus.Dirty);
                } else if (TableStatusDialog.this.rbDisable.isSelected()) {
                    TableStatusDialog.this.table.setTableStatus(TableStatus.Disable);
                }
                if (TableStatusDialog.this.table != null) {
                    ShopTableDAO.getInstance().saveOrUpdate(TableStatusDialog.this.table);
                    TableStatusDialog.this.dispose();
                    TableStatusDialog.this.shopTableButton.update();
                }
            }
        });
        btnOk.setText(Messages.getString("TableStatusDialog.8"));
        btnOk.setPreferredSize(new Dimension(70, TerminalConfig.getTouchScreenButtonHeight()));
        buttonPanel.add((Component)btnOk, "split 2,align center");
        PosButton btnCancel = new PosButton();
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableStatusDialog.this.dispose();
            }
        });
        btnCancel.setText(Messages.getString("TableStatusDialog.10"));
        buttonPanel.add(btnCancel);
    }
}

