/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main.update;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.AbstractFloreantPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.main.update.UpdateNotificationDialog;
import com.floreantpos.main.update.UpdateNotificationHandler;
import com.floreantpos.main.update.UpdatePendingDialog;
import com.floreantpos.main.update.UpdatePluginNotificationHandler;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.update.Information;
import com.floreantpos.update.Modes;
import com.floreantpos.update.UpdateListener;
import com.floreantpos.update.UpdateService;
import com.floreantpos.update.UpdateXMLParser;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class UpdateManager {
    public static final String SOFTWARE_NUMERIC_VERSION = "software.numeric.version";
    public static final String HAS_UPDATE = "has_update";
    public static final String HAS_PLUGIN_UPDATE = "has_plugin_update";
    public static final String FORCE_UPDATE = "force_update";
    private JFrame parentWindow;

    public JFrame getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(JFrame parentWindow) {
        this.parentWindow = parentWindow;
    }

    public boolean checkForUpdate() throws Exception {
        String updateServerURL = Application.getInstance().getUpdateServerURL();
        String appName = VersionInfo.getAppName();
        String version = VersionInfo.getVersion();
        int numericVersion = VersionInfo.getNumericVersion();
        return UpdateService.checkForUpdate((Component)this.parentWindow, (UpdateListener)new UpdateNotificationHandler(false), (String)updateServerURL, (String)appName, (String)version, (int)numericVersion);
    }

    public void checkForPluginUpdate(String updateServerURL, String pluginName, String version, int numericVersion) throws Exception {
        UpdateService.checkForUpdate((Component)this.parentWindow, (UpdateListener)new UpdatePluginNotificationHandler(false, pluginName, numericVersion), (String)updateServerURL, (String)pluginName, (String)version, (int)numericVersion);
    }

    public boolean isUpdateAvailable() {
        String updateServerURL = Application.getInstance().getUpdateServerURL();
        String appName = VersionInfo.getAppName();
        String version = VersionInfo.getVersion();
        int numericVersion = VersionInfo.getNumericVersion();
        return this.isUpdateAvailable(updateServerURL, appName, version, numericVersion);
    }

    public boolean isUpdateAvailable(String updateServerURL, String appName, String version, int numericVersion) {
        return UpdateService.isUpdateAvailable((Component)this.parentWindow, (UpdateListener)new UpdateNotificationHandler(false), (String)updateServerURL, (String)appName, (String)version, (int)numericVersion);
    }

    public boolean checkHasRemainingUpdates() {
        if (AppConfig.getBoolean(HAS_UPDATE, false)) {
            this.updateSoftware();
            return true;
        }
        return false;
    }

    private void updateSoftware() {
        try {
            Information updateXmlFileInfo = UpdateManager.getUpdateXmlFileInfo();
            if (!AppConfig.getBoolean(FORCE_UPDATE, false)) {
                try {
                    OroMqttClient mqttClient = OroMqttClient.getInstance();
                    mqttClient.initMqttClient(Application.getInstance().getMqttDeviceId());
                    this.sendUpdateNotification(updateXmlFileInfo, Action.MESSAGE.name(), Messages.getString("UpdateManager.5"), Messages.getString("UpdateManager.6"), false, "");
                    PosLog.debug(this.getClass(), "mqtt client started");
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), e);
                }
                UpdatePendingDialog dialog = new UpdatePendingDialog();
                dialog.open();
            }
            this.runUpdateProcess(updateXmlFileInfo);
            AppConfig.removeProperty(HAS_UPDATE);
            System.exit(0);
        }
        catch (Exception e) {
            AppConfig.removeProperty(HAS_UPDATE);
            POSMessageDialog.showError(null, Messages.getString("UpdateManager.9") + e.getMessage(), e);
            System.exit(1);
        }
    }

    private void updatePlugin() {
        try {
            String pluginName = AppConfig.getString("updated_plugin_name");
            Information updateXmlFileInfo = UpdateManager.getUpdateXmlFileInfo(pluginName);
            if (!AppConfig.getBoolean(FORCE_UPDATE, false)) {
                OroMqttClient mqttClient = OroMqttClient.getInstance();
                mqttClient.initMqttClient(Application.getInstance().getMqttDeviceId());
                this.sendUpdateNotification(updateXmlFileInfo, Action.MESSAGE.name(), Messages.getString("UpdateManager.12"), Messages.getString("UpdateManager.6"), true, updateXmlFileInfo.getAppName());
                PosLog.debug(this.getClass(), "mqtt client started");
                UpdatePendingDialog dialog = new UpdatePendingDialog();
                dialog.open();
            }
            this.runUpdateProcess(updateXmlFileInfo, pluginName.trim().toLowerCase(), true);
            AppConfig.removeProperty(HAS_PLUGIN_UPDATE);
            System.exit(0);
        }
        catch (Exception e) {
            AppConfig.removeProperty(HAS_PLUGIN_UPDATE);
            POSMessageDialog.showError(null, Messages.getString("UpdateManager.15") + e.getMessage(), e);
            System.exit(1);
        }
    }

    private void sendUpdateNotification(Information updateXmlFileInfo, String action, String content, String msg, boolean plugin, String pluginName) throws Exception {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("action", (Object)action);
            jsonObject.put("content", (Object)content);
            jsonObject.put("msg", (Object)msg);
            jsonObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            if (plugin) {
                jsonObject.put("plugin", plugin);
                jsonObject.put("pluginName", (Object)pluginName);
                jsonObject.put("pluginNumericVersion", updateXmlFileInfo.getPkgrel());
            } else {
                jsonObject.put("terminalAppNumericVersion", updateXmlFileInfo.getPkgrel());
            }
            OroMqttClient.getInstance().publishData("auto-update-service", jsonObject.toString());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private static Information getUpdateXmlFileInfo() throws Exception {
        return UpdateManager.getUpdateXmlFileInfo(UpdateManager.getAppName());
    }

    private static Information getUpdateXmlFileInfo(String updatedFolderName) throws Exception {
        String updateXmlFilePath = System.getProperty("java.io.tmpdir") + "/" + updatedFolderName.toLowerCase() + "/" + "update.xml";
        Information information = UpdateXMLParser.parse((String)updateXmlFilePath, (Modes)Modes.FILE);
        if (information != null) {
            return information;
        }
        throw new Exception(Messages.getString("UpdateManager.28"));
    }

    private void runUpdateProcess(Information updateXmlFileInfo) throws Exception {
        this.runUpdateProcess(updateXmlFileInfo, VersionInfo.getAppName(), false);
    }

    private void runUpdateProcess(Information updateXmlFileInfo, String appName, boolean plugin) throws Exception {
        if (!plugin) {
            UpdateManager.extractLatestUpdater(updateXmlFileInfo);
        }
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        File currentJar = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        String decodedParentPath = URLDecoder.decode(currentJar.getPath(), "UTF-8");
        String decodedUpdaterPath = decodedParentPath.replace(currentJar.getName(), "auto-updater.jar");
        ProcessBuilder pb = new ProcessBuilder(javaBin, "-cp", decodedUpdaterPath, "com.floreantpos.update.UpdateServiceWindow", decodedParentPath, appName, VersionInfo.getAppName());
        pb.start();
    }

    private static void extractLatestUpdater(Information updateXmlFileInfo) throws Exception {
        String fileName = updateXmlFileInfo.getFilename();
        if (fileName.toLowerCase().contains("http") && fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        String sourceZipFile = System.getProperty("java.io.tmpdir") + "/" + UpdateManager.getAppName().toLowerCase() + "/" + fileName;
        PosLog.info(UpdateManager.class, Messages.getString("UpdateManager.37") + sourceZipFile);
        ZipFile zipFile = new ZipFile(sourceZipFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("lib") || !name.contains("auto-updater")) continue;
            try (InputStream in = zipFile.getInputStream(entry);){
                String decodedParentPath;
                File currentJar = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                if (!currentJar.isFile()) {
                    return;
                }
                currentJar = currentJar.getParentFile();
                String outputFolder = decodedParentPath = URLDecoder.decode(currentJar.getPath(), "UTF-8");
                PosLog.info(UpdateManager.class, "decode parent path: " + decodedParentPath);
                PosLog.info(UpdateManager.class, "auto updater destination: " + outputFolder);
                File entryDestination = new File(outputFolder, "auto-updater.jar");
                try (FileOutputStream out = new FileOutputStream(entryDestination);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                PosLog.info(UpdateManager.class, Messages.getString("UpdateManager.44"));
                break;
            }
        }
        zipFile.close();
    }

    private static String getAppName() {
        return VersionInfo.getAppName().replaceAll("\\W+", "_").toLowerCase();
    }

    public void publishIfNewUpdateAvailable() throws Exception {
        int lastAppVersion = AppConfig.getInt("last_app_version", VersionInfo.getNumericVersion());
        if (VersionInfo.getNumericVersion() > lastAppVersion) {
            this.publishSoftwareUpdated();
        }
    }

    private void publishSoftwareUpdated() throws Exception {
        Information updateXmlFileInfo = UpdateManager.getUpdateXmlFileInfo();
        Store store = StoreDAO.getRestaurant();
        Integer softwareNumericVersion = store.getSoftwareNumericVersion();
        if (softwareNumericVersion == null || softwareNumericVersion < VersionInfo.getNumericVersion()) {
            store.setSoftwareVersion(VersionInfo.getVersion());
            store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
            StoreDAO.getInstance().update(store);
            DataProvider.get().refreshStore();
        }
        this.sendUpdateNotification(updateXmlFileInfo, Action.UPDATE.name(), Messages.getString("UpdateManager.50"), "", false, "");
        AppConfig.removeProperty(HAS_UPDATE);
        AppConfig.removeProperty(FORCE_UPDATE);
        AppConfig.removeProperty("last_app_version");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                POSMessageDialog.showMessage(UpdateManager.this.parentWindow, Messages.getString("UpdateManager.54") + VersionInfo.getVersion());
            }
        });
    }

    private void startDownloadingUpdate() {
        String appName = UpdateManager.getAppName();
        PosWindow posWindow = Application.getPosWindow();
        String updateServerURL = Application.getInstance().getUpdateServerURL();
        UpdateService.startDownload((Component)posWindow, (UpdateListener)new UpdateNotificationHandler(), (String)updateServerURL, (String)appName);
    }

    public void subscribeToUpdateService() throws Exception {
        OroMqttClient.getInstance().subscribeToStore("auto-update-service", 0, new IMqttMessageListener(){

            public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
                try {
                    int updatedVersion;
                    int updatedPluginVersion;
                    String pluginName;
                    PosLog.debug(this.getClass(), "Update message received");
                    String data = new String(mqttMessage.getPayload());
                    JSONObject jsonObject = new JSONObject(data);
                    String terminalKey = jsonObject.getString("terminalKey");
                    PosLog.debug(this.getClass(), "Update notification from terminal " + terminalKey);
                    if (terminalKey.equals(TerminalUtil.getSystemUID())) {
                        return;
                    }
                    boolean plugin = jsonObject.has("plugin") ? jsonObject.getBoolean("plugin") : false;
                    String string = pluginName = jsonObject.has("pluginName") ? jsonObject.getString("pluginName") : null;
                    if (plugin && jsonObject.has("pluginNumericVersion") ? UpdateManager.this.pluginUpToDate(pluginName, updatedPluginVersion = jsonObject.getInt("pluginNumericVersion")) : jsonObject.has("terminalAppNumericVersion") && (updatedVersion = jsonObject.getInt("terminalAppNumericVersion")) <= VersionInfo.getNumericVersion()) {
                        return;
                    }
                    Object object = jsonObject.get("content");
                    Object message = jsonObject.get("msg");
                    Toolkit.getDefaultToolkit().beep();
                    Action action = Action.valueOf(jsonObject.getString("action"));
                    switch (action) {
                        case MESSAGE: {
                            PosLog.debug(this.getClass(), "going to show that software will be updated");
                            UpdateNotificationDialog.showMessage((String)object.toString(), (String)message.toString(), (boolean)false);
                            break;
                        }
                        case UPDATE: {
                            if (!plugin && String.valueOf(VersionInfo.getNumericVersion()).equals(StoreDAO.getRestaurant().getSoftwareVersion())) {
                                return;
                            }
                            UpdateNotificationDialog notificationDialog = UpdateNotificationDialog.getInstance((String)object.toString(), (String)message.toString(), (boolean)true, (boolean)plugin, (String)pluginName);
                            notificationDialog.setUpdateButtonVisible(false);
                            notificationDialog.startUpdating();
                        }
                    }
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), e);
                }
            }
        });
    }

    private boolean pluginUpToDate(String pluginName, int updatedPluginVersion) {
        List plugins = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : plugins) {
            int currentPluginVersion;
            if (!(floreantPlugin instanceof AbstractFloreantPlugin)) continue;
            AbstractFloreantPlugin abstractFloreantPlugin = (AbstractFloreantPlugin)floreantPlugin;
            String currentPluginName = abstractFloreantPlugin.getProductName();
            if (pluginName == null || currentPluginName == null || !pluginName.equalsIgnoreCase(currentPluginName) || updatedPluginVersion > (currentPluginVersion = abstractFloreantPlugin.getProductNumericVersion().intValue())) continue;
            return true;
        }
        return false;
    }

    private void checkVersionCompatibility(Integer databaseVersionInDb, String softwareVersionInDb, Integer softwareNumericVersionInDb) {
        try {
            boolean oldVersion;
            Integer thisVersion = VersionInfo.getNumericVersion();
            Integer thisDatabaseVersion = 231;
            boolean bl = oldVersion = softwareNumericVersionInDb != null && softwareNumericVersionInDb > thisVersion;
            if (oldVersion || databaseVersionInDb != null && databaseVersionInDb > thisDatabaseVersion) {
                String message = Messages.getString("UpdateManager.78") + Messages.getString("UpdateManager.79");
                message = String.format(message, softwareVersionInDb);
                String option = null;
                option = TerminalConfig.isShowDbConfigureButton() ? POSMessageDialog.showOptionDialog(Application.getPosWindow(), message, Messages.getString("UpdateManager.80"), Messages.getString("UpdateManager.81"), Messages.getString("UpdateManager.82"), Messages.getString("UpdateManager.83")) : POSMessageDialog.showOptionDialog(Application.getPosWindow(), message, Messages.getString("UpdateManager.84"), Messages.getString("UpdateManager.85"), Messages.getString("UpdateManager.86"));
                if (option == null || option.equals("No")) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("UpdateManager.63"));
                    System.exit(1);
                } else if (option.equals("Yes")) {
                    this.startDownloadingUpdate();
                } else {
                    DatabaseConfigurationDialog dialog = DatabaseConfigurationDialog.show(Application.getPosWindow());
                    if (dialog.isCanceled()) {
                        POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("UpdateManager.90"));
                        System.exit(1);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void performDatabaseUpgrade() throws Exception {
        String hibernateDialect;
        boolean databaseUpdated;
        Database database = AppConfig.getDefaultDatabase();
        String connectString = AppConfig.getConnectString();
        String databaseUser = AppConfig.getDatabaseUser();
        String databasePassword = AppConfig.getDatabasePassword();
        String hibernateConnectionDriverClass = database.getHibernateConnectionDriverClass();
        Map<String, String> storeProperties = DatabaseUtil.getStoreProperties(connectString, hibernateConnectionDriverClass, databaseUser, databasePassword);
        String softwareVersion = storeProperties.get("software.version");
        Integer databaseVersion = null;
        Integer softwareNumericVersion = null;
        try {
            databaseVersion = Integer.parseInt(storeProperties.get("database.version"));
            softwareNumericVersion = Integer.parseInt(storeProperties.get(SOFTWARE_NUMERIC_VERSION));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.checkVersionCompatibility(databaseVersion, softwareVersion, softwareNumericVersion);
        if (!DatabaseUtil.isDbUpdateNeeded(databaseVersion)) {
            return;
        }
        String message = Messages.getString("DB_UPGRADE_REQUIRED");
        String title = Messages.getString("ALERT");
        int option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), message, title);
        if (option != 0) {
            return;
        }
        message = Messages.getString("DB_UPGRADE_ALERT_MESSAGE");
        option = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), message, title);
        if (option != 0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SHUTDOWN_MESSAGE"));
            System.exit(1);
        }
        if (databaseUpdated = DatabaseUtil.updateDatabase(connectString, hibernateDialect = database.getHibernateDialect(), hibernateConnectionDriverClass, databaseUser, databasePassword)) {
            POSMessageDialog.showMessage(Messages.getString("DB_UPGRADE_SUCCESS"));
            ProcessUtil.restart();
        } else {
            POSMessageDialog.showMessage(Messages.getString("DatabaseConfigurationDialog.3"));
        }
    }

    static enum Action {
        MESSAGE,
        UPDATE;

    }
}

