/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.base.BaseComboItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItem"})
public class ComboItem
extends BaseComboItem
implements PropertyContainer {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private MenuItem menuItem;

    public ComboItem() {
    }

    public ComboItem(String id) {
        super(id);
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String itemId = this.getMenuItemId();
            if (StringUtils.isEmpty((String)itemId)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        if (menuItem != null) {
            this.setItemId(menuItem.getId());
            this.setName(menuItem.getDisplayName());
            this.setPrice(menuItem.getPrice());
        }
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }
}

