/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseImageResource;
import com.floreantpos.swing.PosUIManager;
import java.awt.Image;
import java.beans.Transient;
import java.sql.Blob;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"asIcon", "image", "scaledImage", "buttonImage", "buttonBigImage", "imageIcon", "imageData"})
public class ImageResource
extends BaseImageResource
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public ImageResource() {
    }

    public ImageResource(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @Override
    @Transient
    @Deprecated
    public Blob getImageData() {
        return super.getImageData();
    }

    @Override
    @Deprecated
    public void setImageData(Blob imageData) {
        super.setImageData(imageData);
    }

    public IMAGE_CATEGORY getImageCategory() {
        return IMAGE_CATEGORY.fromInt(super.getImageCategoryNum());
    }

    public void setImageCategory(IMAGE_CATEGORY imageCategory) {
        super.setImageCategoryNum(imageCategory.getType());
    }

    public ImageIcon getScaledImage(int w, int h) {
        byte[] imageData = this.getImageBytes();
        if (imageData == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(imageData);
        Image scaledImage = imageIcon.getImage().getScaledInstance(w, h, 4);
        return new ImageIcon(scaledImage);
    }

    public ImageIcon getButtonImage() {
        byte[] imageData = this.getImageBytes();
        if (imageData == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(imageData);
        return ImageResource.getScaledImageIcon(imageIcon, 40);
    }

    public static ImageIcon getScaledImageIcon(ImageIcon imageIcon, int size) {
        int iconHeight = imageIcon.getIconHeight();
        int iconWidth = imageIcon.getIconWidth();
        if (iconWidth > iconHeight) {
            int width = size;
            int height = iconHeight * width / iconWidth;
            Image scaledImage = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), 4);
            return new ImageIcon(scaledImage);
        }
        int height = size;
        int width = iconWidth * height / iconHeight;
        Image scaledImage = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), 4);
        return new ImageIcon(scaledImage);
    }

    public ImageIcon getButtonImage(int w, int h) {
        byte[] imageData = this.getImageBytes();
        if (imageData == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(imageData);
        int iconHeight = imageIcon.getIconHeight();
        int iconWidth = imageIcon.getIconWidth();
        if (iconWidth > iconHeight) {
            int width = w;
            int height = iconHeight * width / iconWidth;
            Image scaledImage = imageIcon.getImage().getScaledInstance(width, height, 4);
            return new ImageIcon(scaledImage);
        }
        int height = h;
        int width = iconWidth * height / iconHeight;
        Image scaledImage = imageIcon.getImage().getScaledInstance(width, height, 4);
        return new ImageIcon(scaledImage);
    }

    public ImageIcon getButtonBigImage() {
        byte[] imageData = this.getImageBytes();
        if (imageData == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(imageData);
        int iconHeight = imageIcon.getIconHeight();
        int iconWidth = imageIcon.getIconWidth();
        if (iconWidth > iconHeight) {
            int width = 200;
            int height = iconHeight * width / iconWidth;
            Image scaledImage = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), 4);
            return new ImageIcon(scaledImage);
        }
        int height = 200;
        int width = iconWidth * height / iconHeight;
        Image scaledImage = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), 4);
        return new ImageIcon(scaledImage);
    }

    @XmlTransient
    public Image getImage() {
        byte[] imageData = this.getImageBytes();
        if (imageData == null) {
            return null;
        }
        return new ImageIcon(imageData).getImage();
    }

    public ImageIcon getImageIcon() {
        byte[] imageData = this.getImageBytes();
        if (imageData == null) {
            return null;
        }
        return new ImageIcon(imageData);
    }

    @XmlTransient
    public ImageIcon getAsIcon() {
        byte[] imageData = this.getImageBytes();
        if (imageData == null) {
            return null;
        }
        return this.getButtonImage();
    }

    public static enum IMAGE_CATEGORY {
        UNLISTED(0),
        FLOORPLAN(1),
        PRODUCTS(2),
        PEOPLE(3),
        DELETED(4);

        private int type;

        private IMAGE_CATEGORY(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public static IMAGE_CATEGORY fromInt(int type) {
            IMAGE_CATEGORY[] values;
            for (IMAGE_CATEGORY cat : values = IMAGE_CATEGORY.values()) {
                if (cat.type != type) continue;
                return cat;
            }
            return UNLISTED;
        }
    }
}

