/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseInventoryStock;
import com.floreantpos.model.util.DataProvider;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"conversionValue", "unit", "menuItem", "inventoryLocation"})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InventoryStock
extends BaseInventoryStock
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private double menuItemCost;
    private String locationName;
    private InventoryLocation inventoryLocation;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public InventoryStock() {
    }

    public InventoryStock(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public void setUnitName(String name) {
    }

    public String getUnitName() {
        IUnit unitByCode = DataProvider.get().getUnitByCode(this.getUnit());
        if (unitByCode != null) {
            return unitByCode.getName();
        }
        return null;
    }

    @Override
    public String getSku() {
        String skuDisplay = super.getSku();
        return StringUtils.isNotEmpty((String)skuDisplay) ? skuDisplay : "";
    }

    public void setMenuItem(MenuItem menuItem) {
        if (menuItem == null) {
            return;
        }
        this.setMenuItemId(menuItem.getId());
        this.setItemName(menuItem.getName());
        this.setSku(menuItem.getSku());
    }

    public InventoryLocation getInventoryLocation() {
        String locationId = this.getLocationId();
        if (locationId == null) {
            return null;
        }
        if (this.inventoryLocation != null && this.inventoryLocation.getId().equals(locationId)) {
            return this.inventoryLocation;
        }
        return DataProvider.get().getInventoryLocationById(locationId);
    }

    public void setInventoryLocation(InventoryLocation inventoryLocation) {
        this.inventoryLocation = inventoryLocation;
    }

    public double getMenuItemCost() {
        return this.menuItemCost;
    }

    public void setMenuItemCost(double menuItemCost) {
        this.menuItemCost = menuItemCost;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    @JsonIgnore
    @XmlTransient
    public MenuItem getMenuItem() {
        if (StringUtils.isEmpty((String)this.getMenuItemId())) {
            return null;
        }
        return (MenuItem)DataProvider.get().getObjectOf(MenuItem.class, (Serializable)((Object)this.getMenuItemId()));
    }
}

