/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.PosLog;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.base.BaseOrderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.Image;
import java.sql.Blob;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

public class OrderType
extends BaseOrderType {
    private static final long serialVersionUID = 1L;
    public static final String BAR_TAB = "BAR_TAB";
    public static final String JSON_PROP_TABLE_SELECTION_FREE_TEXT_INPUT_PROMPT = "tableSelection.freeTextInput.prompt";
    public static final String JSON_PROP_TABLE_SELECTION_FREE_TEXT_INPUT = "tableSelection.freeTextInput";
    private ImageIcon image;
    private transient JsonObject propertiesContainer;

    public OrderType() {
    }

    public TaxGroup getDefaultTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getDefaultTaxGroupId());
    }

    public void setDefaultTaxGroup(TaxGroup defaultTaxGroup) {
        this.setDefaultTaxGroupId(defaultTaxGroup == null ? null : defaultTaxGroup.getId());
    }

    public TaxGroup getForHereTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getForHereTaxGroupId());
    }

    public void setForHereTaxGroup(TaxGroup forHereTaxGroup) {
        this.setForHereTaxGroupId(forHereTaxGroup == null ? null : forHereTaxGroup.getId());
    }

    public TaxGroup getToGoTaxGroup() {
        return DataProvider.get().getTaxGroupById(this.getToGoTaxGroupId());
    }

    public void setToGoTaxGroup(TaxGroup toGoTaxGroup) {
        this.setToGoTaxGroupId(toGoTaxGroup == null ? null : toGoTaxGroup.getId());
    }

    @XmlTransient
    public Color getTextColor() {
        if (this.getTextColorCode() == null) {
            return null;
        }
        return new Color(this.getTextColorCode());
    }

    public void setTextColor(Color textColor) {
        if (textColor != null) {
            this.setTextColorCode(textColor.getRGB());
        }
    }

    @XmlTransient
    public Color getButtonColor() {
        Integer buttonColorCode = this.getButtonColorCode();
        if (buttonColorCode == null) {
            return null;
        }
        if (buttonColorCode == -1316371) {
            return null;
        }
        return new Color(this.getButtonColorCode());
    }

    public OrderType(String id) {
        super(id);
    }

    public String name() {
        return super.getName();
    }

    public OrderType valueOf() {
        return this;
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (StringUtils.isNotBlank((String)name)) {
            return name.replaceAll("_", " ");
        }
        return name;
    }

    public ImageIcon getImage() {
        return this.image;
    }

    public Image getStoredImage() {
        ImageIcon tempImageIcon = this.getImage();
        if (tempImageIcon == null) {
            return null;
        }
        Image tempImage = tempImageIcon.getImage();
        return tempImage;
    }

    @Override
    public void setImageData(Blob imageData) {
        super.setImageData(imageData);
        if (imageData != null) {
            try {
                int blobLength = (int)imageData.length();
                this.image = new ImageIcon(imageData.getBytes(1L, blobLength));
            }
            catch (SQLException e) {
                PosLog.error(this.getClass(), e);
            }
        }
    }

    public ImageIcon getScaledImage(int width, int height) {
        Image scaledInstance = null;
        if (this.image != null) {
            scaledInstance = this.image.getImage().getScaledInstance(width, height, 4);
            return new ImageIcon(scaledInstance);
        }
        return null;
    }

    public String getUniqueId() {
        return ("order_type_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public SalesArea getSalesArea() {
        if (StringUtils.isNotEmpty((String)this.getSalesAreaId())) {
            return DataProvider.get().getSalesArea(this.getSalesAreaId());
        }
        return null;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }

    public void addProperty(String key, String value) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(key, value);
    }

    public String getProperty(String key) {
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key)) {
            return this.propertiesContainer.get(key).getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }

    public boolean isTokenInputEnable() {
        return false;
    }
}

