/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.Department;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidTransaction;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@XmlSeeAlso(value={CashTransaction.class, CustomPaymentTransaction.class, GiftCertificateTransaction.class, CreditCardTransaction.class, DebitCardTransaction.class, CashDropTransaction.class, RefundTransaction.class, PayOutTransaction.class, VoidTransaction.class, CustomerAccountTransaction.class, ReversalTransaction.class})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"ticketItems", "terminal", "properties", "cashDrawer"})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="classType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CashTransaction.class), @JsonSubTypes.Type(value=CustomPaymentTransaction.class), @JsonSubTypes.Type(value=GiftCertificateTransaction.class), @JsonSubTypes.Type(value=CreditCardTransaction.class), @JsonSubTypes.Type(value=DebitCardTransaction.class), @JsonSubTypes.Type(value=CashDropTransaction.class), @JsonSubTypes.Type(value=RefundTransaction.class), @JsonSubTypes.Type(value=PayOutTransaction.class), @JsonSubTypes.Type(value=VoidTransaction.class), @JsonSubTypes.Type(value=CustomerAccountTransaction.class), @JsonSubTypes.Type(value=ReversalTransaction.class)})
public class PosTransaction
extends BasePosTransaction {
    public static final String JSON_PROP_GIFT_CARD_GIFT_CARD_BALANCE_ADD_INFO = "gift_card_balance_add_info";
    public static final String JSON_PROP_GIFT_CARD_ADDED_AMOUNT = "addedAmount";
    public static final String JSON_PROP_GIFT_CARD_GIFT_CARD_NO = "giftCardNo";
    public static final String JSON_PROP_GIFT_CARD_TICKET_ITEM_ID = "ticketItemId";
    private static final long serialVersionUID = 1L;
    private transient boolean refunded = false;
    private transient boolean syncEdited;
    private CashDrawer cashDrawer;
    private transient JsonObject propertiesContainer;
    private String cardTrack;
    private String cardNo;
    private String cardExpYear;
    private String cardExpMonth;
    private String cardCVV;
    public static final String CASH = "CASH";
    public static final String GIFT_CERT = "GIFT_CERT";
    public static final String CREDIT_CARD = "CREDIT_CARD";
    public static final String DEBIT_CARD = "DEBIT_CARD";
    public static final String CASH_DROP = "CASH_DROP";
    public static final String REFUND = "REFUND";
    public static final String PAY_OUT = "PAY_OUT";
    public static final String VOID_TRANS = "VOID_TRANS";
    public static final String GIFT_CARD_BALANCE_ADD = "GIFT_CARD_BALANCE_ADD";
    public static final String PROP_CASH_BACK_POSTFIX = "_CASH_BACK";
    public static final String PROP_TENDERED_POSTFIX = "_TENDERED";
    private static final String JSON_PROP_GIFT_CARD_NUMBER = "gift_card_number";
    private static final String JSON_PROP_GIFT_CARD_BALANCE_AMOUNT = "gift_card_balance_amount";
    private transient String ticketId;
    private String classType;
    public static final String TRANSACTION_FEE = "transactionFee";

    public PosTransaction() {
    }

    public PosTransaction(String id) {
        super(id);
    }

    public PosTransaction(String id, String transactionType, String paymentTypeString) {
        super(id, transactionType, paymentTypeString);
    }

    @Override
    public String getTransactionType() {
        String type = super.getTransactionType();
        if (StringUtils.isEmpty((String)type)) {
            return TransactionType.CREDIT.name();
        }
        return type;
    }

    public void updateTerminalBalance() {
        Terminal terminal = this.getTerminal();
        if (terminal == null) {
            return;
        }
        Double amount = this.getAmount();
        if (amount == null || amount == 0.0) {
            return;
        }
    }

    public boolean isCard() {
        return this instanceof CreditCardTransaction || this instanceof DebitCardTransaction;
    }

    public void addProperty(String name, String value) {
        this.addExtraProperty(name, value);
    }

    public boolean hasProperty(String key) {
        return this.getExtraProperty(key) != null;
    }

    public String getProperty(String key) {
        return this.getExtraProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.getExtraProperties() == null) {
            return defaultValue;
        }
        String string = this.getExtraProperty(key);
        if (StringUtils.isEmpty((String)string)) {
            return defaultValue;
        }
        return string;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getExtraProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }

    public Double calculateTotalAmount() {
        return this.getAmount() + this.getTipsAmount();
    }

    public Double calculateAuthorizeAmount() {
        double advanceTipsPercentage = CardConfig.getAdvanceTipsPercentage();
        return this.getTenderAmount() + this.getTenderAmount() * (advanceTipsPercentage / 100.0);
    }

    @XmlTransient
    public String getCardTrack() {
        return this.cardTrack;
    }

    public void setCardTrack(String cardTrack) {
        this.cardTrack = cardTrack;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public String getCardExpYear() {
        return this.cardExpYear;
    }

    public void setCardExpYear(String expYear) {
        this.cardExpYear = expYear;
    }

    public String getCardExpMonth() {
        return this.cardExpMonth;
    }

    public void setCardExpMonth(String expMonth) {
        this.cardExpMonth = expMonth;
    }

    public String getCardCVV() {
        return this.cardCVV;
    }

    public void setCardCVV(String cardCVV) {
        this.cardCVV = cardCVV;
    }

    public String getGlobalId() {
        return super.getId();
    }

    public String getTicketId() {
        if (StringUtils.isNotEmpty((String)this.ticketId)) {
            return this.ticketId;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return "";
        }
        return ticket.getId();
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public void calculateTaxAmount() {
        if (this.getAmount() <= 0.0) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getTotalAmount() <= 0.0 || this.isVoided().booleanValue() || this instanceof RefundTransaction) {
            return;
        }
        this.setTaxAmount(NumberUtil.roundToTwoDigit((this.getAmountWithTolerance() - this.getTipsAmount()) * ticket.getTaxAmount() / ticket.getTotalAmount()));
    }

    public void calculateServiceChargeAmount() {
        if (this.getAmount() <= 0.0) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getServiceCharge() <= 0.0 || this.isVoided().booleanValue() || this instanceof RefundTransaction) {
            return;
        }
        this.setServiceChargeAmount(NumberUtil.roundToTwoDigit((this.getAmountWithTolerance() - this.getTipsAmount()) * ticket.getServiceCharge() / ticket.getTotalAmount()));
    }

    public boolean isRefunded() {
        return this.refunded;
    }

    public void setRefunded(boolean refunded) {
        this.refunded = refunded;
    }

    @XmlTransient
    public Department getDepartment() {
        return DataProvider.get().getDepartmentById(this.getDepartmentId());
    }

    public void setDepartment(Department department) {
        String departmentId = null;
        if (department != null) {
            departmentId = department.getId();
        }
        super.setDepartmentId(departmentId);
    }

    @XmlTransient
    public Terminal getTerminal() {
        return DataProvider.get().getTerminalById(this.getTerminalId());
    }

    public void setTerminal(Terminal terminal) {
        Integer terminalId = null;
        if (terminal != null) {
            terminalId = terminal.getId();
        }
        super.setTerminalId(terminalId);
    }

    @XmlTransient
    public User getUser() {
        return DataProvider.get().getUserById(this.getUserId());
    }

    public void setUser(User user) {
        String userId = null;
        if (user != null) {
            userId = user.getId();
        }
        super.setUserId(userId);
    }

    public void setServer(User server) {
        if (server == null) {
            this.setServerId(null);
        } else {
            this.setServerId(server.getId());
        }
    }

    public void setCashDrawer(CashDrawer cashDrawer) {
        this.cashDrawer = cashDrawer;
        if (cashDrawer != null) {
            super.setCashDrawerId(cashDrawer.getId());
        }
    }

    @XmlTransient
    public CashDrawer getCashDrawer() {
        if (this.cashDrawer != null) {
            return this.cashDrawer;
        }
        return CashDrawerDAO.getInstance().get(this.getCashDrawerId());
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean syncEdited) {
        this.syncEdited = syncEdited;
    }

    public void setPaymentType(PaymentType paymentType) {
        if (paymentType != null) {
            this.setPaymentTypeString(paymentType.name());
        } else {
            this.setPaymentTypeString(null);
        }
    }

    @XmlTransient
    public PaymentType getPaymentType() {
        String paymentTypeString = super.getPaymentTypeString();
        if (paymentTypeString == null) {
            return null;
        }
        try {
            return PaymentType.valueOf(paymentTypeString);
        }
        catch (Exception e) {
            return PaymentType.fromDisplayString(paymentTypeString);
        }
    }

    public double getAmountWithTolerance() {
        return super.getAmount() - super.getToleranceAmount();
    }

    public void addReturnTicketItemIds(List<TicketItem> ticketItems) {
        if (!ticketItems.isEmpty()) {
            JsonArray itemArray = new JsonArray();
            for (TicketItem ticketItem : ticketItems) {
                if (!ticketItem.isReturned() || ticketItem.isPaid()) continue;
                JsonObject itemObj = new JsonObject();
                itemObj.addProperty("ticket_item_id", ticketItem.getId());
                itemArray.add((JsonElement)itemObj);
            }
            if (this.propertiesContainer == null) {
                this.propertiesContainer = new JsonObject();
            }
            this.propertiesContainer.add("REFUNDED_TICKET_ITEM", (JsonElement)itemArray);
        }
    }

    @XmlTransient
    public List<String> getReturnTicketItemIds() {
        ArrayList<String> ticketItems = new ArrayList<String>();
        if (this.propertiesContainer == null) {
            return ticketItems;
        }
        JsonArray orderTypesArray = this.propertiesContainer.getAsJsonArray("REFUNDED_TICKET_ITEM");
        if (orderTypesArray == null || orderTypesArray.isJsonNull()) {
            return ticketItems;
        }
        for (JsonElement jsonElement : orderTypesArray) {
            JsonElement id;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null || (id = jsonObject.get("ticket_item_id")) == null) continue;
            ticketItems.add(id.getAsString());
        }
        return ticketItems;
    }

    @Override
    public String getExtraProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getExtraProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setExtraProperties(String properties) {
        super.setExtraProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }

    public void addExtraProperty(String key, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(key, value);
    }

    public String getExtraProperty(String key) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    @XmlTransient
    public Map<String, String> getProperties() {
        return super.getProperties();
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    public void addGiftCardBalanceAddInfo(String ticketItemId, String giftCardNo, double addedAmount) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_PROP_GIFT_CARD_TICKET_ITEM_ID, (Object)ticketItemId);
        jsonObject.put(JSON_PROP_GIFT_CARD_GIFT_CARD_NO, (Object)giftCardNo);
        jsonObject.put(JSON_PROP_GIFT_CARD_ADDED_AMOUNT, addedAmount);
        String giftCardInfo = this.getGiftCardBalanceAddInfo();
        if (StringUtils.isBlank((String)giftCardInfo)) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)jsonObject);
            this.addProperty(JSON_PROP_GIFT_CARD_GIFT_CARD_BALANCE_ADD_INFO, jsonArray.toString());
        } else {
            JSONArray jsonArray = new JSONArray(giftCardInfo);
            jsonArray.put((Object)jsonObject);
            this.addProperty(JSON_PROP_GIFT_CARD_GIFT_CARD_BALANCE_ADD_INFO, jsonArray.toString());
        }
    }

    public String getGiftCardBalanceAddInfo() {
        return this.getProperty(JSON_PROP_GIFT_CARD_GIFT_CARD_BALANCE_ADD_INFO);
    }
}

