/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.floreantpos.Messages;
import com.floreantpos.model.VirtualPrinter;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class Printer
implements Serializable {
    private VirtualPrinter virtualPrinter;
    private String deviceName;
    private String printSystem;
    private String printerType;
    private String ipAddress;
    private String ipPort;
    private String serialPort;
    private Integer textLength;
    private boolean defaultPrinter;
    private String type;

    public Printer() {
    }

    public Printer(VirtualPrinter virtualPrinter, String deviceName) {
        this.virtualPrinter = virtualPrinter;
        this.deviceName = deviceName;
    }

    public Printer(VirtualPrinter virtualPrinter, String deviceName, boolean defaultPrinter) {
        this.virtualPrinter = virtualPrinter;
        this.deviceName = deviceName;
        this.defaultPrinter = defaultPrinter;
    }

    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter;
    }

    public void setVirtualPrinter(VirtualPrinter virtualPrinter) {
        this.virtualPrinter = virtualPrinter;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public boolean isDefaultPrinter() {
        return this.defaultPrinter;
    }

    public void setDefaultPrinter(boolean defaultPrinter) {
        this.defaultPrinter = defaultPrinter;
    }

    public int hashCode() {
        if (this.virtualPrinter == null) {
            return super.hashCode();
        }
        return this.virtualPrinter.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Printer)) {
            return false;
        }
        Printer that = (Printer)obj;
        return this.virtualPrinter.equals(that.virtualPrinter);
    }

    public String toString() {
        return this.virtualPrinter.toString();
    }

    public String getDisplayName() {
        String diviceName = null;
        diviceName = this.getDeviceName() != null ? this.getDeviceName() : Messages.getString("Printer.0");
        return this.virtualPrinter.toString() + " -    " + diviceName;
    }

    public String getType() {
        this.type = VirtualPrinter.PRINTER_TYPE_NAMES[this.virtualPrinter.getType()];
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPrintSystem() {
        if (StringUtils.isEmpty((String)this.printSystem)) {
            return "Standard";
        }
        return this.printSystem;
    }

    public void setPrintSystem(String printSystem) {
        this.printSystem = printSystem;
    }

    public String getPrinterType() {
        return this.printerType;
    }

    public void setPrinterType(String printerType) {
        this.printerType = printerType;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpPort() {
        return this.ipPort;
    }

    public void setIpPort(String ipPort) {
        this.ipPort = ipPort;
    }

    public String getSerialPort() {
        return this.serialPort;
    }

    public void setSerialPort(String serialPort) {
        this.serialPort = serialPort;
    }

    public Integer getTextLength() {
        return this.textLength;
    }

    public void setTextLength(Integer textLength) {
        this.textLength = textLength;
    }
}

