/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BasePurchaseOrder;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"statusDisplay", "orderStatusDisplay"})
public class PurchaseOrder
extends BasePurchaseOrder
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final int ORDER_PENDING = 0;
    public static final int ORDER_VERIFIED = 1;
    public static final int ORDER_FULLY_INVOICED = 2;
    public static final int ORDER_PARTIALLY_INVOICED = 3;
    public static final int ORDER_FULLY_RECEIVED = 4;
    public static final int ORDER_PARTIALLY_RECEIVED = 5;
    public static final int ORDER_PARTIALLY_RECEIVED_AND_INVOICED = 6;
    public static final int ORDER_CLOSED = 7;
    public static final int ORDER_CANCELLED = 8;
    public static final String[] ORDER_STATUS = new String[]{Messages.getString("PurchaseOrder.0"), Messages.getString("PurchaseOrder.1"), Messages.getString("PurchaseOrder.2"), Messages.getString("PurchaseOrder.3"), Messages.getString("PurchaseOrder.4"), Messages.getString("PurchaseOrder.5"), Messages.getString("PurchaseOrder.6"), Messages.getString("PurchaseOrder.7"), Messages.getString("PurchaseOrder.8")};
    public static final String PO_VERIFIED_BY = Messages.getString("PurchaseOrder.9");
    public static final String PO_SENT_BY = Messages.getString("PurchaseOrder.10");
    public static final String PO_RECEIVED_BY = Messages.getString("PurchaseOrder.11");
    public static final String PO_INVOICED_BY = Messages.getString("PurchaseOrder.12");
    public static final String PO_CLOSED_BY = Messages.getString("PurchaseOrder.13");
    public String orderStatusDisplay;
    public static final String DEBIT = Messages.getString("PurchaseOrder.14");
    public static final String CREDIT = Messages.getString("PurchaseOrder.15");
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    public String statusDisplay;

    public PurchaseOrder() {
    }

    public PurchaseOrder(String id) {
        super(id);
    }

    @XmlTransient
    public String getOrderStatusDisplay() {
        return ORDER_STATUS[this.getStatus()];
    }

    public void setOrderStatusDisplay(String orderStatusDisplay) {
        this.orderStatusDisplay = ORDER_STATUS[this.getStatus()];
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @Override
    public List<PurchaseOrderItem> getOrderItems() {
        List<PurchaseOrderItem> items = super.getOrderItems();
        if (items == null) {
            items = new ArrayList<PurchaseOrderItem>();
            super.setOrderItems(items);
        }
        return items;
    }

    public void calculatePrice() {
        List<PurchaseOrderItem> items = this.getOrderItems();
        if (items == null) {
            return;
        }
        double subtotalAmount = 0.0;
        double discountAmount = 0.0;
        double taxAmount = 0.0;
        for (PurchaseOrderItem item : items) {
            item.calculatePrice();
            subtotalAmount += item.getSubtotalAmount().doubleValue();
            discountAmount += item.getDiscountAmount().doubleValue();
            taxAmount += item.getTaxAmount().doubleValue();
        }
        this.setSubtotalAmount(subtotalAmount);
        this.setDiscountAmount(discountAmount);
        this.setTaxAmount(taxAmount);
        double totalAmount = subtotalAmount - discountAmount + taxAmount;
        totalAmount = this.fixInvalidAmount(totalAmount);
        this.setTotalAmount(NumberUtil.roundToTwoDigit(totalAmount));
        double dueAmount = totalAmount - this.getPaidAmount();
        this.setDueAmount(NumberUtil.roundToTwoDigit(dueAmount));
    }

    private double fixInvalidAmount(double tax) {
        if (tax < 0.0 || Double.isNaN(tax)) {
            tax = 0.0;
        }
        return tax;
    }

    public void addProperty(String name, String value) {
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, String>());
        }
        this.getProperties().put(name, value);
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public String getProperty(String key) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.getProperties() == null) {
            return null;
        }
        String string = this.getProperties().get(key);
        if (StringUtils.isEmpty((String)string)) {
            return defaultValue;
        }
        return string;
    }

    public void removeProperty(String propertyName) {
        Map<String, String> properties = this.getProperties();
        if (properties == null) {
            return;
        }
        properties.remove(propertyName);
    }

    @XmlTransient
    public String getStatusDisplay() {
        int status = this.getStatus();
        if (status == 0) {
            return Messages.getString("PurchaseOrder.16");
        }
        if (status == 1 || status == 5) {
            return Messages.getString("PurchaseOrder.17");
        }
        return "";
    }

    public void setStatusDisplay(String statusDisplay) {
        this.statusDisplay = statusDisplay;
    }
}

