/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.floreantpos.model.DataSync;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.EmployeeShift;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.MiscShift;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.ReservationShift;
import com.floreantpos.model.StoreHour;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShift;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@JsonIgnoreProperties(ignoreUnknown=true, value={"dayOfWeekAsString"})
@XmlSeeAlso(value={PriceShift.class, DayPart.class, StoreHour.class, EmployeeShift.class, DataSync.class, MiscShift.class, MenuShift.class, ReservationShift.class})
@XmlRootElement(name="shift")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="classType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PriceShift.class), @JsonSubTypes.Type(value=DayPart.class), @JsonSubTypes.Type(value=StoreHour.class), @JsonSubTypes.Type(value=EmployeeShift.class), @JsonSubTypes.Type(value=DataSync.class), @JsonSubTypes.Type(value=MiscShift.class), @JsonSubTypes.Type(value=MenuShift.class), @JsonSubTypes.Type(value=ReservationShift.class)})
public class Shift
extends BaseShift
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private Date startTime;
    private Date endTime;
    private String classType;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public Shift() {
    }

    public Shift(String id) {
        super(id);
    }

    public Shift(String id, String name) {
        super(id, name);
    }

    @Override
    public Long getShiftLength() {
        Long shiftLength2 = super.getShiftLength();
        if (shiftLength2 == null) {
            return Math.abs(this.getStartTime().getTime() - this.getEndTime().getTime());
        }
        return shiftLength2;
    }

    public Date getStartTime() {
        if (this.startTime == null) {
            Calendar c = Calendar.getInstance();
            c.clear();
            c.set(11, super.getStartHour());
            c.set(12, super.getStartMin());
            this.startTime = c.getTime();
        }
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
        if (startTime != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(startTime);
            super.setStartHour(c.get(11));
            super.setStartMin(c.get(12));
        }
    }

    public Date getEndTime() {
        if (this.endTime == null) {
            Calendar c = Calendar.getInstance();
            c.clear();
            c.set(11, super.getEndHour());
            c.set(12, super.getEndMin());
            this.endTime = c.getTime();
        }
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        if (endTime != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(endTime);
            super.setEndHour(c.get(11));
            super.setEndMin(c.get(12));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Shift)) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((Shift)obj).getName());
    }

    public String getClassType() {
        if (this.classType == null) {
            this.classType = this.getClass().getSimpleName();
            return this.classType;
        }
        return this.classType;
    }

    public void setClassType(String classType) {
        this.classType = classType;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

