/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopFloor;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"foregroundColor", "backgroundColor", "floorSize", "image", "orderTypes"})
public class ShopFloor
extends BaseShopFloor
implements TimedModel,
PropertyContainer {
    public static final String JSON_PROP_ID = "id";
    public static final String JSON_PROP_ORDER_TYPES = "orderTypes";
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;

    public ShopFloor() {
    }

    public ShopFloor(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean hasTableWithNumber(String number) {
        Set<ShopTable> tables = this.getTables();
        if (tables == null) {
            return false;
        }
        for (ShopTable shopTable : tables) {
            if (!shopTable.getTableNumber().equals(number)) continue;
            return true;
        }
        return false;
    }

    @XmlTransient
    public Color getForegroundColor() {
        if (this.getForegroundColorCode() == null) {
            return null;
        }
        return new Color(this.getForegroundColorCode());
    }

    public void setForegroundColor(Color foregroundColor) {
        if (foregroundColor != null) {
            this.setForegroundColorCode(foregroundColor.getRGB());
        }
    }

    @XmlTransient
    public Color getBackgroundColor() {
        if (this.getBackgroundColorCode() == null) {
            return null;
        }
        return new Color(this.getBackgroundColorCode());
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.setBackgroundColorCode(backgroundColor.getRGB());
        }
    }

    @XmlTransient
    public Dimension getFloorSize() {
        Integer height = this.getHeight();
        Integer width = this.getWidth();
        if (width <= 0) {
            width = 850;
        }
        if (height <= 0) {
            height = 500;
        }
        return new Dimension(width, height);
    }

    public void setOrderTypes(List<OrderType> orderTypes) {
        if (orderTypes == null || orderTypes.isEmpty()) {
            if (this.propertiesContainer != null) {
                this.propertiesContainer.remove(JSON_PROP_ORDER_TYPES);
            }
            return;
        }
        if (this.propertiesContainer == null) {
            this.propertiesContainer = this.getPropertyStore();
        }
        JsonArray orderTypesArray = new JsonArray();
        for (OrderType orderType : orderTypes) {
            JsonObject orderTypeObject = new JsonObject();
            orderTypeObject.addProperty(OrderType.PROP_ID, orderType.getId());
            orderTypesArray.add((JsonElement)orderTypeObject);
        }
        this.propertiesContainer.add(JSON_PROP_ORDER_TYPES, (JsonElement)orderTypesArray);
    }

    @XmlTransient
    public List<OrderType> getOrderTypes() {
        ArrayList<OrderType> orderTypes = new ArrayList<OrderType>();
        if (this.propertiesContainer == null) {
            return orderTypes;
        }
        JsonArray orderTypesArray = this.propertiesContainer.getAsJsonArray(JSON_PROP_ORDER_TYPES);
        if (orderTypesArray == null || orderTypesArray.isJsonNull()) {
            return orderTypes;
        }
        for (JsonElement jsonElement : orderTypesArray) {
            OrderType orderType;
            JsonElement id;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null || (id = jsonObject.get(JSON_PROP_ID)) == null || (orderType = DataProvider.get().getOrderType(id.getAsString())) == null) continue;
            orderTypes.add(orderType);
        }
        return orderTypes;
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }
}

