/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Store;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"enable"})
@XmlRootElement
public class Tax
extends BaseTax
implements TimedModel,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    private Boolean enable;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    public Tax() {
    }

    public Tax(String id) {
        super(id);
    }

    public Tax(String id, String name) {
        super(id, name);
    }

    public Tax(String id, String name, double rate) {
        super(id, name);
        this.setRate(rate);
    }

    public String getUniqueId() {
        return ("tax_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    @Override
    public String toString() {
        return this.getName() + " (" + NumberUtil.formatAmount(this.getRate()) + "%)";
    }

    public Boolean isEnable() {
        return this.enable == null ? false : this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setSfName(String sfName) {
        this.addProperty("sfName", sfName);
    }

    public String getSfName() {
        return this.getProperty("sfName");
    }

    public static BigDecimal applyFloridaTaxRule(BigDecimal subtotal, BigDecimal totalTaxAmount) {
        BigDecimal roundedTax = NumberUtil.round(totalTaxAmount);
        Store store = DataProvider.get().getStore();
        if (store.isEnableFloridaTaxRule()) {
            int intValueOfSubtotal = subtotal.multiply(new BigDecimal(100)).intValue();
            if (roundedTax.compareTo(totalTaxAmount) == 1 && ((intValueOfSubtotal %= 100) == 8 || intValueOfSubtotal == 9)) {
                roundedTax = NumberUtil.round(NumberUtil.round(totalTaxAmount).subtract(new BigDecimal(0.01)));
            } else if (intValueOfSubtotal > 9 && roundedTax.compareTo(totalTaxAmount) == -1) {
                roundedTax = NumberUtil.round(roundedTax.add(new BigDecimal(0.01)));
            }
        }
        return roundedTax;
    }

    @Override
    public String getProperty(String key) {
        JsonElement jsonElement;
        this.initPropertyContainer();
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    public JsonObject getPropertyStore() {
        this.initPropertyContainer();
        return this.propertiesContainer;
    }

    private void initPropertyContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
    }

    @Override
    public void addProperty(String key, String value) {
        this.initPropertyContainer();
        this.propertiesContainer.addProperty(key, value);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public void removeProperty(String propertyName) {
        this.initPropertyContainer();
        this.propertiesContainer.remove(propertyName);
        super.setProperties(this.propertiesContainer.toString());
    }
}

