/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"image", "status", "parentUser", "linkedUser", "linkedUsersIfExists", "currentCashDrawer", "activeDrawerPullReport", "type", "currentShift", "manager", "administrator"})
@XmlRootElement(name="user")
public class User
extends BaseUser
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private String typeName;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    public static final String USER_TYPE_MANAGER = Messages.getString("User.0");
    public static final String USER_TYPE_CASHIER = Messages.getString("User.1");
    public static final String USER_TYPE_SERVER = Messages.getString("User.2");
    public static final String JSON_PROP_ID = "id";
    public static final String JSON_PROP_USER_ORDER_TYPE = "user_order_type";
    private CashDrawer currentCashDrawer;

    public User() {
    }

    public User(String id) {
        super(id);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
        this.updateSyncTime = shouldUpdateSyncTime;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
        this.updateLastUpdateTime = shouldUpdateUpdateTime;
    }

    @XmlTransient
    public UserType getType() {
        String userTypeId2 = this.getUserTypeId();
        if (userTypeId2 != null) {
            return DataProvider.get().getUserType(userTypeId2);
        }
        return null;
    }

    public void setType(UserType userType) {
        if (userType != null) {
            super.setUserTypeId(userType.getId());
        } else {
            super.setUserTypeId(null);
        }
    }

    @XmlTransient
    public Shift getCurrentShift() {
        return DataProvider.get().getShiftById(this.getCurrentShiftId());
    }

    public void setCurrentShift(Shift shift) {
        if (shift != null) {
            super.setCurrentShiftId(shift.getId());
        } else {
            super.setCurrentShiftId(null);
        }
    }

    @Override
    public Boolean isActive() {
        return super.isActive() == null ? Boolean.TRUE : super.isActive();
    }

    public boolean hasPermission(UserPermission permission) {
        if (this.getType() == null) {
            return false;
        }
        return this.getType().hasPermission(permission);
    }

    public boolean hasPermissionInAnyRole(UserPermission permission) {
        User userRoleWithPermission = this.getUserRoleWithPermission(permission);
        return userRoleWithPermission != null;
    }

    public User getUserRoleWithPermission(UserPermission permission) {
        if (this.getType() != null && this.getType().hasPermission(permission)) {
            return this;
        }
        ArrayList<User> users = new ArrayList<User>();
        if (this.isRoot().booleanValue()) {
            users.add(this);
            List<User> linkedUser = this.getLinkedUser();
            if (linkedUser != null) {
                users.addAll(linkedUser);
            }
        } else {
            User pUser = this.getParentUser();
            if (pUser != null) {
                users.add(pUser);
                List<User> linkedUser = pUser.getLinkedUser();
                if (linkedUser != null) {
                    users.addAll(linkedUser);
                }
            } else {
                users.add(this);
            }
        }
        for (User user : users) {
            if (user.getType() == null || !user.getType().hasPermission(permission)) continue;
            return user;
        }
        return null;
    }

    @XmlTransient
    public CashDrawer getCurrentCashDrawer() {
        if (this.currentCashDrawer != null && this.currentCashDrawer.getId().equals(super.getCurrentCashDrawerId())) {
            return this.currentCashDrawer;
        }
        String currentCashDrawerId = super.getCurrentCashDrawerId();
        if (StringUtils.isNotEmpty((String)currentCashDrawerId)) {
            this.currentCashDrawer = CashDrawerDAO.getInstance().get(currentCashDrawerId);
        }
        return this.currentCashDrawer;
    }

    public void setCurrentCashDrawer(CashDrawer currentCashDrawer) {
        this.currentCashDrawer = currentCashDrawer;
        this.setCurrentCashDrawerId(currentCashDrawer == null ? null : currentCashDrawer.getId());
    }

    @Override
    public String getCurrentCashDrawerId() {
        if (this.currentCashDrawer != null && StringUtils.isNotEmpty((String)this.currentCashDrawer.getId())) {
            return this.currentCashDrawer.getId();
        }
        return super.getCurrentCashDrawerId();
    }

    @XmlTransient
    public CashDrawer getActiveDrawerPullReport() {
        CashDrawer currentDrawerPullReport = this.getCurrentCashDrawer();
        if (currentDrawerPullReport != null) {
            return currentDrawerPullReport;
        }
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal != null) {
            return terminal.getCurrentCashDrawer();
        }
        return null;
    }

    public void doClockIn(Terminal terminal, Shift shift, Calendar currentTime) {
        UserDAO.getInstance().refresh(this);
        if (this.isClockedIn().booleanValue()) {
            throw new PosException(Messages.getString("User.3") + this.getFullName());
        }
        List<User> linkedUsers = this.getLinkedUser();
        if (linkedUsers != null) {
            for (User user : linkedUsers) {
                if (!user.isClockedIn().booleanValue()) continue;
                throw new PosException(Messages.getString("User.3") + this.getFullName());
            }
        }
        this.setClockedIn(true);
        this.setCurrentShift(shift);
        this.setLastClockInTime(currentTime.getTime());
        if (this.isDriver().booleanValue()) {
            this.setAvailableForDelivery(true);
        }
        AttendenceHistory attendenceHistory = new AttendenceHistory();
        attendenceHistory.setClockInTime(currentTime.getTime());
        attendenceHistory.setClockInHour((short)currentTime.get(11));
        attendenceHistory.setUser(this);
        attendenceHistory.setTerminal(terminal);
        attendenceHistory.setShift(shift);
        UserDAO.getInstance().saveClockIn(this, attendenceHistory, shift, currentTime);
    }

    public void doClockOut(AttendenceHistory attendenceHistory, Shift shift, Calendar currentTime) {
        this.setClockedIn(false);
        this.setCurrentShift(null);
        this.setLastClockInTime(null);
        this.setLastClockOutTime(null);
        if (this.isDriver().booleanValue()) {
            this.setAvailableForDelivery(false);
        }
        attendenceHistory.setClockedOut(true);
        attendenceHistory.setClockOutTime(currentTime.getTime());
        attendenceHistory.setClockOutHour((short)currentTime.get(11));
        UserDAO.getInstance().saveClockOut(this, attendenceHistory, shift, currentTime);
    }

    public boolean canViewAllOpenTickets() {
        if (this.getType() == null) {
            return false;
        }
        Set<UserPermission> permissions = this.getType().getPermissions();
        if (permissions == null) {
            return false;
        }
        for (UserPermission permission : permissions) {
            if (!permission.equals(UserPermission.EDIT_OTHER_USERS_TICKETS)) continue;
            return true;
        }
        return false;
    }

    public boolean canViewAllCloseTickets() {
        if (this.getType() == null) {
            return false;
        }
        Set<UserPermission> permissions = this.getType().getPermissions();
        if (permissions == null) {
            return false;
        }
        for (UserPermission permission : permissions) {
            if (!permission.equals(UserPermission.EDIT_OTHER_USERS_TICKETS)) continue;
            return true;
        }
        return false;
    }

    public void setFullName(String str) {
    }

    public String getStatus() {
        if (this.isClockedIn().booleanValue()) {
            if (this.isAvailableForDelivery().booleanValue()) {
                return Messages.getString("User.5");
            }
            return Messages.getString("User.6");
        }
        return Messages.getString("User.7");
    }

    public String getFullName() {
        String name = "";
        if (StringUtils.isNotEmpty((String)this.getFirstName())) {
            name = this.getFirstName() + " ";
        }
        if (StringUtils.isNotEmpty((String)this.getLastName())) {
            name = name + this.getLastName();
        }
        return name;
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    @XmlTransient
    public boolean isManager() {
        return this.hasPermission(UserPermission.PERFORM_MANAGER_TASK);
    }

    @XmlTransient
    public boolean isAdministrator() {
        return this.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK);
    }

    public void setImage(ImageIcon image) {
    }

    @XmlTransient
    public ImageIcon getImage() {
        ImageResource imageResource = DataProvider.get().getImageResource(this.getImageId());
        if (imageResource != null) {
            return imageResource.getButtonBigImage();
        }
        return null;
    }

    @XmlTransient
    public User getParentUser() {
        String parentUserId = super.getParentUserId();
        if (StringUtils.isEmpty((String)parentUserId)) {
            return null;
        }
        return (User)DataProvider.get().getObjectOf(User.class, (Serializable)((Object)parentUserId));
    }

    public void setParentUser(User user) {
        if (user != null) {
            this.setParentUserId(user.getId());
        } else {
            this.setParentUserId(null);
        }
    }

    public boolean hasLinkedUser() {
        List<User> linkedUser = this.getLinkedUser();
        if (linkedUser != null && linkedUser.size() > 0) {
            return true;
        }
        if (this.getParentUser() == null) {
            return false;
        }
        return this.getParentUser().hasLinkedUser();
    }

    @Deprecated
    public List<User> getLinkedUsersIfExists() {
        List<User> linkedUser = this.getLinkedUser();
        if (linkedUser != null) {
            if (!linkedUser.contains(this)) {
                linkedUser.add(0, this);
            }
            return linkedUser;
        }
        if (this.getParentUser() == null) {
            return null;
        }
        return this.getParentUser().getLinkedUsersIfExists();
    }

    @XmlTransient
    public List<User> getRoles() {
        ArrayList<User> roleList = new ArrayList<User>();
        if (!this.isRoot().booleanValue()) {
            return this.getParentUser().getRoles();
        }
        List<User> linkedUser = this.getLinkedUser();
        if (linkedUser == null || linkedUser.isEmpty()) {
            roleList.add(this);
            return roleList;
        }
        if (this.getParentUserId() == null && !roleList.contains(this)) {
            roleList.add(this);
        }
        for (User user : linkedUser) {
            if (user.isDeleted().booleanValue() || !user.isActive().booleanValue()) continue;
            roleList.add(user);
        }
        return roleList;
    }

    public void setEncryptedPassword(String plainText) {
        try {
            super.setPassword(AESencrp.encrypt((String)plainText));
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    @JsonIgnoreProperties
    public String getPasswordAsPlainText() {
        String secretKey = super.getPassword();
        if (StringUtils.isNotEmpty((String)secretKey)) {
            try {
                return AESencrp.decrypt((String)secretKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return secretKey;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String properties = super.getProperties();
        if (StringUtils.isEmpty((String)properties)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
        return properties;
    }

    @Override
    public void setProperties(String properties) {
        super.setProperties(properties);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(properties, JsonObject.class);
    }

    public void addProperty(String key, String value) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(key, value);
    }

    public String getProperty(String key) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(key) && !(jsonElement = this.propertiesContainer.get(key)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    public boolean isPropertyValueTrue(String propertyName) {
        String property = this.getProperty(propertyName);
        return POSUtil.getBoolean(property);
    }

    public void removeProperty(String propertyName) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(propertyName);
        }
    }

    @XmlTransient
    public String getTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        UserType userType = this.getType();
        if (userType == null) {
            return null;
        }
        return userType.getName();
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public JsonObject getPropertiesContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public void setPropOrderTypes(List<OrderType> orderTypes) {
        String orderTypeIds = "";
        if (orderTypes != null) {
            Iterator<OrderType> iterator = orderTypes.iterator();
            while (iterator.hasNext()) {
                OrderType orderType = iterator.next();
                orderTypeIds = orderTypeIds + orderType.getId();
                if (!iterator.hasNext()) continue;
                orderTypeIds = orderTypeIds + ",";
            }
        }
        this.addProperty(JSON_PROP_USER_ORDER_TYPE, orderTypeIds);
    }

    @XmlTransient
    public List<OrderType> getPropOrderTypes() {
        String[] split;
        String property = this.getProperty(JSON_PROP_USER_ORDER_TYPE);
        ArrayList<OrderType> orderTypes = new ArrayList<OrderType>();
        if (StringUtils.isBlank((String)property)) {
            return orderTypes;
        }
        for (String string : split = property.split(",")) {
            OrderType orderType = DataProvider.get().getOrderType(string);
            if (orderType == null) continue;
            orderTypes.add(orderType);
        }
        return orderTypes;
    }

    @XmlTransient
    public List<String> getRoleIds() {
        ArrayList<String> roleIdList = new ArrayList<String>();
        List<User> linkedUserList = null;
        if (this.isRoot().booleanValue()) {
            roleIdList.add(this.getId());
            linkedUserList = this.getLinkedUser();
        } else {
            User rootUser = this.getParentUser();
            roleIdList.add(rootUser.getId());
            linkedUserList = rootUser.getLinkedUser();
        }
        if (linkedUserList != null) {
            for (User linkedUser : linkedUserList) {
                if (!linkedUser.isActive().booleanValue()) continue;
                roleIdList.add(linkedUser.getId());
            }
        }
        return roleIdList;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String string = this.getProperty(key);
        if (StringUtils.isBlank((String)string)) {
            return defaultValue;
        }
        return Boolean.valueOf(string);
    }

    public boolean isAllowClockOutWithOpenTickets() {
        return this.getBooleanProperty("ALLOW_CLOCKOUT_WITH_OPEN_TICKETS", Boolean.TRUE);
    }

    public void setAllowClockOutWithOpenTickets(boolean enabled) {
        this.addProperty("ALLOW_CLOCKOUT_WITH_OPEN_TICKETS", Boolean.toString(enabled));
    }
}

