/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.BaseAttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.report.WeeklyPayrollReportData;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class AttendenceHistoryDAO
extends BaseAttendenceHistoryDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    public List<User> findNumberOfClockedInUserAtHour(Date fromDay, Date toDay, int hour, Terminal terminal) {
        Session session = null;
        ArrayList<User> users = new ArrayList<User>();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)fromDay));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)toDay));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_HOUR, (Object)new Short((short)hour)));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            for (Object object : list) {
                AttendenceHistory history = (AttendenceHistory)object;
                if (!history.isClockedOut().booleanValue()) {
                    users.add(history.getUser());
                    continue;
                }
                if (history.getClockOutHour() < hour) continue;
                users.add(history.getUser());
            }
            ArrayList<User> arrayList = users;
            return arrayList;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.2"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List<User> findNumberOfClockedInUserAtShift(Date fromDay, Date toDay, Shift shift, Terminal terminal) {
        Session session = null;
        ArrayList<User> users = new ArrayList<User>();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)fromDay));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)toDay));
            if (shift != null) {
                criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_SHIFT_ID, (Object)shift.getId()));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            for (Object object : list) {
                AttendenceHistory history = (AttendenceHistory)object;
                users.add(history.getUser());
            }
            ArrayList<User> arrayList = users;
            return arrayList;
        }
        catch (Exception e) {
            throw new PosException(Messages.getString("AttendenceHistoryDAO.5"), e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttendenceHistory findHistoryByClockedInTime(User user) {
        Session session = null;
        try {
            session = this.createNewSession();
            AttendenceHistory attendenceHistory = this.findHistoryByClockedInTime(user, session);
            return attendenceHistory;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public AttendenceHistory findHistoryByClockedInTime(User user, Session session) {
        Criteria criteria = session.createCriteria(AttendenceHistory.class);
        if (user != null) {
            criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
        }
        criteria.add(Restrictions.isNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME));
        criteria.addOrder(Order.desc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
        criteria.setFirstResult(0);
        criteria.setMaxResults(1);
        List list = criteria.list();
        if (list.size() > 0) {
            return (AttendenceHistory)list.get(0);
        }
        return null;
    }

    public List<AttendanceReportData> findAttendance(Date from, Date to, List<User> users) {
        return this.findAttendance(from, to, users, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AttendanceReportData> findAttendance(Date from, Date to, List<User> users, UserType userType) {
        ArrayList<AttendanceReportData> reportDataList = new ArrayList<AttendanceReportData>();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)to));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
            if (users != null && users.size() > 0) {
                HashSet<String> allUserIds = new HashSet<String>();
                for (User user : users) {
                    if (user.isRoot().booleanValue()) {
                        allUserIds.addAll(user.getRoleIds());
                        continue;
                    }
                    allUserIds.add(user.getId());
                }
                if (!allUserIds.isEmpty()) {
                    criteria.add(Restrictions.in((String)AttendenceHistory.PROP_USER_ID, allUserIds));
                }
            }
            this.populateReportDataList(reportDataList, criteria.list(), userType);
            ArrayList<AttendanceReportData> arrayList = reportDataList;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PosException(Messages.getString("AttendenceHistoryDAO.6"), e);
        }
    }

    private void populateReportDataList(ArrayList<AttendanceReportData> reportDataList, List searchResultList, UserType userType) {
        for (AttendenceHistory history : searchResultList) {
            User user = history.getUser();
            if (user.isDeleted().booleanValue() || userType != null && !user.getUserTypeId().equals(userType.getId())) continue;
            AttendanceReportData data = new AttendanceReportData();
            data.setFrom(history.getClockInTime());
            data.setTo(history.getClockOutTime());
            data.setDate(history.getClockInTime());
            data.setUser(user);
            data.calculate();
            reportDataList.add(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WeeklyPayrollReportData> findWeeklyPayroll(Date from, Date to, User user, int firstDayOfWeek) {
        Session session = null;
        ArrayList<WeeklyPayrollReportData> reportDataList = new ArrayList<WeeklyPayrollReportData>();
        ArrayList<Date[]> searchDateList = new ArrayList<Date[]>();
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(from);
            Date[] dateRange = new Date[2];
            dateRange[0] = from;
            while (!from.after(to)) {
                Date toDate;
                int dayOfWeek = calendar.get(7);
                int difference = dayOfWeek - (firstDayOfWeek - 1);
                calendar.add(5, 1);
                if (difference != 0 && !calendar.getTime().after(to)) continue;
                calendar.add(5, -1);
                dateRange[1] = toDate = calendar.getTime();
                searchDateList.add(dateRange);
                dateRange = new Date[2];
                calendar.add(5, 1);
                dateRange[0] = from = calendar.getTime();
            }
            for (Date[] dateRangeArray : searchDateList) {
                criteria = session.createCriteria(AttendenceHistory.class);
                Date startOfDay = DateUtil.startOfDay(dateRangeArray[0]);
                Date endOfDay = DateUtil.endOfDay(dateRangeArray[1]);
                criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)startOfDay));
                criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)endOfDay));
                criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
                criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
                if (user != null) {
                    criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
                }
                reportDataList.addAll(this.populateWeeklyPayrollReportDataList(criteria.list(), startOfDay, endOfDay, firstDayOfWeek));
                if (user == null) continue;
                List<User> linkedUsers = user.getLinkedUser();
                for (User linkedUser : linkedUsers) {
                    if (linkedUser.getId().equals(user.getId())) continue;
                    criteria = session.createCriteria(AttendenceHistory.class);
                    criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
                    criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)to));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_USER_ID));
                    criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
                    criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)linkedUser.getId()));
                    reportDataList.addAll(this.populateWeeklyPayrollReportDataList(criteria.list(), startOfDay, endOfDay, firstDayOfWeek));
                }
            }
            ArrayList<WeeklyPayrollReportData> arrayList = reportDataList;
            return arrayList;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private List<WeeklyPayrollReportData> populateWeeklyPayrollReportDataList(List searchResultList, Date from, Date to, int firstDayOfWeek) {
        HashMap<String, WeeklyPayrollReportData> reportDataMap = new HashMap<String, WeeklyPayrollReportData>();
        for (AttendenceHistory history : searchResultList) {
            WeeklyPayrollReportData data = (WeeklyPayrollReportData)reportDataMap.get(history.getUser().getId());
            if (data == null) {
                data = new WeeklyPayrollReportData();
                data.setFirstDayOfWeek(firstDayOfWeek);
                reportDataMap.put(history.getUser().getId(), data);
            }
            data.setTotalWorkHourMs(data.getTotalWorkHourMs() + (history.getClockOutTime().getTime() - history.getClockInTime().getTime()));
            data.setFromDateOfWeek(from);
            data.setToDateOfWeek(to);
            data.setUser(history.getUser());
        }
        Collection values = reportDataMap.values();
        for (WeeklyPayrollReportData data : values) {
            data.calculateTotalHour();
        }
        return new ArrayList<WeeklyPayrollReportData>(values);
    }

    public List<AttendenceHistory> findHistory(Date from, Date toDate, User user) {
        return this.findHistory(from, toDate, user, null);
    }

    public List<AttendenceHistory> findHistory(Date from, Date toDate, User user, UserType userType) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add(Restrictions.between((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from, (Object)toDate));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_ID));
            AttendenceHistoryDAO.addUserWithAllRoleCriteria(criteria, user, AttendenceHistory.PROP_USER_ID);
            List list2 = criteria.list();
            if (userType == null) {
                List list = list2;
                return list;
            }
            ArrayList<AttendenceHistory> attendenceHistories = new ArrayList<AttendenceHistory>();
            for (AttendenceHistory attendenceHistory : list2) {
                if (!attendenceHistory.getUser().getUserTypeId().equals(userType.getId())) continue;
                attendenceHistories.add(attendenceHistory);
            }
            ArrayList<AttendenceHistory> arrayList = attendenceHistories;
            return arrayList;
        }
    }

    public List<AttendenceHistory> findAttendanceHistory(Date from, Date to, User user) {
        try (Session session = null;){
            List list2;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from));
            criteria.add((Criterion)Restrictions.le((String)AttendenceHistory.PROP_CLOCK_OUT_TIME, (Object)to));
            criteria.addOrder(Order.asc((String)AttendenceHistory.PROP_ID));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
            }
            List list = list2 = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateAttendenceHistoryList(List<AttendenceHistory> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (AttendenceHistory item : dataList) {
                AttendenceHistory existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<AttendenceHistory> findClockedInUsers(Date from, Date toDate) {
        return this.findClockedInUsers(from, toDate, null);
    }

    public List<AttendenceHistory> findClockedInUsers(Date from, Date toDate, UserType userType) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            SimpleExpression geFromDay = Restrictions.ge((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from);
            SimpleExpression ltToDay = Restrictions.lt((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)toDate);
            SimpleExpression ltFromDay = Restrictions.lt((String)AttendenceHistory.PROP_CLOCK_IN_TIME, (Object)from);
            Criterion isNull = Restrictions.isNull((String)AttendenceHistory.PROP_CLOCK_OUT_TIME);
            LogicalExpression expression = Restrictions.and((Criterion)isNull, (Criterion)ltFromDay);
            criteria.add((Criterion)Restrictions.or((Criterion)expression, (Criterion)Restrictions.and((Criterion)geFromDay, (Criterion)ltToDay)));
            if (userType != null) {
                List<String> userids = UserDAO.getInstance().getIdListForType(userType, session);
                criteria.add(userids != null && userids.size() > 0 ? Restrictions.in((String)AttendenceHistory.PROP_USER_ID, userids) : Restrictions.isNull((String)AttendenceHistory.PROP_USER_ID));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public AttendenceHistory findLastAttendanceHistory(User user) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(AttendenceHistory.class);
            criteria.addOrder(Order.desc((String)AttendenceHistory.PROP_CLOCK_IN_TIME));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)AttendenceHistory.PROP_USER_ID, (Object)user.getId()));
            }
            criteria.setFirstResult(0);
            criteria.setMaxResults(1);
            AttendenceHistory attendenceHistory = (AttendenceHistory)criteria.uniqueResult();
            return attendenceHistory;
        }
    }
}

