/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.CreditBook;
import com.floreantpos.model.CreditBookType;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.dao.BaseCreditBookTypeDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.JsonUtil;
import com.foretees.salesforce.sync.SFUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CreditBookTypeDAO
extends BaseCreditBookTypeDAO {
    @Deprecated
    public List<CreditBookType> getCreditBookTypesForMember(String memberId) {
        return this.getCreditBookTypesForMemberAndOrderType(memberId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<CreditBookType> getCreditBookTypesForMemberAndOrderType(String memberId, String orderTypeId) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(CreditBook.class);
            this.creditBookCriteria(memberId, criteria);
            Projection projection = Projections.distinct((Projection)Projections.property((String)CreditBook.PROP_CREDIT_BOOK_TYPE_ID));
            criteria.setProjection(projection);
            List creditBookTypeIds = criteria.list();
            if (creditBookTypeIds.isEmpty()) {
                List<CreditBookType> list2 = null;
                return list2;
            }
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)CreditBookType.PROP_ACTIVE, (Object)true));
            criteria.add(Restrictions.in((String)CreditBookType.PROP_ID, (Collection)creditBookTypeIds));
            if (orderTypeId != null) {
                criteria.createAlias("orderTypes", "ot");
                criteria.add((Criterion)Restrictions.eq((String)("ot." + OrderType.PROP_ID), (Object)orderTypeId));
            }
            if (!(list = criteria.list()).isEmpty()) {
                for (CreditBookType creditBookType : list) {
                    criteria = session.createCriteria(CreditBook.class);
                    this.creditBookCriteria(memberId, criteria);
                    criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_CREDIT_BOOK_TYPE_ID, (Object)creditBookType.getId()));
                    projection = Projections.sum((String)CreditBook.PROP_BALANCE);
                    criteria.setProjection(projection);
                    Object uniqueResult = criteria.uniqueResult();
                    if (!(uniqueResult instanceof Number)) continue;
                    Double totalBalance = (Double)uniqueResult;
                    creditBookType.setMemberId(memberId);
                    creditBookType.setMemberBalance(totalBalance);
                }
                List list3 = list;
                return list3;
            }
            List<CreditBookType> list4 = null;
            return list4;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void creditBookCriteria(String memberId, Criteria criteria) {
        criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_CUSTOMER_ID, (Object)memberId));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)CreditBook.PROP_EXPIRY_DATE), (Criterion)Restrictions.ge((String)CreditBook.PROP_EXPIRY_DATE, (Object)DateUtil.startOfDay(StoreDAO.getServerTimestamp()))));
        criteria.add((Criterion)Restrictions.eq((String)CreditBook.PROP_EXPIRED, (Object)Boolean.FALSE));
    }

    public List<CreditBookType> getSFCreditBookTypesForMember(String memberId, OrderType orderType) throws Exception {
        JsonArray memberCreditBooks = SFUtil.getMemberCreditBooks(memberId);
        Map<String, CreditBookType> itemMap = this.getCustomerCreditBooksFromArray(memberCreditBooks);
        ArrayList<CreditBookType> values = new ArrayList<CreditBookType>(itemMap.values());
        for (CreditBookType cBookType : values) {
            this.initialize(cBookType);
            List<OrderType> orderTypes = cBookType.getOrderTypes();
            if (orderTypes == null || orderTypes.contains(orderType)) continue;
            itemMap.remove(cBookType.getId());
        }
        if (itemMap.values().size() == 0) {
            return null;
        }
        List<PosTransaction> transactions = PosTransactionDAO.getInstance().findUnSyncedCreditBookTransactions(memberId);
        for (PosTransaction posTransaction : transactions) {
            String creditBookTypeId = posTransaction.getCustomPaymentRef();
            CreditBookType creditBookType = itemMap.get(creditBookTypeId);
            if (creditBookType == null) continue;
            Double amount = posTransaction.getAmount();
            if (posTransaction instanceof RefundTransaction) {
                amount = -1.0 * amount;
            }
            creditBookType.setMemberBalance(creditBookType.getMemberBalance() - amount);
        }
        return new ArrayList<CreditBookType>(itemMap.values());
    }

    public Map<String, CreditBookType> getCustomerCreditBooksFromArray(JsonArray memberCreditBooks) throws Exception {
        HashMap<String, CreditBookType> itemMap = new HashMap<String, CreditBookType>();
        if (memberCreditBooks == null) {
            return itemMap;
        }
        for (JsonObject itemObject : memberCreditBooks) {
            String creditBookTypeId = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"creditBookType"));
            double balance = JsonUtil.getDoubleValue((JsonValue)itemObject.get((Object)"balance"));
            boolean isNewCreditBookType = Boolean.FALSE;
            CreditBookType creditBookType = (CreditBookType)itemMap.get(creditBookTypeId);
            if (creditBookType == null) {
                creditBookType = this.get(creditBookTypeId);
                if (creditBookType == null) {
                    creditBookType = new CreditBookType(creditBookTypeId);
                    creditBookType.setLabel(creditBookTypeId);
                    creditBookType.setValue(creditBookTypeId);
                    isNewCreditBookType = Boolean.TRUE;
                }
            } else {
                balance = creditBookType.getMemberBalance() + balance;
            }
            creditBookType.setMemberBalance(balance);
            if (isNewCreditBookType) {
                this.save(creditBookType);
            }
            itemMap.put(creditBookTypeId, creditBookType);
        }
        return itemMap;
    }

    public void initialize(CreditBookType creditbooktype) {
        if (creditbooktype == null || StringUtils.isBlank((String)creditbooktype.getId())) {
            return;
        }
        if (Hibernate.isInitialized(creditbooktype.getOrderTypes())) {
            return;
        }
        try (Session session = this.createNewSession();){
            session.refresh((Object)creditbooktype);
            Hibernate.initialize(creditbooktype.getOrderTypes());
        }
    }
}

