/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.dao.BaseCustomerDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class CustomerDAO
extends BaseCustomerDAO {
    @Override
    protected void delete(Object obj, Session session) {
        Customer customer = (Customer)obj;
        if (customer == null) {
            throw new PosException(Messages.getString("CustomerNotFound"));
        }
        customer.setDeleted(Boolean.TRUE);
        this.saveOrUpdate(customer, session);
        this.removeCustomerFromCustomerGroup(customer, session);
    }

    public void removeCustomerFromCustomerGroup(Customer customer, Session session) {
        Criteria criteria = session.createCriteria(CustomerGroup.class);
        this.addDeletedFilter(criteria);
        criteria.createAlias("customers", "customer");
        criteria.add((Criterion)Restrictions.eq((String)("customer." + Customer.PROP_ID), (Object)customer.getId()));
        List customerGroups = criteria.list();
        if (customerGroups == null || customerGroups.isEmpty()) {
            return;
        }
        for (CustomerGroup group : customerGroups) {
            group.getCustomers().remove(customer);
            CustomerGroupDAO.getInstance().update(group, session);
        }
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)Customer.PROP_ID);
    }

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByMobileLoyalityName(String mobileEmailName, PaginatedTableModel tableModel) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)mobileEmailName)) {
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_MOBILE_NO, (String)mobileEmailName, (MatchMode)MatchMode.ANYWHERE));
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_NAME, (String)mobileEmailName, (MatchMode)MatchMode.ANYWHERE));
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_EMAIL, (String)mobileEmailName, (MatchMode)MatchMode.ANYWHERE));
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_LOYALTY_NO, (String)mobileEmailName, (MatchMode)MatchMode.ANYWHERE));
            }
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)disjunction);
            criteria.setFirstResult(0);
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setNumRows(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getNumberOfCustomers(String searchString) {
        Session session;
        block5: {
            Criteria criteria;
            block4: {
                int n;
                session = null;
                criteria = null;
                try {
                    if (!StringUtils.isEmpty((String)searchString)) break block4;
                    n = 0;
                }
                catch (Throwable throwable) {
                    this.closeSession(session);
                    throw throwable;
                }
                this.closeSession(session);
                return n;
            }
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + searchString + "%")));
            disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + searchString + "%")));
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            if (list == null) break block5;
            int n = list.size();
            this.closeSession(session);
            return n;
        }
        int n = 0;
        this.closeSession(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getNumberOfCustomers(String mobile, String loyalty, String name) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)mobile)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + mobile + "%")));
            }
            if (StringUtils.isNotEmpty((String)loyalty)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_LOYALTY_NO, (Object)("%" + loyalty + "%")));
            }
            if (StringUtils.isNotEmpty((String)name)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + name + "%")));
            }
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            if (list != null) {
                int n = list.size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findBy(String mobile, String loyalty, String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)mobile)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + mobile + "%")));
            }
            if (StringUtils.isNotEmpty((String)loyalty)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_LOYALTY_NO, (Object)("%" + loyalty + "%")));
            }
            if (StringUtils.isNotEmpty((String)name)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + name + "%")));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void findBy(String searchString, PaginationSupport tableModel) {
        this.findByPhoneOrName(searchString, tableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByPhoneOrName(String searchString, PaginationSupport tableModel) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)searchString)) {
                Disjunction disjunction = Restrictions.disjunction();
                disjunction.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)Customer.PROP_NAME, (String)searchString, (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (String)searchString, (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)Customer.PROP_LOYALTY_NO, (String)searchString, (MatchMode)MatchMode.ANYWHERE)}));
                criteria.add((Criterion)disjunction);
            }
            tableModel.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            criteria.addOrder(Order.asc((String)Customer.PROP_FIRST_NAME).ignoreCase());
            tableModel.setRows(criteria.list());
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findByMobileNumber(String mobileNo) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)mobileNo)) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_MOBILE_NO, (Object)mobileNo));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findByName(String name) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)name)) {
                criteria.add(Restrictions.ilike((String)Customer.PROP_FIRST_NAME, (String)(name + "%".trim()), (MatchMode)MatchMode.ANYWHERE));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByNameOrEmail(Pagination tableModel, String searchString) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)searchString)) {
                disjunction.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)searchString, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)Customer.PROP_EMAIL, (String)searchString, (MatchMode)MatchMode.ANYWHERE)));
            }
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)disjunction);
            criteria.setProjection(Projections.rowCount());
            Number uniqueResult = (Number)criteria.uniqueResult();
            tableModel.setNumRows(uniqueResult.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            tableModel.setRows(criteria.list());
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer findById(String customerId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_ID, (Object)customerId));
            Customer customer = (Customer)criteria.uniqueResult();
            return customer;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Customer findByPhoneOrEmail(String mobileNo, String email) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isEmpty((String)mobileNo)) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)email));
            } else {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Customer.PROP_MOBILE_NO, (Object)mobileNo), (Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)email)));
            }
            List list = criteria.list();
            if (list.size() > 0) {
                Customer customer = (Customer)list.get(0);
                return customer;
            }
            Customer customer = null;
            return customer;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    @Deprecated
    public boolean deleteAll(List<Customer> customerList) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            String queryDeliveryAddress = "update DELIVERY_ADDRESS set CUSTOMER_ID = null";
            String queryTableBookingInfo = "update TABLE_BOOKING_INFO set customer_id = null";
            String queryTicketItemSeat = "update TICKET_ITEM_SEAT set MEMBER_ID = null";
            SQLQuery deliveryAddressUpdateQuery = session.createSQLQuery(queryDeliveryAddress);
            SQLQuery tableBookingInfoUpdateQuery = session.createSQLQuery(queryTableBookingInfo);
            SQLQuery ticketItemSeatUpdateQuery = session.createSQLQuery(queryTicketItemSeat);
            deliveryAddressUpdateQuery.executeUpdate();
            tableBookingInfoUpdateQuery.executeUpdate();
            ticketItemSeatUpdateQuery.executeUpdate();
            for (Customer customer : customerList) {
                this.delete(customer, session);
            }
            tx.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            tx.rollback();
            LogFactory.getLog(CustomerDAO.class).error((Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getNumberOfCustomers() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            criteria.list();
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers(CustomerGroup customerGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "customer");
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (customerGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_CUSTOMER_GROUP_ID, (Object)customerGroup.getId()));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(PaginatedTableModel tableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            tableModel.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            criteria.addOrder(Order.asc((String)Customer.PROP_FIRST_NAME).ignoreCase());
            tableModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(CustomerGroup customerGroup, PaginatedListModel tableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (customerGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_CUSTOMER_GROUP_ID, (Object)customerGroup.getId()));
            }
            tableModel.setNumRows(this.rowCount(criteria));
            criteria.setFirstResult(tableModel.getCurrentRowIndex());
            criteria.setMaxResults(tableModel.getPageSize());
            criteria.addOrder(Order.asc((String)Customer.PROP_NAME).ignoreCase());
            tableModel.setData(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String searchString) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number rowCount;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if ((rowCount = (Number)criteria.uniqueResult()) != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(String searchString, BeanTableModel<Customer> listModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Customer.PROP_NAME).ignoreCase());
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)Customer.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer initialize(Customer customer) {
        if (customer == null || customer.getId() == null) {
            return customer;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)customer);
            Hibernate.initialize(customer.getDeliveryAddresses());
            Hibernate.initialize(customer.getDeliveryInstructions());
            Customer customer2 = customer;
            return customer2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Customer findByEmail(String email) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)email));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                Customer customer = (Customer)list.get(0);
                return customer;
            }
            Customer customer = null;
            return customer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExist(String email) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)email));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExistExceptCustomer(String email, Customer customer) {
        if (StringUtils.isEmpty((String)email)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)email));
            criteria.add((Criterion)Restrictions.ne((String)Customer.PROP_ID, (Object)customer.getId()));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public List<Customer> getCustomerByCustomerGroup(CustomerGroup customerGroup, Session session) {
        String sql = "SELECT DISTINCT CUSTOMER_ID FROM CUSTOMER_CUST_GROUP WHERE CUST_GROUP_ID = :tt_id";
        SQLQuery query = session.createSQLQuery(sql);
        query.setParameter("tt_id", (Object)customerGroup.getId());
        List customerIds = query.list();
        if (customerIds != null && !customerIds.isEmpty()) {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.in((String)Customer.PROP_ID, (Collection)customerIds));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)Customer.PROP_FIRST_NAME), Customer.PROP_FIRST_NAME);
            projectionList.add((Projection)Projections.property((String)Customer.PROP_LAST_NAME), Customer.PROP_LAST_NAME);
            criteria.setProjection((Projection)projectionList);
            criteria.setMaxResults(100);
            return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
        }
        return null;
    }

    @Override
    public List<Customer> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.addOrder(Order.asc((String)Customer.PROP_FIRST_NAME).ignoreCase());
            List list = criteria.list();
            return list;
        }
    }
}

