/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.DeletedData;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseDeletedDataDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.DeletedDataType;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DeletedDataDAO
extends BaseDeletedDataDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    public void saveOrUpdateDeletedDataList(List<DeletedData> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (DeletedData item : dataList) {
                Ticket ticket;
                DeletedDataType dataType;
                DeletedData existingItem = this.get(item.getId());
                if (existingItem != null) continue;
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
                if (StringUtils.isBlank((String)item.getDataId()) || (dataType = DeletedDataType.fromDataTypeId(item.getDataTypeId())) != DeletedDataType.TICKET || (ticket = TicketDAO.getInstance().get(item.getDataId())) == null) continue;
                session.delete((Object)ticket);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }
}

