/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Customer;
import com.floreantpos.model.MemberType;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.PaginationSupport;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class ForeteesCustomerDAO
extends CustomerDAO {
    private static ForeteesCustomerDAO INSTANCE2;

    public void findCustomer(String name, MemberType memberType, PaginationSupport paginationSupport, String ... fields) {
        this.findCustomer(name, memberType, paginationSupport, false, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findCustomer(String name, MemberType memberType, PaginationSupport paginationSupport, Boolean hideInactiveMembers, String ... fields) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Customer.class);
            this.addDeletedFilter(criteria);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            if (StringUtils.isNotEmpty((String)name)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_MEMBER_ID, (String)(name + "%".trim()), (MatchMode)MatchMode.START), (Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)(name + "%".trim()), (MatchMode)MatchMode.ANYWHERE)));
            }
            if (memberType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_MEMBER_TYPE_NAME, (Object)memberType.getName()));
            }
            if (hideInactiveMembers.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_ACTIVE, (Object)Boolean.TRUE));
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_RESTRICTED_FROM_P_O_S, (Object)Boolean.FALSE));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                paginationSupport.setNumRows(rowCount.intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)Customer.PROP_NAME).ignoreCase());
            if (fields != null && fields.length > 0) {
                ProjectionList projectionList = Projections.projectionList();
                for (String field : fields) {
                    projectionList.add((Projection)Projections.property((String)field), field);
                }
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuCategory.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainMemberId(String memberId, String customerId) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)customerId)) {
                criteria.add((Criterion)Restrictions.ne((String)Customer.PROP_ID, (Object)customerId));
            }
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_MEMBER_ID, (Object)memberId));
            criteria.setProjection((Projection)Projections.count((String)Customer.PROP_MEMBER_ID));
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public static ForeteesCustomerDAO getInstance() {
        if (INSTANCE2 == null) {
            INSTANCE2 = new ForeteesCustomerDAO();
        }
        return INSTANCE2;
    }
}

