/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DateUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

public class GenericDAO
extends _RootDAO {
    private static final GenericDAO instance = new GenericDAO();

    public static GenericDAO getInstance() {
        return instance;
    }

    @Override
    protected Class getReferenceClass() {
        return null;
    }

    @Override
    public Serializable save(Object obj) {
        return super.save(obj);
    }

    @Override
    public void saveOrUpdate(Object obj) {
        super.saveOrUpdate(obj);
    }

    @Override
    public Serializable save(Object obj, Session s) {
        return super.save(obj, s);
    }

    @Override
    public void saveOrUpdate(Object obj, Session s) {
        super.saveOrUpdate(obj, s);
    }

    @Override
    public Session getSession(String configFile, boolean createNew) {
        return super.getSession(configFile, createNew);
    }

    public List findAll(Class clazz, Session session) {
        Criteria crit = session.createCriteria(clazz);
        return crit.list();
    }

    public void saveAll(List list, Session session) {
        Transaction tx = session.beginTransaction();
        for (Object object : list) {
            session.saveOrUpdate(object);
        }
        tx.commit();
    }

    @Override
    public void closeSession(Session session) {
        try {
            super.closeSession(session);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List findAllUnSyncItem(Class refClass) {
        return this.findAllUnSyncItem(refClass, false, null);
    }

    public List findAllUnSyncItem(Class<?> refClass, boolean findAll, Date syncTime) {
        List unSyncItems = this.getAllUnSyncItems(refClass, findAll, syncTime);
        if (unSyncItems == null || unSyncItems.size() == 0) {
            return unSyncItems;
        }
        if (!(unSyncItems.get(0) instanceof TimedModel)) {
            return unSyncItems;
        }
        for (TimedModel data : unSyncItems) {
            data.setLastUpdateTime(syncTime);
        }
        return unSyncItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getAllUnSyncItems(Class<?> refClass, boolean findAll, Date syncTime) {
        Session session = null;
        try {
            Criterion nullUpdateTime;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(refClass);
            if (!findAll) {
                nullUpdateTime = Restrictions.isNull((String)InventoryStock.PROP_LAST_UPDATE_TIME);
                Criterion nullSyncTime = Restrictions.isNull((String)InventoryStock.PROP_LAST_SYNC_TIME);
                PropertyExpression gtQuery = Restrictions.gtProperty((String)InventoryStock.PROP_LAST_UPDATE_TIME, (String)InventoryStock.PROP_LAST_SYNC_TIME);
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{nullUpdateTime, nullSyncTime, gtQuery}));
            }
            if (findAll && syncTime != null) {
                nullUpdateTime = Restrictions.isNull((String)InventoryStock.PROP_LAST_SYNC_TIME);
                SimpleExpression ltQuery = Restrictions.lt((String)InventoryStock.PROP_LAST_SYNC_TIME, (Object)syncTime);
                criteria.add((Criterion)Restrictions.or((Criterion)nullUpdateTime, (Criterion)ltQuery));
            }
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void updateItemsLastSyncTime(List<String> ids, String tableName) {
        this.updateItemsLastSyncTime(null, ids, tableName);
    }

    public void updateItemsLastSyncTime(Date syncTime, List<String> ids, String tableName) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        if (syncTime == null) {
            syncTime = new Date();
        }
        String whereCondition = "(";
        Iterator<String> iterator = ids.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            whereCondition = whereCondition + "'" + id + "'";
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            String hqlString = "update " + tableName + " set %s=:lastUpdateTime, %s=:lastSyncTime where %s in %s";
            hqlString = String.format(hqlString, InventoryStock.PROP_LAST_UPDATE_TIME, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID, whereCondition);
            Query query = session.createQuery(hqlString);
            query.setParameter("lastUpdateTime", (Object)syncTime);
            query.setParameter("lastSyncTime", (Object)syncTime);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    public void updateItemsLastSyncTimeByInt(Date syncTime, List<Integer> ids, String tableName) {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        if (syncTime == null) {
            syncTime = new Date();
        }
        String whereCondition = "(";
        Iterator<Integer> iterator = ids.iterator();
        while (iterator.hasNext()) {
            int id = iterator.next();
            whereCondition = whereCondition + id;
            if (!iterator.hasNext()) continue;
            whereCondition = whereCondition + ",";
        }
        whereCondition = whereCondition + ")";
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            String hqlString = "update " + tableName + " set %s=:lastUpdateTime, %s=:lastSyncTime where %s in" + whereCondition;
            hqlString = String.format(hqlString, InventoryStock.PROP_LAST_UPDATE_TIME, InventoryStock.PROP_LAST_SYNC_TIME, InventoryStock.PROP_ID);
            Query query = session.createQuery(hqlString);
            query.setParameter("lastUpdateTime", (Object)syncTime);
            query.setParameter("lastSyncTime", (Object)syncTime);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
    }

    public void updateLastUpdateTimeIfNull(String tableName) {
        Calendar realTime = Calendar.getInstance();
        realTime.set(14, realTime.get(14));
        this.updateLastUpdateTimeIfNull(tableName, realTime.getTime());
    }

    public void updateLastUpdateTimeIfNull(String tableName, Date realTime) {
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            String hqlString = "update " + tableName + " set %s=:lastUpdateTime where %s is null";
            hqlString = String.format(hqlString, Terminal.PROP_LAST_UPDATE_TIME, Terminal.PROP_LAST_UPDATE_TIME);
            Query query = session.createQuery(hqlString);
            query.setParameter("lastUpdateTime", (Object)realTime);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            PosLog.error(this.getClass(), "Failed to update last update time where last update time is null");
        }
    }

    public void checkIdOrNameExists(String existingId, String name, Class modelClass) {
        if (StringUtils.isBlank((String)name)) {
            throw new PosException("Name is empty");
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(modelClass);
            criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
            if (StringUtils.isNotEmpty((String)existingId)) {
                criteria.add((Criterion)Restrictions.ne((String)"id", (Object)existingId));
            }
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                throw new PosException(String.format("The name %s is not available.", name));
            }
        }
    }

    public void updateLastUpdateTimeProperty(Class class1, Date time) {
        Store store = StoreDAO.getRestaurant();
        this.updateLastUpdateTimeProperty(store, class1, time);
        StoreDAO.getInstance().saveOrUpdate(store);
    }

    public void updateLastUpdateTimeProperty(Store store, Class class1, Date time) {
        this.updateLastUpdateTimeProperty(store, class1.getSimpleName(), time);
    }

    public void updateLastUpdateTimeProperty(Store store, String simpleName, Date time) {
        store.addProperty(simpleName + "." + Store.PROP_LAST_UPDATE_TIME, DateUtil.formatDateWithDefaultTimeAndSec(time));
    }

    private void updateLastSyncTime(String tableName) {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.getSession();
            tx = session.beginTransaction();
            String hqlString = "update " + tableName + " set %s=:lastSyncTime";
            hqlString = String.format(hqlString, InventoryStock.PROP_LAST_SYNC_TIME);
            Query query = session.createQuery(hqlString);
            query.setParameter("lastSyncTime", null);
            query.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<String> getForeignDataListNames(Session session, Class<?> clazz, String column, String id) {
        return this.getForeignDataList(session, clazz, column, id, "name");
    }

    public List getForeignDataList(Session session, Class<?> clazz, String column, String id, String fetchColumn) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.setProjection((Projection)Projections.property((String)fetchColumn));
        criteria.add((Criterion)Restrictions.eq((String)column, (Object)id));
        this.addDeletedFilter(criteria, clazz);
        return criteria.list();
    }

    public List<String> getForeignDataListNames(Session session, Class<?> clazz, String collectionName, String column, String id) {
        return this.getForeignDataList(session, clazz, collectionName, column, id, "name");
    }

    public List getForeignDataList(Session session, Class<?> clazz, String collectionName, String column, String id, String fetchColumn) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.createAlias(collectionName, "c");
        criteria.setProjection((Projection)Projections.property((String)fetchColumn));
        criteria.add((Criterion)Restrictions.eq((String)("c." + column), (Object)id));
        this.addDeletedFilter(criteria, clazz);
        return criteria.list();
    }
}

