/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.BaseImageResourceDAO;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.NullPrecedence;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ImageResourceDAO
extends BaseImageResourceDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowCount() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImages(PaginationSupport model, ImageResource.IMAGE_CATEGORY imgCategory, String description) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            if (imgCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)imgCategory.getType()));
            }
            if (StringUtils.isNotEmpty((String)description)) {
                criteria.add(Restrictions.ilike((String)ImageResource.PROP_DESCRIPTION, (String)description, (MatchMode)MatchMode.START));
            }
            if (imgCategory != ImageResource.IMAGE_CATEGORY.DELETED) {
                criteria.add((Criterion)Restrictions.ne((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.DELETED.getType()));
            }
            model.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.desc((String)ImageResource.PROP_LAST_UPDATE_TIME).nulls(NullPrecedence.LAST));
            int currentRowIndex = model.getCurrentRowIndex();
            criteria.setFirstResult(currentRowIndex);
            criteria.setMaxResults(model.getPageSize());
            List result = criteria.list();
            model.setRows(result);
        }
        catch (Exception e) {
            model.setRows(new ArrayList());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getDefaultFloorImage(InputStream inputStream) throws Exception {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.addOrder(Order.asc((String)ImageResource.PROP_ID));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_IMAGE_CATEGORY_NUM, (Object)ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType()));
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_DESCRIPTION, (Object)"default_floor_image"));
            List list = criteria.list();
            if (list.size() > 0) {
                ImageResource imageResource = (ImageResource)list.get(0);
                return imageResource;
            }
            if (inputStream != null) {
                ImageResource imageResource = new ImageResource();
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                imageResource.setImageBytes(byteArray);
                imageResource.setDescription("default_floor_image");
                imageResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.save(imageResource);
                ImageResource imageResource2 = imageResource;
                return imageResource2;
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource findById(String id) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(ImageResource.class);
            criteria.add((Criterion)Restrictions.eq((String)ImageResource.PROP_ID, (Object)id));
            List result = criteria.list();
            if (result == null || result.isEmpty()) {
                ImageResource imageResource = null;
                return imageResource;
            }
            ImageResource imageResource = (ImageResource)result.get(0);
            return imageResource;
        }
    }

    public void saveOrUpdate(List<ImageResource> resourceList) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ImageResource resource : resourceList) {
                this.saveOrUpdate(resource, session);
            }
            tx.commit();
        }
    }

    public void saveOrUpdateImageResourceList(List<ImageResource> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (ImageResource item : dataList) {
                ImageResource existingItem;
                if (item.getImageBytes() == null) {
                    item.setImageBytes(new byte[0]);
                }
                if ((existingItem = this.get(item.getId())) != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
    }
}

