/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.dao.BaseInventoryVendorItemsDAO;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class InventoryVendorItemsDAO
extends BaseInventoryVendorItemsDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof InventoryVendorItems) {
            InventoryVendorItems vendorItems = (InventoryVendorItems)obj;
            vendorItems.setVendor(null);
            vendorItems.setItem(null);
            super.update(vendorItems, s);
        } else {
            super.delete(obj, s);
        }
    }

    @Override
    public List<InventoryVendorItems> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)InventoryVendorItems.PROP_VENDOR), (Criterion)Restrictions.isNotNull((String)InventoryVendorItems.PROP_ITEM)));
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorItems> findByItem(MenuItem item) {
        if (item.getId() == null) {
            return null;
        }
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (item != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)item));
            }
            if ((list = criteria.list()).isEmpty()) {
                List<InventoryVendorItems> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    public InventoryVendorItems findByItemAndVendor(MenuItem item, InventoryVendor vendor) {
        if (item == null || vendor == null) {
            return null;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)item));
            criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            criteria.setMaxResults(1);
            InventoryVendorItems inventoryVendorItems = (InventoryVendorItems)criteria.uniqueResult();
            return inventoryVendorItems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vendorHasItem(InventoryVendor vendor, MenuItem item, Session session) {
        if (item.getId() == null) {
            return false;
        }
        boolean isNewSession = false;
        try {
            List list;
            if (session == null) {
                session = this.createNewSession();
                isNewSession = true;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (item != null && vendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_ITEM, (Object)item));
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosLog.error(InventoryVendorDAO.class, e.getMessage(), e);
        }
        finally {
            if (isNewSession && session != null) {
                session.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveItems(PurchaseOrder order) {
        Transaction tx = null;
        try (Session session = null;){
            session = this.createNewSession();
            tx = session.beginTransaction();
            List<PurchaseOrderItem> orderItems = order.getOrderItems();
            for (PurchaseOrderItem purchaseOrderItem : orderItems) {
                MenuItem menuItem = purchaseOrderItem.getMenuItem();
                InventoryVendor vendor = order.getVendor();
                if (this.vendorHasItem(vendor, menuItem, null)) continue;
                InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
                inventoryVendorItems.setItem(menuItem);
                inventoryVendorItems.setVendor(vendor);
                session.saveOrUpdate((Object)inventoryVendorItems);
            }
            session.saveOrUpdate((Object)order);
            tx.commit();
        }
    }

    public void saveItems(InventoryTransaction transaction, Session session) {
        try {
            MenuItem menuItem = transaction.getMenuItem();
            InventoryVendor vendor = null;
            if (transaction.getVendorId() != null) {
                vendor = InventoryVendorDAO.getInstance().get(transaction.getVendorId());
            }
            if (!this.vendorHasItem(vendor, menuItem, session)) {
                InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
                inventoryVendorItems.setItem(menuItem);
                inventoryVendorItems.setVendor(vendor);
                session.saveOrUpdate((Object)inventoryVendorItems);
            }
        }
        catch (Exception e) {
            PosLog.error(InventoryVendorDAO.class, e.getMessage(), e);
        }
    }

    public void saveAll(List<InventoryVendorItems> vendorItemsList) {
        Transaction tx = null;
        Session session = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveAll(vendorItemsList, session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new RuntimeException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveAll(List<InventoryVendorItems> vendorItemsList, Session session) {
        for (InventoryVendorItems inventoryVendorItems : vendorItemsList) {
            this.saveOrUpdate(inventoryVendorItems, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InventoryVendorItems> findByVendor(InventoryVendor vendor) {
        if (vendor.getId() == null) {
            return null;
        }
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (vendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            }
            if ((list = criteria.list()).isEmpty()) {
                List<InventoryVendorItems> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVendorItems(PaginatedListModel model, InventoryVendor vendor) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (vendor != null) {
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)vendor));
            }
            criteria.setProjection(Projections.rowCount());
            Number rowCount = (Number)criteria.uniqueResult();
            model.setNumRows(rowCount.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(model.getCurrentRowIndex());
            criteria.setMaxResults(model.getPageSize());
            List list = criteria.list();
            for (Object object : list) {
                InventoryVendorItems vendorItems;
                if (!(object instanceof InventoryVendorItems) || (vendorItems = (InventoryVendorItems)object).getItem() == null || vendorItems.getItem().getId() == null) continue;
                model.setData(criteria.list());
            }
        }
    }

    public void saveOrUpdateInventoryVendorItems(List<InventoryVendorItems> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (dataList == null) {
            return;
        }
        Transaction tx = null;
        Session session = null;
        HashMap<String, MenuItem> itemMap = new HashMap<String, MenuItem>();
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            for (InventoryVendorItems item : dataList) {
                InventoryVendorItems existingItem;
                MenuItem existingMenuItem = item.getItem();
                if (existingMenuItem != null) {
                    MenuItem mapItem = (MenuItem)itemMap.get(existingMenuItem.getId());
                    if (mapItem != null) {
                        item.setItem(mapItem);
                    } else {
                        existingMenuItem = MenuItemDAO.getInstance().get(existingMenuItem.getId());
                        item.setItem(existingMenuItem);
                        itemMap.put(existingMenuItem.getId(), existingMenuItem);
                    }
                }
                if ((existingItem = this.get(item.getId())) == null) {
                    existingItem = this.findByItemAndVendor(item.getItem(), item.getVendor());
                }
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getId() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem, session);
                    continue;
                }
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void nullifyByInventoryVendor(InventoryVendor inventoryVendor, Session session) {
        String hql = "UPDATE %s items SET items.%s = :vendor1, items.%s = :item WHERE items.%s = :vendor0";
        hql = String.format(hql, InventoryVendorItems.REF, InventoryVendorItems.PROP_VENDOR, InventoryVendorItems.PROP_ITEM, InventoryVendorItems.PROP_VENDOR);
        Query query = session.createQuery(hql);
        query.setParameter("vendor1", null);
        query.setParameter("item", null);
        query.setParameter("vendor0", (Object)inventoryVendor);
        query.executeUpdate();
    }
}

