/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.dao.BaseMenuModifierDAO;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierPageItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MenuModifierDAO
extends BaseMenuModifierDAO {
    private static final String EMPTY_NEWLINE_STRING = "\n";

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    private String constructExceptionDetailsByModifierGroup(MenuModifier menuModifier, List<ModifierGroup> modifierGroups) {
        if (modifierGroups != null && !modifierGroups.isEmpty()) {
            StringBuilder builder = new StringBuilder(menuModifier.getName() + " " + Messages.getString("MenuModifierDAO.1"));
            for (int i = 0; i < modifierGroups.size(); ++i) {
                String message = i + 1 + ". " + modifierGroups.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByModifier(MenuModifier menuModifier, List<String> itemNames) {
        if (itemNames != null && !itemNames.isEmpty()) {
            StringBuilder builder = new StringBuilder(menuModifier.getName() + " " + Messages.getString("MenuModifierDAO.2"));
            for (int i = 0; i < itemNames.size(); ++i) {
                String message = i + 1 + ". " + itemNames.get(i);
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return "";
    }

    private String constructExceptionDetailsByDefaultMenuModifier(MenuModifier menuModifier, List<String> menuItemNames) {
        if (menuItemNames != null && !menuItemNames.isEmpty()) {
            StringBuilder builder = new StringBuilder(menuModifier.getName() + " " + Messages.getString("MenuModifierDAO.3"));
            for (int i = 0; i < menuItemNames.size(); ++i) {
                String message = i + 1 + ". " + menuItemNames.get(i);
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    protected void delete(Object obj, Session session) {
        List<String> defaultMenuModifiers;
        List<String> menuItemNames;
        MenuModifier menuModifier = (MenuModifier)obj;
        if (menuModifier == null) {
            throw new PosException(Messages.getString("MenuModifierDAO.0"));
        }
        session.refresh(obj);
        StringBuilder details = new StringBuilder();
        List<ModifierGroup> modifierGroups = this.getModifierGroupByModifier(menuModifier, session);
        if (modifierGroups != null && !modifierGroups.isEmpty()) {
            details.append(this.constructExceptionDetailsByModifierGroup(menuModifier, modifierGroups));
            details.append(EMPTY_NEWLINE_STRING);
            details.append(EMPTY_NEWLINE_STRING);
        }
        if ((menuItemNames = this.getMenuItemNamesByModifier(menuModifier, session)) != null && !menuItemNames.isEmpty()) {
            details.append(this.constructExceptionDetailsByModifier(menuModifier, menuItemNames));
            details.append(EMPTY_NEWLINE_STRING);
            details.append(EMPTY_NEWLINE_STRING);
        }
        if ((defaultMenuModifiers = this.getMenuItemNamesByDefaultModifier(menuModifier, session)) != null && !defaultMenuModifiers.isEmpty()) {
            details.append(this.constructExceptionDetailsByDefaultMenuModifier(menuModifier, defaultMenuModifiers));
            details.append(EMPTY_NEWLINE_STRING);
        }
        String message = "Selected menu modifier is being used by others and cannot be deleted. Please select details to see who is using this Menu Modifier.";
        String detailsMessage = details.toString();
        if (StringUtils.isNotBlank((String)detailsMessage)) {
            throw new PosException(message, detailsMessage);
        }
        menuModifier.setDeleted(true);
        this.update(menuModifier, session);
    }

    private List<ModifierGroup> getModifierGroupByModifier(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(ModifierGroup.class);
        this.addDeletedFilter(criteria);
        criteria.createAlias("modifiers", "modifier");
        criteria.add(Restrictions.in((String)("modifier." + MenuModifier.PROP_ID), (Object[])new Object[]{menuModifier.getId()}));
        return criteria.list();
    }

    private List<String> getMenuItemNamesByModifier(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        this.addDeletedFilter(criteria, MenuItem.class);
        criteria.createAlias("menuItemModiferSpecs", "ms");
        criteria.createAlias("ms.modifierPages", "mp");
        criteria.createAlias("mp.pageItems", "i");
        criteria.add((Criterion)Restrictions.eq((String)("i." + MenuItemModifierPageItem.PROP_MENU_MODIFIER_ID), (Object)menuModifier.getId()));
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)));
        return criteria.list();
    }

    private List<String> getMenuItemNamesByDefaultModifier(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        this.addDeletedFilter(criteria, MenuItem.class);
        Criteria specs = criteria.createCriteria("menuItemModiferSpecs");
        specs.createAlias("defaultModifierList", "dml");
        specs.add(Restrictions.in((String)("dml." + DefaultMenuModifier.PROP_MODIFIER), (Object[])new Object[]{menuModifier}));
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)));
        return criteria.list();
    }

    private void deleteModifierFromModifierPageItem(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierPageItem.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemModifierPageItem.PROP_MENU_MODIFIER_ID, (Object)menuModifier.getId()));
        List pageItems = criteria.list();
        if (pageItems == null || pageItems.isEmpty()) {
            return;
        }
        for (MenuItemModifierPageItem pageItem : pageItems) {
            this.deletePageItemFromPage(pageItem, session);
        }
    }

    private void deletePageItemFromPage(MenuItemModifierPageItem pageItem, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierPage.class);
        criteria.createAlias("pageItems", "pageItem");
        criteria.add((Criterion)Restrictions.eq((String)("pageItem." + MenuItemModifierPage.PROP_ID), (Object)pageItem.getId()));
        List pages = criteria.list();
        for (MenuItemModifierPage page : pages) {
            page.getPageItems().remove(pageItem);
            MenuItemModifierPageDAO.getInstance().update(page, session);
        }
    }

    private void deleteModifierFromDefaultModifierList(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(MenuItemModifierSpec.class);
        criteria.createAlias("defaultModifierList", "m");
        criteria.add((Criterion)Restrictions.eq((String)"m.modifier", (Object)menuModifier));
        List modifierSpecs = criteria.list();
        if (modifierSpecs == null || modifierSpecs.isEmpty()) {
            return;
        }
        for (MenuItemModifierSpec itemModifierSpec : modifierSpecs) {
            List<DefaultMenuModifier> defaultModifiers = itemModifierSpec.getDefaultModifierList();
            if (defaultModifiers != null && defaultModifiers.size() > 0) {
                Iterator<DefaultMenuModifier> iterator = defaultModifiers.iterator();
                while (iterator.hasNext()) {
                    DefaultMenuModifier menuModifier2 = iterator.next();
                    if (!menuModifier2.getModifier().getId().equals(menuModifier.getId())) continue;
                    iterator.remove();
                }
            }
            MenuItemModifierSpecDAO.getInstance().update(itemModifierSpec, session);
        }
    }

    private void deleteModifierFromModifierGroup(MenuModifier menuModifier, Session session) {
        Criteria criteria = session.createCriteria(ModifierGroup.class);
        criteria.createAlias("modifiers", "modifier");
        criteria.add(Restrictions.in((String)("modifier." + MenuModifier.PROP_ID), Arrays.asList(menuModifier.getId())));
        List groups = criteria.list();
        if (groups == null || groups.isEmpty()) {
            return;
        }
        for (ModifierGroup modifierGroup : groups) {
            modifierGroup.getModifiers().remove(menuModifier);
            ModifierGroupDAO.getInstance().update(modifierGroup, session);
        }
    }

    public MenuModifier loadFullModifier(String menuModifierId) {
        MenuModifier menuModifier = this.get(menuModifierId);
        this.initialize(menuModifier);
        return menuModifier;
    }

    public void initialize(MenuModifier menuModifier) {
        if (menuModifier == null || menuModifier.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(menuModifier.getPizzaModifierPriceList()) && Hibernate.isInitialized(menuModifier.getMultiplierPriceList()) && Hibernate.isInitialized(menuModifier.getModifierGroups())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuModifier);
            Hibernate.initialize(menuModifier.getPizzaModifierPriceList());
            Hibernate.initialize(menuModifier.getMultiplierPriceList());
            Hibernate.initialize(menuModifier.getModifierGroups());
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<MenuModifier> getModifierList(String tagName) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)tagName)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_TAG, (Object)tagName));
            }
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuModifier> getMenuModifiers(String itemName) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(MenuModifier.class);
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)itemName)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
    }

    @Deprecated
    public int getRowCount(String searchString, boolean pizzaModifier) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if (pizzaModifier) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                int n = rowCount.intValue();
                return n;
            }
        }
        return 0;
    }

    public void loadItems(String searchString, boolean includeInvisibleItems, PaginatedListModel listModel) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if (!includeInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            listModel.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setData(criteria.list());
        }
    }

    public void loadItems(String searchString, boolean includeInvisibleItems, boolean pizzaModifier, BeanTableModel<MenuModifier> listModel) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString, (MatchMode)MatchMode.START));
            }
            if (pizzaModifier) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            } else {
                criteria.add((Criterion)Restrictions.ne((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)Boolean.TRUE));
            }
            if (!includeInvisibleItems) {
                criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_ENABLE, (Object)Boolean.TRUE));
            }
            listModel.setNumRows(this.rowCount(criteria));
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            criteria.setFirstResult(listModel.getCurrentRowIndex());
            criteria.setMaxResults(listModel.getPageSize());
            listModel.setRows(criteria.list());
        }
    }

    @Deprecated
    public List<MenuModifier> getComboModifiers() {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(MenuModifier.class);
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_COMBO_MODIFIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
    }

    public MenuModifier findName(String stringValue) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_NAME, (Object)stringValue));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                MenuModifier menuModifier = (MenuModifier)list.get(0);
                return menuModifier;
            }
            MenuModifier menuModifier = null;
            return menuModifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void loadMenuModifier(PaginationSupport paginationSupport, String itemName, ModifierGroup modifierGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.addDeletedFilter(criteria);
            this.updateCriteria(itemName, modifierGroup, criteria);
            Number rowCount = (Number)criteria.uniqueResult();
            if (rowCount != null) {
                paginationSupport.setNumRows(rowCount.intValue());
            }
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteria(itemName, modifierGroup, criteria);
            criteria.addOrder(Order.asc((String)MenuModifier.PROP_SORT_ORDER));
            paginationSupport.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateCriteria(String itemName, ModifierGroup modifierGroup, Criteria criteria) {
        this.addDeletedFilter(criteria);
        if (StringUtils.isNotEmpty((String)itemName)) {
            criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)itemName.trim(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (modifierGroup != null) {
            criteria.createAlias("modifierGroups", "groups");
            criteria.add((Criterion)Restrictions.eq((String)("groups." + ModifierGroup.PROP_ID), (Object)modifierGroup.getId()));
        }
    }

    public void removePizzaModifierPrices(List<String> listOfModifierPriceId, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("pizzaModifierPriceList", "modifierPrice");
        criteria.add(Restrictions.in((String)"modifierPrice.id", listOfModifierPriceId));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List list = criteria.list();
        if (list != null && !list.isEmpty()) {
            for (MenuModifier menuModifier : list) {
                List<PizzaModifierPrice> pizzaPriceList = menuModifier.getPizzaModifierPriceList();
                Iterator<PizzaModifierPrice> iterator = pizzaPriceList.iterator();
                while (iterator.hasNext()) {
                    PizzaModifierPrice pizzaModifierPrice = iterator.next();
                    if (!listOfModifierPriceId.contains(pizzaModifierPrice.getId())) continue;
                    iterator.remove();
                }
                session.update((Object)menuModifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMenuModifierFormData(MenuModifier menuModifier) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.createNewSession();
            tx = session.beginTransaction();
            this.saveOrUpdate(menuModifier, session);
            MenuItemModifierPageItemDAO menuPageItemDAO = MenuItemModifierPageItemDAO.getInstance();
            List<MenuItemModifierPageItem> menuItemModifierPageItems = menuPageItemDAO.getPageItemFor(menuModifier, session);
            if (menuItemModifierPageItems != null) {
                for (MenuItemModifierPageItem menuItemModifierPageItem : menuItemModifierPageItems) {
                    menuItemModifierPageItem.setMenuModifier(menuModifier);
                    menuPageItemDAO.saveOrUpdate(menuItemModifierPageItem, session);
                }
            }
            tx.commit();
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuModifier> getPizzaModifiers(String searchString) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuModifier.class);
            criteria.add((Criterion)Restrictions.eq((String)MenuModifier.PROP_PIZZA_MODIFIER, (Object)true));
            if (StringUtils.isNotEmpty((String)searchString)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)searchString.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            List list = criteria.list();
            return list;
        }
    }
}

