/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.BasePriceRuleDAO;
import com.floreantpos.util.ShiftUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class PriceRuleDAO
extends BasePriceRuleDAO {
    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    public List<PriceRule> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (!(obj instanceof PriceRule)) {
            throw new PosException(Messages.getString("PriceRuleDAO.0"));
        }
        PriceRule priceRule = (PriceRule)obj;
        priceRule.setDeleted(Boolean.TRUE);
        super.update(priceRule, s);
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getPrice(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, CustomerGroup customerGroup) {
        Session session = null;
        try {
            session = this.createNewSession();
            Double d = this.getPrice(menuItem, orderType, department, salesArea, customerGroup, session);
            return d;
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Double getPrice(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, CustomerGroup customerGroup, Session session) {
        List<String> filteredPriceShift = this.getFilteredPriceShift();
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.setProjection((Projection)Projections.property((String)PriceRule.PROP_PRICE_TABLE_ID));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_ORDER_TYPE_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_ORDER_TYPE_ID, (Object)(orderType == null ? null : orderType.getId()))));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_DEPARTMENT_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_DEPARTMENT_ID, (Object)(department == null ? null : department.getId()))));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_SALES_AREA_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_SALES_AREA_ID, (Object)(salesArea == null ? null : salesArea.getId()))));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_CUSTOMER_GROUP_ID), (Criterion)Restrictions.eq((String)PriceRule.PROP_CUSTOMER_GROUP_ID, (Object)(customerGroup == null ? null : customerGroup.getId()))));
        if (!filteredPriceShift.isEmpty()) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PriceRule.PROP_PRICE_SHIFT_ID), (Criterion)Restrictions.in((String)PriceRule.PROP_PRICE_SHIFT_ID, filteredPriceShift)));
        } else {
            criteria.add(Restrictions.isNull((String)PriceRule.PROP_PRICE_SHIFT_ID));
        }
        criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_ACTIVE, (Object)Boolean.TRUE));
        List list = criteria.list();
        if (list == null || list.isEmpty()) {
            return null;
        }
        criteria = session.createCriteria(PriceTableItem.class);
        criteria.setProjection((Projection)Projections.property((String)PriceTableItem.PROP_PRICE));
        criteria.add((Criterion)Restrictions.eq((String)PriceTableItem.PROP_MENU_ITEM_ID, (Object)menuItem.getId()));
        criteria.add(Restrictions.in((String)PriceTableItem.PROP_PRICE_TABLE_ID, (Collection)list));
        List prices = criteria.list();
        if (prices != null && prices.size() > 0) {
            if (prices.size() == 1) {
                return (Double)prices.get(0);
            }
            return (Double)Collections.min(prices);
        }
        return null;
    }

    private List<String> getFilteredPriceShift() {
        int firstPriorityValue = 1;
        ArrayList<String> filteredPriceShift = new ArrayList<String>();
        List<PriceShift> priceShifts = ShiftUtil.getCurrentPricShifts();
        if (priceShifts != null) {
            for (PriceShift priceShift : priceShifts) {
                Integer priorityValue = priceShift.getPriority();
                if (firstPriorityValue < priorityValue) continue;
                firstPriorityValue = priorityValue;
                filteredPriceShift.add(priceShift.getId());
            }
        }
        return filteredPriceShift;
    }

    public List<PriceRule> findByPriceShiftId(String shiftId, Session session) {
        return this.findByPriceShiftId(shiftId, session, Boolean.FALSE);
    }

    public List<PriceRule> findByPriceShiftId(String shiftId, Session session, boolean addDeletedFilter) {
        if (StringUtils.isBlank((String)shiftId)) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        if (addDeletedFilter) {
            this.addDeletedFilter(criteria);
        }
        criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_PRICE_SHIFT_ID, (Object)shiftId));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PriceRule.PROP_NAME), (String)PriceRule.PROP_NAME));
        criteria.setResultTransformer(Transformers.aliasToBean(PriceRule.class));
        return criteria.list();
    }

    public List<PriceRule> getPriceRulesByPriceTable(PriceTable priceTable, Session session) {
        if (priceTable == null || priceTable.getId() == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)PriceRule.PROP_PRICE_TABLE_ID, (Object)priceTable.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)PriceRule.PROP_NAME), (String)PriceRule.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }
}

